// 机械工厂战利品
ServerEvents.chestLootTables(event => {
    event.modify('mryh:create_factory_1', loot => {
        loot.addPool(pool => {
            pool.addItem('create:fluid_pipe').weight(25).count([1, 4]);
            pool.addItem('createaddition:zinc_sheet').weight(20).count([1, 3]);
            pool.addItem('createaddition:iron_rod').weight(15).count([1, 2]);
            pool.addItem('createaddition:electrum_ingot').weight(18).count([1, 4]);
            pool.addItem('create:cogwheel').weight(22).count([1, 3]);
            pool.addItem('create:powdered_obsidian').weight(17).count([1, 2]);
            pool.addItem('minecraft:slime_ball').weight(20).count([1, 4]);
            pool.addItem('create:brass_sheet').weight(23).count([1, 3]);
            pool.addItem('createaddition:capacitor').weight(19).count([1, 2]);
            pool.addItem('minecraft:gold_ingot').weight(22).count([1, 4]);
            pool.addItem('minecraft:gold_nugget').weight(16).count([1, 3]);
            pool.addItem('create:golden_sheet').weight(21).count([1, 2]);
            pool.addItem('zombiekit:alcohol').weight(24).count([1, 4]);
            pool.addItem('minecraft:glowstone_dust').weight(18).count([1, 3]);
            pool.addItem('minecraft:carrot').weight(20).count([1, 2]);
            pool.addItem('minecraft:feather').weight(23).count([1, 4]);
            pool.addItem('minecraft:emerald').weight(17).count([1, 3]);
            pool.addItem('apocalypsenow:textilethread').weight(19).count([1, 2]);
            pool.addItem('minecraft:paper').weight(22).count([1, 4]);
            pool.addItem('minecraft:redstone').weight(16).count([1, 3]);
            pool.addItem('minecraft:diamond').weight(21).count([1, 2]);
            pool.addItem('create:iron_sheet').weight(24).count([1, 4]);
            pool.addItem('minecraft:iron_nugget').weight(18).count([1, 3]);
            pool.addItem('minecraft:iron_ingot').weight(20).count([1, 2]);
            pool.addItem('createaddition:copper_rod').weight(23).count([1, 4]);
            pool.addItem('createaddition:copper_spool').weight(17).count([1, 3]);
            pool.addItem('minecraft:copper_ingot').weight(19).count([1, 2]);
            pool.addItem('create:zinc_ingot').weight(22).count([1, 4]);
            pool.addItem('minecraft:lapis_lazuli').weight(18).count([1, 3]);
            pool.addItem('minecraft:bone').weight(21).count([1, 2]);
            pool.addItem('minecraft:bone_meal').weight(24).count([1, 4]);
            pool.addItem('createaddition:brass_rod').weight(17).count([1, 3]);
            pool.addItem('createaddition:iron_wire').weight(20).count([1, 2]);
            pool.addItem('create:whisk').weight(23).count([1, 4]);
            pool.addItem('create:piston_extension_pole').weight(19).count([1, 3]);
            pool.addItem('create:fluid_tank').weight(22).count([1, 2]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(18).count([1, 4]);
            pool.addItem('minecraft:leather').weight(21).count([1, 3]);
            pool.addItem('createaddition:spool').weight(24).count([1, 2]);
            pool.addItem('minecraft:raw_gold').weight(17).count([1, 4]);
            pool.addItem('minecraft:raw_iron').weight(20).count([1, 3]);
            pool.addItem('minecraft:raw_copper').weight(23).count([1, 2]);
            pool.addItem('create:raw_zinc').weight(19).count([1, 4]);
            pool.addItem('minecraft:sugar').weight(22).count([1, 3]);
            pool.addItem('minecraft:amethyst_shard').weight(18).count([1, 2]);
            pool.addItem('minecraft:quartz').weight(21).count([1, 4]);
            pool.addItem('minecraft:book').weight(24).count([1, 3]);
            pool.addItem('create:shaft').weight(17).count([1, 2]);
            pool.addItem('create:belt_connector').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:plastic').weight(23).count([1, 3]);
            pool.addItem('apocalypsenow:plasticplate').weight(19).count([1, 2]);
            pool.addItem('minecraft:ink_sac').weight(22).count([1, 4]);
            pool.addItem('create:large_cogwheel').weight(18).count([1, 3]);
            pool.addItem('create:andesite_alloy').weight(21).count([1, 2]);
            pool.addItem('apocalypsenow:engineering_parts').weight(24).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(17).count([1, 3]);
            pool.addItem('minecraft:stick').weight(20).count([1, 2]);
            pool.addItem('minecraft:porkchop').weight(23).count([1, 4]);
            pool.addItem('minecraft:beef').weight(19).count([1, 3]);
            pool.addItem('minecraft:rabbit').weight(22).count([1, 2]);
            pool.addItem('minecraft:beetroot').weight(18).count([1, 4]);
            pool.addItem('createaddition:electrum_rod').weight(21).count([1, 3]);
            pool.addItem('minecraft:flint').weight(24).count([1, 2]);
            pool.addItem('minecraft:coal').weight(17).count([1, 4]);
            pool.addItem('minecraft:blaze_rod').weight(20).count([1, 3]);
            pool.addItem('minecraft:gunpowder').weight(23).count([1, 2]);
            pool.addItem('zombiekit:rubber').weight(19).count([1, 4]);
            pool.addItem('zombiekit:camphor').weight(22).count([1, 3]);
            pool.addItem('minecraft:charcoal').weight(18).count([1, 2]);
            pool.addItem('minecraft:mutton').weight(21).count([1, 4]);
            pool.addItem('minecraft:cod').weight(24).count([1, 3]);
            pool.addItem('minecraft:chicken').weight(17).count([1, 2]);
            pool.addItem('apocalypsenow:money').weight(20).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:create_factory_2', loot => {
        loot.addPool(pool => {
            pool.addItem('create:brass_casing').weight(23).count([1, 4]);
            pool.addItem('create:sail_frame').weight(19).count([1, 3]);
            pool.addItem('create:white_sail').weight(25).count([1, 2]);
            pool.addItem('create:zinc_ingot').weight(18).count([1, 4]);
            pool.addItem('create:encased_chain_drive').weight(22).count([1, 3]);
            pool.addItem('createaddition:copper_spool').weight(17).count([1, 2]);
            pool.addItem('create:copper_sheet').weight(24).count([1, 4]);
            pool.addItem('createaddition:copper_rod').weight(20).count([1, 3]);
            pool.addItem('create:cogwheel').weight(16).count([1, 2]);
            pool.addItem('create:hand_crank').weight(21).count([1, 4]);
            pool.addItem('create:propeller').weight(22).count([1, 3]);
            pool.addItem('create:stressometer').weight(19).count([1, 2]);
            pool.addItem('create:andesite_casing').weight(24).count([1, 4]);
            pool.addItem('create:andesite_alloy').weight(17).count([1, 3]);
            pool.addItem('create:large_cogwheel').weight(20).count([1, 2]);
            pool.addItem('create:adjustable_chain_gearshift').weight(23).count([1, 4]);
            pool.addItem('create:gearshift').weight(18).count([1, 3]);
            pool.addItem('create:gearbox').weight(21).count([1, 2]);
            pool.addItem('create:shaft').weight(25).count([1, 4]);
            pool.addItem('create:belt_connector').weight(19).count([1, 3]);
            pool.addItem('createaddition:electrum_rod').weight(22).count([1, 2]);
            pool.addItem('create:rose_quartz').weight(17).count([1, 4]);
            pool.addItem('createaddition:electrum_ingot').weight(20).count([1, 3]);
            pool.addItem('create:polished_rose_quartz').weight(23).count([1, 2]);
            pool.addItem('create:clutch').weight(18).count([1, 4]);
            pool.addItem('createaddition:spool').weight(24).count([1, 3]);
            pool.addItem('create:vertical_gearbox').weight(19).count([1, 2]);
            pool.addItem('create:speedometer').weight(22).count([1, 4]);
            pool.addItem('create:golden_sheet').weight(17).count([1, 3]);
            pool.addItem('createaddition:iron_rod').weight(21).count([1, 2]);
            pool.addItem('create:iron_sheet').weight(25).count([1, 4]);
            pool.addItem('create:copper_casing').weight(18).count([1, 3]);
            pool.addItem('create:powdered_obsidian').weight(20).count([1, 2]);
            pool.addItem('create:brass_ingot').weight(23).count([1, 4]);
            pool.addItem('create:brass_sheet').weight(19).count([1, 3]);
            pool.addItem('createaddition:brass_rod').weight(24).count([1, 2]);
            pool.addItem('create:fluid_pipe').weight(17).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:create_factory_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:create_factory_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_create_factory = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "createaddition:gold_wire",
        "createaddition:gold_spool",
        "createaddition:diamond_grit",
        "create:whisk",
        "createaddition:barbed_wire",
        "create:mechanical_crafter",
        "createaddition:iron_wire",
        "createaddition:biomass",
        "createaddition:capacitor",
        "create:fluid_valve",
        "create:fluid_pipe",
        "createaddition:zinc_sheet",
        "createaddition:iron_rod",
        "create:spout",
        "create:brown_toolbox",
        "create:copper_diving_boots",
        "create:copper_valve_handle",
        "createaddition:electrum_spool",
        "createaddition:electrum_wire",
        "createaddition:electrum_sheet",
        "createaddition:electrum_rod",
        "createaddition:festive_spool",
        "createaddition:connector",
        "createaddition:large_connector",
        "createaddition:straw",
        "createaddition:diamond_grit_sandpaper",
        "createaddition:alternator",
        "createaddition:copper_rod",
        "create:piston_extension_pole",
        "createaddition:small_light_connector",
        "createaddition:spool",
        "createaddition:copper_wire",
        "createaddition:copper_spool",
        "create:fluid_tank"
    ],
    // 幸运6+
    luck6: [
        "create:portable_fluid_interface",
        "create:portable_storage_interface",
        "create:cart_assembler",
        "createaddition:electric_motor",
        "create:deployer",
        "create:redstone_contact",
        "create:windmill_bearing",
        "create:sticky_mechanical_piston",
        "create:sticker",
        "create:item_drain",
        "create:mechanical_roller",
        "create:mechanical_harvester",
        "create:mechanical_piston",
        "create:mechanical_plough",
        "create:mechanical_bearing",
        "create:mechanical_drill",
        "create:mechanical_saw",
        "create:elevator_pulley",
        "create:clockwork_bearing",
        "create:sequenced_gearshift",
        "create:radial_chassis",
        "create:secondary_linear_chassis",
        "create:rotation_speed_controller",
        "create:gantry_carriage",
        "createaddition:modular_accumulator",
        "create:steam_engine",
        "create:rope_pulley"
    ],
    // 困难模式
    hardMode: [

    ],
    // TAG
    TagMode: [
        "createaddition:brass_rod",
        "createaddition:gold_rod",
        "create:smart_fluid_pipe",
        "create:tree_fertilizer",
        "create:copper_diving_helmet",
        "create:copper_casing",
        "create:hose_pulley",
        "create:gantry_shaft",
        "create:steam_whistle",
        "create:minecart_coupling",
        "create:netherite_diving_helmet",
        "create:netherite_diving_boots",
        "create:railway_casing",
        "create:mechanical_pump",
        "create:contraption_controls",
        "create:goggles",
        "create:super_glue",
        "create:propeller",
        "create:controller_rail"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/create_factory.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_create_factory, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_create_factory, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});