// 别墅战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:villa_1', loot => {
        loot.addPool(pool => {
            pool.addItem('apocalypsenow:open_canned_tomatos').weight(42).count([1, 4]);
            pool.addItem('apocalypsenow:beer').weight(35).count([1, 4]);
            pool.addItem('apocalypsenow:coffee').weight(40).count([1, 4]);
            pool.addItem('apocalypsenow:coke').weight(43).count([1, 4]);
            pool.addItem('apocalypsenow:mre').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:military_canteen').weight(50).count([1, 4]);
            pool.addItem('apocalypsenow:vodka').weight(25).count([1, 4]);
            pool.addItem('apocalypsenow:porpsi').weight(41).count([1, 4]);
            pool.addItem('apocalypsenow:canned_beetroot').weight(36).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_pork').weight(32).count([1, 4]);
            pool.addItem('minecraft:baked_potato').weight(45).count([1, 4]);
            pool.addItem('minecraft:pufferfish').weight(15).count([1, 4]);
            pool.addItem('apocalypsenow:contaminated_water').weight(25).count([1, 4]);
            pool.addItem('apocalypsenow:water').weight(60).count([1, 4]);
            pool.addItem('apocalypsenow:orangejuicebox').weight(44).count([1, 4]);
            pool.addItem('apocalypsenow:orange_juice').weight(42).count([1, 4]);
            pool.addItem('apocalypsenow:peach_juice').weight(40).count([1, 4]);
            pool.addItem('minecraft:cookie').weight(50).count([1, 4]);
            pool.addItem('apocalypsenow:sugar_free_soda').weight(38).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_fish').weight(33).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_food').weight(35).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_chili').weight(31).count([1, 4]);
            pool.addItem('apocalypsenow:macandcheese').weight(28).count([1, 4]);
            pool.addItem('apocalypsenow:cheese').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:cream_cracker').weight(48).count([1, 4]);
            pool.addItem('apocalypsenow:large_soda').weight(41).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_beetroot').weight(32).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_melon').weight(29).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_pork').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_rabbit_soup').weight(27).count([1, 4]);
            pool.addItem('minecraft:dried_kelp').weight(40).count([1, 4]);
            pool.addItem('apocalypsenow:chocolate_bar').weight(46).count([1, 4]);
            pool.addItem('apocalypsenow:whisky').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_beans').weight(34).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_strawberry').weight(28).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_carrot').weight(31).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_rabbit_soup').weight(26).count([1, 4]);
            pool.addItem('minecraft:tropical_fish').weight(20).count([1, 4]);
            pool.addItem('minecraft:cooked_salmon').weight(38).count([1, 4]);
            pool.addItem('minecraft:cooked_mutton').weight(36).count([1, 4]);
            pool.addItem('minecraft:cooked_porkchop').weight(34).count([1, 4]);
            pool.addItem('minecraft:cooked_rabbit').weight(32).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_chicken_wing').weight(29).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_fish').weight(31).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_chilie').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:dogs_food').weight(18).count([1, 4]);
            pool.addItem('minecraft:sweet_berries').weight(47).count([1, 4]);
            pool.addItem('apocalypsenow:canned_chili').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:canned_soup').weight(33).count([1, 4]);
            pool.addItem('apocalypsenow:vitamins').weight(15).count([1, 4]);
            pool.addItem('minecraft:chicken').weight(44).count([1, 4]);
            pool.addItem('minecraft:cod').weight(42).count([1, 4]);
            pool.addItem('minecraft:salmon').weight(40).count([1, 4]);
            pool.addItem('minecraft:mutton').weight(38).count([1, 4]);
            pool.addItem('apocalypsenow:canned_water').weight(55).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_soup').weight(28).count([1, 4]);
            pool.addItem('apocalypsenow:canned_pork').weight(34).count([1, 4]);
            pool.addItem('minecraft:cooked_cod').weight(36).count([1, 4]);
            pool.addItem('minecraft:cooked_chicken').weight(35).count([1, 4]);
            pool.addItem('apocalypsenow:milk').weight(45).count([1, 4]);
            pool.addItem('minecraft:cooked_beef').weight(33).count([1, 4]);
            pool.addItem('apocalypsenow:open_dogs_food').weight(16).count([1, 4]);
            pool.addItem('apocalypsenow:open_canned_corn').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:canned_corn').weight(32).count([1, 4]);
            pool.addItem('minecraft:porkchop').weight(40).count([1, 4]);
            pool.addItem('minecraft:beef').weight(42).count([1, 4]);
            pool.addItem('minecraft:rabbit').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_soup').weight(29).count([1, 4]);
            pool.addItem('apocalypsenow:donut').weight(43).count([1, 4]);
            pool.addItem('minecraft:beetroot').weight(46).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_beans').weight(32).count([1, 4]);
            pool.addItem('apocalypsenow:cooked_canned_food').weight(33).count([1, 4]);
            pool.addItem('apocalypsenow:canned_tomatos').weight(35).count([1, 4]);
            pool.addItem('apocalypsenow:canned_carrot').weight(37).count([1, 4]);
            pool.addItem('minecraft:rotten_flesh').weight(10).count([1, 4]);
            pool.addItem('apocalypsenow:energy_drink').weight(39).count([1, 4]);
            pool.addItem('minecraft:carrot').weight(48).count([1, 4]);
            pool.addItem('apocalypsenow:canned_fish').weight(34).count([1, 4]);
            pool.addItem('apocalypsenow:canned_food').weight(36).count([1, 4]);
            pool.addItem('apocalypsenow:canned_strawberry').weight(31).count([1, 4]);
            pool.addItem('minecraft:apple').weight(50).count([1, 4]);
            pool.addItem('minecraft:spider_eye').weight(12).count([1, 4]);
            pool.addItem('minecraft:melon_slice').weight(45).count([1, 4]);
            pool.addItem('apocalypsenow:cereal').weight(40).count([1, 4]);
            pool.addItem('minecraft:bread').weight(52).count([1, 4]);
            pool.addItem('minecraft:potato').weight(49).count([1, 4]);
            pool.addItem('apocalypsenow:grape_juice').weight(41).count([1, 4]);
            pool.addItem('apocalypsenow:nutrition_bar').weight(42).count([1, 4]);
            pool.addItem('apocalypsenow:grapejuicebox').weight(40).count([1, 4]);
            pool.addItem('apocalypsenow:butter').weight(29).count([1, 4]);
            pool.addItem('apocalypsenow:chicken_wing').weight(28).count([1, 4]);
            pool.addItem('apocalypsenow:apple_juice').weight(43).count([1, 4]);
            pool.addItem('apocalypsenow:applejuicebox').weight(42).count([1, 4]);
            pool.addItem('minecraft:cake').weight(14).count([1, 4]);
            pool.addItem('apocalypsenow:chips').weight(41).count([1, 4]);
            pool.addItem('apocalypsenow:canned_rabbit_soup').weight(32).count([1, 4]);
            pool.addItem('apocalypsenow:canned_beans').weight(38).count([1, 4]);

            // 工具/杂物（同样带 .count([1, 4])）
            pool.addItem('minecraft:iron_pickaxe').weight(18);
            pool.addItem('minecraft:iron_axe').weight(19);
            pool.addItem('minecraft:diamond_axe').weight(8);
            pool.addItem('minecraft:skeleton_skull').weight(5);
            pool.addItem('minecraft:zombie_head').weight(5);
            pool.addItem('apocalypsenow:cellphone').weight(12);
            pool.addItem('apocalypsenow:watch').weight(25);
            pool.addItem('apocalypsenow:goldenwatch').weight(10);
            pool.addItem('minecraft:clock').weight(26);
            pool.addItem('apocalypsenow:toothbrush').weight(40);
            pool.addItem('apocalypsenow:toothpaste').weight(38);
            pool.addItem('minecraft:charcoal').weight(55).count([1, 4]);
            pool.addItem('minecraft:stick').weight(70).count([1, 4]);
            pool.addItem('apocalypsenow:nonalcoholic_beer').weight(36).count([1, 4]);
            pool.addItem('apocalypsenow:newspaper').weight(45).count([1, 4]);
            pool.addItem('apocalypsenow:plasticplate').weight(48).count([1, 4]);
            pool.addItem('apocalypsenow:pet_bottle').weight(50).count([1, 4]);
            pool.addItem('minecraft:ink_sac').weight(35).count([1, 4]);
            pool.addItem('minecraft:wheat').weight(52).count([1, 4]);
            pool.addItem('apocalypsenow:engineering_parts').weight(15).count([1, 4]);
            pool.addItem('apocalypsenow:bloodybandages').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(46).count([1, 4]);
            pool.addItem('apocalypsenow:can_opener').weight(30).count([1, 4]);
            pool.addItem('minecraft:flint_and_steel').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:antibiotics').weight(18).count([1, 4]);
            pool.addItem('apocalypsenow:plastic').weight(47).count([1, 4]);
            pool.addItem('minecraft:name_tag').weight(20).count([1, 4]);
            pool.addItem('minecraft:glow_berries').weight(40).count([1, 4]);
            pool.addItem('minecraft:shears').weight(16).count([1, 4]);
            pool.addItem('apocalypsenow:purificationtablets').weight(24).count([1, 4]);
            pool.addItem('minecraft:rabbit_foot').weight(28).count([1, 4]);
            pool.addItem('supplementaries:flax').weight(38).count([1, 4]);
            pool.addItem('minecraft:book').weight(45).count([1, 4]);
            pool.addItem('minecraft:quartz').weight(42).count([1, 4]);
            pool.addItem('minecraft:nether_wart').weight(32).count([1, 4]);
            pool.addItem('apocalypsenow:aabattery').weight(26).count([1, 4]);

            // 日常杂物（带 .count([1, 4])）
            pool.addItem('minecraft:paper').weight(58).count([1, 4]);
            pool.addItem('apocalypsenow:papertrash').weight(54).count([1, 4]);
            pool.addItem('minecraft:string').weight(56).count([1, 4]);
            pool.addItem('apocalypsenow:textilethread').weight(48).count([1, 4]);
            pool.addItem('apocalypsenow:bandage').weight(44).count([1, 4]);
            pool.addItem('apocalypsenow:can').weight(52).count([1, 4]);
            pool.addItem('minecraft:feather').weight(50).count([1, 4]);
            pool.addItem('apocalypsenow:ducttape').weight(42).count([1, 4]);
            pool.addItem('minecraft:raw_copper').weight(50).count([1, 4]);
            pool.addItem('minecraft:raw_iron').weight(48).count([1, 4]);
            pool.addItem('minecraft:raw_gold').weight(34).count([1, 4]);
            pool.addItem('apocalypsenow:bottle').weight(53).count([1, 4]);
            pool.addItem('apocalypsenow:emptyshampoo').weight(40).count([1, 4]);
            pool.addItem('apocalypsenow:rags').weight(46).count([1, 4]);
            pool.addItem('minecraft:leather').weight(44).count([1, 4]);
            pool.addItem('apocalypsenow:tomato').weight(47).count([1, 4]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(43).count([1, 4]);
            pool.addItem('apocalypsenow:lettuce').weight(48).count([1, 4]);
            pool.addItem('minecraft:glass_bottle').weight(51).count([1, 4]);
            pool.addItem('apocalypsenow:foam').weight(41).count([1, 4]);
            pool.addItem('minecraft:kelp').weight(49).count([1, 4]);
            pool.addItem('minecraft:prismarine_crystals').weight(26).count([1, 4]);
            pool.addItem('minecraft:prismarine_shard').weight(28).count([1, 4]);
            pool.addItem('minecraft:sponge').weight(24).count([1, 4]);
            pool.addItem('apocalypsenow:cleanrags').weight(42).count([1, 4]);
            pool.addItem('minecraft:torch').weight(54).count([1, 4]);
            pool.addItem('minecraft:gunpowder').weight(40).count([1, 4]);
            pool.addItem('minecraft:coal').weight(56).count([1, 4]);
            pool.addItem('minecraft:flint').weight(52).count([1, 4]);
            pool.addItem('apocalypsenow:oil_canister').weight(36).count([1, 4]);
            pool.addItem('minecraft:poisonous_potato').weight(16).count([1, 4]);
            pool.addItem('apocalypsenow:pain_killers').weight(40).count([1, 4]);
            pool.addItem('apocalypsenow:orange').weight(45).count([1, 4]);
            pool.addItem('apocalypsenow:marmalade').weight(37).count([1, 4]);
            pool.addItem('apocalypsenow:magazine').weight(35).count([1, 4]);
            pool.addItem('minecraft:ender_pearl').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:cigarettes').weight(28).count([1, 4]);
            pool.addItem('minecraft:lapis_lazuli').weight(38).count([1, 4]);
            pool.addItem('apocalypsenow:sawi').weight(34).count([1, 4]);
            pool.addItem('minecraft:copper_ingot').weight(30).count([1, 4]);
            pool.addItem('minecraft:redstone').weight(44).count([1, 4]);
            pool.addItem('minecraft:iron_ingot').weight(32).count([1, 4]);
            pool.addItem('minecraft:iron_nugget').weight(54).count([1, 4]);
            pool.addItem('minecraft:bucket').weight(20).count([1, 4]);
            pool.addItem('minecraft:glowstone_dust').weight(36).count([1, 4]);
            pool.addItem('minecraft:scute').weight(18).count([1, 4]);
            pool.addItem('minecraft:egg').weight(46).count([1, 4]);
            pool.addItem('minecraft:slime_ball').weight(38).count([1, 4]);
            pool.addItem('minecraft:brick').weight(40).count([1, 4]);
            pool.addItem('supplementaries:candy').weight(50).count([1, 4]);
            pool.addItem('minecraft:bone').weight(48).count([1, 4]);
            pool.addItem('minecraft:bone_meal').weight(50).count([1, 4]);
            pool.addItem('apocalypsenow:money').weight(30).count([1, 4]);
            pool.addItem('apocalypsenow:nailbox').weight(26).count([1, 4]);
            pool.addItem('apocalypsenow:needle').weight(28).count([1, 4]);
            pool.addItem('minecraft:gold_ingot').weight(24).count([1, 4]);
            pool.addItem('minecraft:amethyst_shard').weight(28).count([1, 4]);
            pool.addItem('minecraft:gold_nugget').weight(46).count([1, 4]);
            pool.addItem('apocalypsenow:bloodbag').weight(17).count([1, 4]);
            pool.addItem('minecraft:cobweb').weight(21).count([1, 4]);
            pool.addItem('apocalypsenow:wine').weight(23).count([1, 4]);
            pool.addItem('farmersdelight:cooked_salmon_slice').weight(36).count([1, 4]);
            pool.addItem('farmersdelight:salmon_slice').weight(34).count([1, 4]);
            pool.addItem('farmersdelight:cod_slice').weight(35).count([1, 4]);
            pool.addItem('farmersdelight:apple_cider').weight(40).count([1, 4]);
            pool.addItem('farmersdelight:melon_juice').weight(38).count([1, 4]);
            pool.addItem('farmersdelight:rice_panicle').weight(45).count([1, 4]);
            pool.addItem('farmersdelight:rotten_tomato').weight(20).count([1, 4]);
            pool.addItem('farmersdelight:tomato_seeds').weight(48).count([1, 4]);
            pool.addItem('farmersdelight:rice').weight(46).count([1, 4]);
            pool.addItem('farmersdelight:raw_pasta').weight(42).count([1, 4]);
            pool.addItem('farmersdelight:wheat_dough').weight(50).count([1, 4]);
            pool.addItem('farmersdelight:tomato_sauce').weight(44).count([1, 4]);
            pool.addItem('farmersdelight:cabbage').weight(47).count([1, 4]);
            pool.addItem('farmersdelight:tomato').weight(49).count([1, 4]);
            pool.addItem('farmersdelight:onion').weight(48).count([1, 4]);
            pool.addItem('farmersdelight:mutton_chops').weight(38).count([1, 4]);
            pool.addItem('farmersdelight:cooked_mutton_chops').weight(35).count([1, 4]);
            pool.addItem('farmersdelight:ham').weight(37).count([1, 4]);
            pool.addItem('farmersdelight:cooked_chicken_cuts').weight(40).count([1, 4]);
            pool.addItem('farmersdelight:chicken_cuts').weight(43).count([1, 4]);
            pool.addItem('farmersdelight:beef_patty').weight(39).count([1, 4]);
            pool.addItem('farmersdelight:chocolate_pie').weight(24).count([1, 4]);
            pool.addItem('farmersdelight:sweet_berry_cheesecake').weight(22).count([1, 4]);
            pool.addItem('farmersdelight:apple_pie').weight(26).count([1, 4]);
            pool.addItem('farmersdelight:pie_crust').weight(41).count([1, 4]);
            pool.addItem('farmersdelight:smoked_ham').weight(34).count([1, 4]);
            pool.addItem('farmersdelight:bacon').weight(40).count([1, 4]);
            pool.addItem('farmersdelight:hot_cocoa').weight(37).count([1, 4]);
            pool.addItem('farmersdelight:milk_bottle').weight(45).count([1, 4]);
            pool.addItem('farmersdelight:fried_egg').weight(46).count([1, 4]);
            pool.addItem('farmersdelight:honey_cookie').weight(44).count([1, 4]);
            pool.addItem('farmersdelight:melon_popsicle').weight(36).count([1, 4]);
            pool.addItem('farmersdelight:glow_berry_custard').weight(32).count([1, 4]);
            pool.addItem('farmersdelight:fruit_salad').weight(30).count([1, 4]);
            pool.addItem('farmersdelight:nether_salad').weight(28).count([1, 4]);
            pool.addItem('farmersdelight:barbecue_stick').weight(38).count([1, 4]);
            pool.addItem('farmersdelight:chocolate_pie_slice').weight(20).count([1, 4]);
            pool.addItem('farmersdelight:sweet_berry_cheesecake_slice').weight(18).count([1, 4]);
            pool.addItem('farmersdelight:cake_slice').weight(19).count([1, 4]);
            pool.addItem('farmersdelight:minced_beef').weight(41).count([1, 4]);
            pool.addItem('farmersdelight:cabbage_leaf').weight(49).count([1, 4]);
            pool.addItem('farmersdelight:pumpkin_slice').weight(43).count([1, 4]);

            // 空抽 & 次数
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:villa_2', loot => {
        loot.addPool(pool => {
            // 1. 即食/切片类（带 .count([1,4])）
            pool.addItem('farmersdelight:chocolate_pie_slice').weight(20).count([1, 4]);
            pool.addItem('farmersdelight:sweet_berry_cheesecake_slice').weight(18).count([1, 4]);
            pool.addItem('farmersdelight:cake_slice').weight(19).count([1, 4]);
            pool.addItem('farmersdelight:minced_beef').weight(41).count([1, 4]);
            pool.addItem('farmersdelight:cabbage_leaf').weight(49).count([1, 4]);
            pool.addItem('farmersdelight:pumpkin_slice').weight(43).count([1, 4]);

            // 2. 高级/稀有材料（无 count）
            pool.addItem('zombiekit:special_steel_sheet').weight(6);
            pool.addItem('zombiekit:machine_gun_components').weight(5);
            pool.addItem('zombiekit:bulletproof_insert').weight(7);
            pool.addItem('zombiekit:plastics').weight(25);
            pool.addItem('zombiekit:nitrocellulose').weight(20);
            pool.addItem('zombiekit:hydrogen_nitrate').weight(18);
            pool.addItem('zombiekit:crude_nitrate').weight(22);
            pool.addItem('zombiekit:saltpeter').weight(24);
            pool.addItem('zombiekit:desert_camouflage_dye').weight(26);
            pool.addItem('zombiekit:drone_components').weight(4);
            pool.addItem('zombiekit:special_ceramics').weight(5);

            // 3. 普通化学品/原料（带 .count([1,4])）
            pool.addItem('zombiekit:saltpeter_soil').weight(30).count([1, 4]);
            pool.addItem('zombiekit:saltpeter_bucket').weight(15).count([1, 4]);
            pool.addItem('zombiekit:sulfur').weight(32).count([1, 4]);
            pool.addItem('zombiekit:smokeless_gunpowder').weight(12).count([1, 4]);
            pool.addItem('zombiekit:iron_wire').weight(40).count([1, 4]);
            pool.addItem('zombiekit:alcohol').weight(35).count([1, 4]);
            pool.addItem('zombiekit:camphor').weight(28).count([1, 4]);
            pool.addItem('zombiekit:latex').weight(34).count([1, 4]);
            pool.addItem('zombiekit:rubber').weight(32).count([1, 4]);
            pool.addItem('zombiekit:fibre').weight(42).count([1, 4]);
            pool.addItem('zombiekit:cloth').weight(38).count([1, 4]);
            pool.addItem('zombiekit:quartz_sand').weight(44).count([1, 4]);

            // 4. 食物/饮品/实验品（带 .count([1,4])）
            pool.addItem('zombie_extreme:soda_used').weight(35).count([1, 4]);
            pool.addItem('zombie_extreme:canned_food').weight(36).count([1, 4]);
            pool.addItem('zombie_extreme:canned_beans').weight(38).count([1, 4]);
            pool.addItem('zombie_extreme:canned_soup').weight(34).count([1, 4]);
            pool.addItem('zombie_extreme:canned_fruit').weight(33).count([1, 4]);
            pool.addItem('zombie_extreme:canned_stew').weight(32).count([1, 4]);
            pool.addItem('zombie_extreme:green_apple').weight(40).count([1, 4]);
            pool.addItem('zombie_extreme:rotten_apple').weight(15).count([1, 4]);
            pool.addItem('zombie_extreme:canned_apples').weight(31).count([1, 4]);
            pool.addItem('zombie_extreme:dog_food').weight(18).count([1, 4]);
            pool.addItem('zombiekit:death_bat').weight(8).count([1, 4]);
            pool.addItem('zombiekit:snow_camouflage_dye').weight(24).count([1, 4]);

            // 5. 空抽
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })
    event.modify('mryh:villa_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:villa_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_villa = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "apocalypsenow:hazmat_suit_helmet",
        "apocalypsenow:hazmat_suit_boots",
        "apocalypsenow:hazmat_suit_chestplate",
        "apocalypsenow:hazmat_suit_leggings",
        "zombie_extreme:batteries",
        "zombie_extreme:ignot_aluminum",
        "zombie_extreme:energy_battery",
        "zombie_extreme:ruby",
        "zombie_extreme:ignot_bronze",
        "zombie_extreme:infected_flesh",
        "zombie_extreme:circuit_diagram",
        "zombie_extreme:bronze_nugget",
        "zombie_extreme:raw_aluminum",
        "zombie_extreme:raw_steel",
        "zombie_extreme:steel_bar",
        "zombie_extreme:steel_plate",
        "zombie_extreme:titan_nugget",
        "zombie_extreme:ignot_titan",
        "zombie_extreme:uranium",
        "zombie_extreme:uranium_rod",
        "zombie_extreme:thorium_rod",
        "zombie_extreme:fulguria_fuel_rod",
        "zombie_extreme:saw_blade",
        "zombie_extreme:rubber",
        "zombie_extreme:oil_shale",
        "zombie_extreme:raw_lead",
        "zombie_extreme:raw_tin",
        "zombie_extreme:rubber_sheet",
        "zombie_extreme:tin_plate",
        "zombie_extreme:bronze_wire"
    ],
    // 幸运6+
    luck6: [
        "artifacts:snowshoes",
        "artifacts:bunny_hoppers",
        "artifacts:scarf_of_invisibility",
        "artifacts:lucky_scarf",
        "artifacts:cowboy_hat",
        "artifacts:anglers_hat",
        "artifacts:kitty_slippers",
        "artifacts:everlasting_beef",
        "apocalypsenow:spec_ops_helmet",
        "artifacts:panic_necklace",
        "artifacts:shock_pendant",
        "artifacts:flame_pendant",
        "artifacts:thorn_pendant",
        "artifacts:charm_of_sinking",
        "artifacts:cloud_in_a_bottle",
        "artifacts:obsidian_skull",
        "artifacts:onion_ring",
        "artifacts:rooted_boots",
        "tacz:modern_kinetic_gun"
    ],
    // 困难模式
    hardMode: [

    ],
    // TAG
    TagMode: [

    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [
            "emxarms:emx_pulse",
            "helldiver2:r36_eruptor",
            "emxarms:emx_mac100",
            "emxarms:emx_mac50",
            "emxarms:emx_kund50ex",
            "emxarms:emx_pulsex2",
            "helldiver2:authorized_gun",
            "bluearchive:ayane",
            "helldiver2:p19_redeemer",
            "cyber_armorer:unity",
            "cyber_armorer:yukimura",
            "cyber_armorer:unity_her_majesty",
            "helldiver2:p2_peacemaker"
        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    }
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/villa.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_villa, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_villa, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});
