// 办公楼战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:office_1', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:copper_ingot').weight(25).count([1, 4]);
            pool.addItem('minecraft:iron_ingot').weight(30).count([1, 3]);
            pool.addItem('minecraft:stick').weight(15).count([1, 2]);
            pool.addItem('minecraft:charcoal').weight(20).count([1, 4]);
            pool.addItem('minecraft:quartz').weight(25).count([1, 3]);
            pool.addItem('apocalypsenow:money').weight(30).count([1, 2]);
            pool.addItem('sophisticatedbackpacks:smoking_upgrade').weight(15).count([1, 4]);
            pool.addItem('sophisticatedbackpacks:smelting_upgrade').weight(20).count([1, 3]);
            pool.addItem('sophisticatedbackpacks:crafting_upgrade').weight(25).count([1, 2]);
            pool.addItem('minecraft:paper').weight(15).count([1, 4]);
            pool.addItem('zombiekit:alcohol').weight(20).count([1, 3]);
            pool.addItem('refinedstorage:silicon').weight(25).count([1, 2]);
            pool.addItem('refinedstorage:processor_binding').weight(30).count([1, 4]);
            pool.addItem('refinedstorage:raw_basic_processor').weight(15).count([1, 3]);
            pool.addItem('refinedstorage:cable').weight(20).count([1, 2]);
            pool.addItem('refinedstorage:improved_processor').weight(25).count([1, 4]);
            pool.addItem('refinedstorage:basic_processor').weight(15).count([1, 3]);
            pool.addItem('refinedstorage:raw_improved_processor').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:textilethread').weight(25).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(30).count([1, 3]);
            pool.addItem('minecraft:gold_ingot').weight(15).count([1, 2]);
            pool.addItem('minecraft:blaze_rod').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:engineering_parts').weight(25).count([1, 3]);
            pool.addItem('minecraft:diamond').weight(30).count([1, 2]);
            pool.addItem('minecraft:emerald').weight(15).count([1, 4]);
            pool.addItem('zombiekit:rubber').weight(20).count([1, 3]);
            pool.addItem('minecraft:lapis_lazuli').weight(25).count([1, 2]);
            pool.addItem('minecraft:redstone').weight(30).count([1, 4]);
            pool.addItem('minecraft:raw_gold').weight(15).count([1, 3]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(20).count([1, 2]);
            pool.addItem('sophisticatedbackpacks:upgrade_base').weight(25).count([1, 4]);
            pool.addItem('sophisticatedstorage:basic_to_iron_tier_upgrade').weight(30).count([1, 3]);
            pool.addItem('sophisticatedstorage:copper_to_iron_tier_upgrade').weight(15).count([1, 2]);
            pool.addItem('zombiekit:camphor').weight(20).count([1, 4]);
            pool.addItem('minecraft:slime_ball').weight(25).count([1, 3]);
            pool.addItem('minecraft:rabbit').weight(30).count([1, 2]);
            pool.addItem('apocalypsenow:plastic').weight(15).count([1, 4]);
            pool.addItem('apocalypsenow:plasticplate').weight(20).count([1, 3]);
            pool.addItem('minecraft:book').weight(25).count([1, 2]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:office_2', loot => {
        loot.addPool(pool => {
            pool.addItem('sophisticatedstorage:pickup_upgrade').weight(22).count([1, 3]);
            pool.addItem('sophisticatedstorage:advanced_filter_upgrade').weight(20).count([1, 2]);
            pool.addItem('sophisticatedstorage:advanced_magnet_upgrade').weight(18).count([1, 4]);
            pool.addItem('sophisticatedstorage:advanced_pickup_upgrade').weight(25).count([1, 3]);
            pool.addItem('sophisticatedstorage:stack_upgrade_tier_1').weight(15).count([1, 2]);
            pool.addItem('sophisticatedstorage:auto_smelting_upgrade').weight(20).count([1, 4]);
            pool.addItem('sophisticatedstorage:advanced_void_upgrade').weight(22).count([1, 3]);
            pool.addItem('sophisticatedstorage:void_upgrade').weight(18).count([1, 2]);
            pool.addItem('sophisticatedstorage:iron_barrel').weight(25).count([1, 4]);
            pool.addItem('refinedstorage:raw_improved_processor').weight(20).count([1, 3]);
            pool.addItem('refinedstorage:basic_processor').weight(18).count([1, 2]);
            pool.addItem('refinedstorage:improved_processor').weight(22).count([1, 4]);
            pool.addItem('refinedstorage:cable').weight(15).count([1, 3]);
            pool.addItem('refinedstorage:raw_basic_processor').weight(20).count([1, 2]);
            pool.addItem('refinedstorage:4k_storage_part').weight(25).count([1, 4]);
            pool.addItem('sophisticatedstorage:basic_to_iron_tier_upgrade').weight(18).count([1, 3]);
            pool.addItem('sophisticatedstorage:basic_to_copper_tier_upgrade').weight(22).count([1, 2]);
            pool.addItem('sophisticatedstorage:compacting_upgrade').weight(20).count([1, 4]);
            pool.addItem('sophisticatedstorage:advanced_feeding_upgrade').weight(15).count([1, 3]);
            pool.addItem('sophisticatedstorage:magnet_upgrade').weight(20).count([1, 2]);
            pool.addItem('sophisticatedstorage:filter_upgrade').weight(22).count([1, 4]);
            pool.addItem('sophisticatedstorage:compression_upgrade').weight(18).count([1, 3]);
            pool.addItem('sophisticatedstorage:feeding_upgrade').weight(25).count([1, 2]);
            pool.addItem('sophisticatedstorage:stack_downgrade_tier_2').weight(20).count([1, 4]);
            pool.addItem('sophisticatedstorage:stonecutter_upgrade').weight(18).count([1, 3]);
            pool.addItem('sophisticatedstorage:auto_blasting_upgrade').weight(22).count([1, 2]);
            pool.addItem('sophisticatedstorage:advanced_compacting_upgrade').weight(15).count([1, 4]);
            pool.addItem('sophisticatedstorage:hopper_upgrade').weight(20).count([1, 3]);
            pool.addItem('sophisticatedstorage:pump_upgrade').weight(25).count([1, 2]);
            pool.addItem('sophisticatedstorage:jukebox_upgrade').weight(18).count([1, 4]);
            pool.addItem('sophisticatedstorage:stack_downgrade_tier_1').weight(22).count([1, 3]);
            pool.addItem('sophisticatedstorage:stack_upgrade_tier_1_plus').weight(20).count([1, 2]);
            pool.addItem('sophisticatedstorage:crafting_upgrade').weight(15).count([1, 4]);
            pool.addItem('sophisticatedstorage:blasting_upgrade').weight(20).count([1, 3]);
            pool.addItem('sophisticatedstorage:auto_smoking_upgrade').weight(22).count([1, 2]);
            pool.addItem('sophisticatedstorage:smoking_upgrade').weight(18).count([1, 4]);
            pool.addItem('refinedstorage:silicon').weight(25).count([1, 3]);
            pool.addItem('sophisticatedstorage:smelting_upgrade').weight(20).count([1, 2]);
            pool.addItem('refinedstorage:processor_binding').weight(18).count([1, 4]);
            pool.addItem('sophisticatedstorage:copper_to_iron_tier_upgrade').weight(22).count([1, 3]);
            pool.addItem('sophisticatedstorage:iron_to_gold_tier_upgrade').weight(15).count([1, 2]);
            pool.addItem('sophisticatedstorage:upgrade_base').weight(20).count([1, 4]);
            pool.addItem('sophisticatedstorage:gold_barrel').weight(22).count([1, 3]);
            pool.addItem('sophisticatedstorage:copper_barrel').weight(18).count([1, 2]);
            pool.addItem('refinedstorage:4k_storage_block').weight(25).count([1, 4]);
            pool.addItem('refinedstorage:controller').weight(20).count([1, 3]);
            pool.addItem('refinedstorage:machine_casing').weight(18).count([1, 2]);
            pool.addItem('refinedstorage:storage_monitor').weight(22).count([1, 4]);
            pool.addItem('refinedstorage:1k_storage_block').weight(15).count([1, 3]);
            pool.addItem('refinedstorage:advanced_processor').weight(20).count([1, 2]);
            pool.addItem('refinedstorage:destruction_core').weight(25).count([1, 4]);
            pool.addItem('refinedstorage:construction_core').weight(18).count([1, 3]);
            pool.addItem('refinedstorage:1k_storage_part').weight(20).count([1, 2]);
            pool.addEmpty(200);
            pool.rolls = 3
        })
    })

    event.modify('mryh:office_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:office_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_office = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "sophisticatedbackpacks:battery_upgrade",
        "sophisticatedbackpacks:upgrade_base",
        "sophisticatedbackpacks:deposit_upgrade",
        "sophisticatedbackpacks:stonecutter_upgrade",
        "sophisticatedbackpacks:tank_upgrade",
        "sophisticatedbackpacks:pump_upgrade",
        "sophisticatedbackpacks:smelting_upgrade",
        "sophisticatedbackpacks:smithing_upgrade",
        "sophisticatedbackpacks:blasting_upgrade",
        "sophisticatedbackpacks:crafting_upgrade",
        "sophisticatedbackpacks:compacting_upgrade",
        "sophisticatedbackpacks:restock_upgrade",
        "sophisticatedbackpacks:iron_backpack",
        "sophisticatedbackpacks:feeding_upgrade",
        "sophisticatedbackpacks:stack_upgrade_starter_tier",
        "sophisticatedbackpacks:inception_upgrade",
        "sophisticatedbackpacks:tool_swapper_upgrade",
        "sophisticatedbackpacks:pickup_upgrade",
        "sophisticatedbackpacks:everlasting_upgrade",
        "sophisticatedbackpacks:copper_backpack",
        "sophisticatedbackpacks:smoking_upgrade",
        "sophisticatedbackpacks:filter_upgrade",
        "sophisticatedbackpacks:refill_upgrade",
        "sophisticatedbackpacks:void_upgrade",
        "sophisticatedbackpacks:backpack",
        "sophisticatedbackpacks:gold_backpack",
        "sophisticatedbackpacks:magnet_upgrade"
    ],
    // 幸运6+
    luck6: [

    ],
    // 困难模式
    hardMode: [
        "tacz:attachment",
        "tacz:attachment",
        "tacz:attachment",
        "tacz:attachment",
        "tacz:attachment"
    ],
    // TAG
    TagMode: [

    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [
            "tacz:stock_militech_b5",
            "tacz:stock_tactical_ar",
            "emxarms:bayonet_emx_doom",
            "emxarms:bayonet_emx_lightupgrade",
            "tacz:oem_stock_heavy",
            "immersive_armorer:stock_simple",
            "applied_armorer:bracelet_aerial_wristband"
        ],
        luck2: [
            "bluearchive:grip_otogi",
            "applied_armorer:grip_sl_2",
            "bluearchive:grip_shiroko",
            "immersive_armorer:grip_twined",
            "emxarms:grip_emx_nested",
            "applied_armorer:muzzle_chip_atm_x2",
            "emxarms:muzzle_emx_encapsulation",
            "bluearchive:grip_kurumi",
            "trisdyna:grip_shimmer",
            "emxarms:grip_emx_float",
            "emxarms:grip_emx_wireframeex",
            "helldiver2:grip_union",
            "tacz:grip_vertical_military",
            "emxarms:grip_emx_wireframe",
            "tacz:grip_vertical_ranger",
            "emxarms:grip_emx_extends",
            "bluearchive:grip_fuuka",
            "emxarms:grip_emx_if",
            "cyber_armorer:muzzle_07",
            "cyber_armorer:muzzle_05",
            "emxarms:bayonet_emx_skyhunter_gw",
            "tacz:muzzle_brake_pioneer",
            "applied_armorer:muzzle_chip_tutorial_sword_mastery",
            "bluearchive:muzzle_miyako",
            "tacz:muzzle_silencer_mirage",
            "tacz:muzzle_compensator_trident",
            "trisdyna:muzzle_tris1",
            "cyber_armorer:muzzle_03",
            "cyber_armorer:muzzle_06"
        ],
        luck6: [
            "trisdyna:sight_aurora",
            "cyber_armorer:sight_03",
            "cyber_armorer:sight_02",
            "helldiver2:sight_1x_standard",
            "bluearchive:scope_fuuka",
            "immersive_armorer:scope_spyglass_ie",
            "create_armorer:sight_standard",
            "bluearchive:scope_noa",
            "bluearchive:scope_toki",
            "bluearchive:scope_yukino",
            "bluearchive:scope_kurumi",
            "bluearchive:scope_niko",
            "bluearchive:scope_miyako",
            "tacz:sight_rmr_dot",
            "tacz:sight_sro_dot",
            "tacz:sight_t2",
            "bluearchive:scope_shiroko",
            "helldiver2:sight_2x_advanced",
            "emxarms:sight_emx_aw_h",
            "emxarms:sight_emx_char2_ev",
            "emxarms:sight_emx_aw_ba",
            "cyber_armorer:sight_01",
            "cyber_armorer:sight_04",
            "emxarms:sight_emx_array",
            "emxarms:sight_emx_laterano",
            "emxarms:sight_emx_char1",
            "applied_armorer:sight_type_3741",
            "tacz:scope_acog_ta31",
            "tacz:sight_552",
            "tacz:scope_retro_2x",
            "emxarms:sight_emx_return_yh",
            "dawnhunting:tcplsight_t2",
            "emxarms:sight_emx_anonymous_gw",
            "trisdyna:sight_neutron",
            "trisdyna:sight_antares",
            "trisdyna:sight_tris_eosl"
        ],
        hardMode: [

        ],
        TagMode: [
            "immersive_armorer:extended_jar_1",
            "cyber_armorer:mod_apex",
            "emxarms:ammo_h1",
            "emxarms:ammo_h2",
            "emxarms:ammo_h2_if",
            "cyber_armorer:mod_static",
            "emxarms:ammo_l2",
            "tacz:ammo_mod_hp",
            "applied_armorer:extended_mag_aa_2",
            "emxarms:ammo_sh3r",
            "tacz:ammo_mod_hp",
            "tacz:ammo_mod_he",
            "emxarms:emx_heavyweight_mag_3",
            "emxarms:ammo_sgap",
            "tacz:extended_mag_3",
            "tacz:extended_mag_2",
            "emxarms:ammo_sgeb",
            "emxarms:ammo_sh3",
            "emxarms:ammo_sh2",
            "emxarms:ammo_l2_hp",
            "tacz:light_extended_mag_3",
            "tacz:light_extended_mag_2",
            "bf1:ammo_mod_slug",
            "emxarms:ammo_sgeb",
            "create_armorer:extended_mag_ca_2",
            "emxarms:emx_sfmag_1he",
            "tacz:extended_mag_1",
            "immersive_armorer:extended_capacitor_3",
            "emxarms:emx_sfmag_1",
            "emxarms:emx_sfmag_2",
            "trisdyna:trammo_1",
            "cyber_armorer:mod_consentrate",
            "applied_armorer:extended_mid_mag_aa_3",
            "applied_armorer:extended_mid_mag_aa_2",
            "cyber_armorer:mod_insendiary"
        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/office.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_office, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_office, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});