// 酒店战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:hotel_1', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:beef').weight(25).count([1, 4]);
            pool.addItem('minecraft:porkchop').weight(22).count([1, 4]);
            pool.addItem('minecraft:mutton').weight(18).count([1, 4]);
            pool.addItem('minecraft:cod').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(15).count([1, 4]);
            pool.addItem('minecraft:sugar').weight(22).count([1, 4]);
            pool.addItem('zombiekit:camphor').weight(18).count([1, 4]);
            pool.addItem('zombiekit:rubber').weight(20).count([1, 4]);
            pool.addItem('minecraft:raw_iron').weight(25).count([1, 4]);
            pool.addItem('minecraft:redstone').weight(15).count([1, 4]);
            pool.addItem('minecraft:raw_gold').weight(20).count([1, 4]);
            pool.addItem('create:raw_zinc').weight(18).count([1, 4]);
            pool.addItem('minecraft:gunpowder').weight(22).count([1, 4]);
            pool.addItem('minecraft:book').weight(15).count([1, 4]);
            pool.addItem('minecraft:paper').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:textilethread').weight(25).count([1, 4]);
            pool.addItem('minecraft:gold_ingot').weight(18).count([1, 4]);
            pool.addItem('minecraft:iron_nugget').weight(20).count([1, 4]);
            pool.addItem('minecraft:coal').weight(22).count([1, 4]);
            pool.addItem('minecraft:flint').weight(15).count([1, 4]);
            pool.addItem('minecraft:leather').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(25).count([1, 4]);
            pool.addItem('minecraft:ink_sac').weight(18).count([1, 4]);
            pool.addItem('apocalypsenow:plastic').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:plasticplate').weight(22).count([1, 4]);
            pool.addItem('zombiekit:alcohol').weight(15).count([1, 4]);
            pool.addItem('apocalypsenow:engineering_parts').weight(20).count([1, 4]);
            pool.addItem('minecraft:chicken').weight(25).count([1, 4]);
            pool.addItem('minecraft:carrot').weight(18).count([1, 4]);
            pool.addItem('minecraft:emerald').weight(20).count([1, 4]);
            pool.addItem('minecraft:beetroot').weight(22).count([1, 4]);
            pool.addItem('minecraft:feather').weight(15).count([1, 4]);
            pool.addItem('minecraft:diamond').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:money').weight(25).count([1, 4]);
            pool.addItem('minecraft:slime_ball').weight(18).count([1, 4]);
            pool.addItem('minecraft:rabbit').weight(20).count([1, 4]);
            pool.addItem('minecraft:bone').weight(22).count([1, 4]);
            pool.addItem('minecraft:stick').weight(15).count([1, 4]);
            pool.addItem('minecraft:quartz').weight(20).count([1, 4]);
            pool.addItem('minecraft:charcoal').weight(25).count([1, 4]);
            pool.addItem('minecraft:bone_meal').weight(18).count([1, 4]);
            pool.addItem('minecraft:glowstone_dust').weight(20).count([1, 4]);
            pool.addItem('minecraft:raw_copper').weight(22).count([1, 4]);
            pool.addItem('minecraft:amethyst_shard').weight(15).count([1, 4]);
            pool.addItem('minecraft:blaze_rod').weight(20).count([1, 4]);
            pool.addItem('minecraft:lapis_lazuli').weight(25).count([1, 4]);
            pool.addItem('minecraft:copper_ingot').weight(18).count([1, 4]);
            pool.addItem('minecraft:iron_ingot').weight(20).count([1, 4]);
            pool.addItem('minecraft:gold_nugget').weight(22).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:hotel_2', loot => {
        loot.addPool(pool => {
            pool.addItem('iron_ingot').weight(100).count([1, 4])
            pool.addItem('zombiekit:bandage').weight(95).count([1, 4])
            pool.addItem('apocalypsenow:rags').weight(90).count([1, 4])
            pool.addItem('apocalypsenow:bandage').weight(85).count([1, 4])
            pool.addItem('scalinghealth:bandages').weight(80).count([1, 4])
            pool.addItem('zombie_extreme:bandage').weight(75).count([1, 4])
            pool.addItem('apocalypsenow:cleanrags').weight(70).count([1, 4])
            pool.addItem('apocalypsenow:pain_killers').weight(65).count([1, 4])
            pool.addItem('zombiekit:painkiller').weight(60).count([1, 4])
            pool.addItem('apocalypsenow:homemadeantibiotics').weight(55).count([1, 4])
            pool.addItem('scalinghealth:medkit').weight(50).count([1, 4])
            pool.addItem('minecraft:experience_bottle').weight(45).count([1, 4])
            pool.addItem('minecraft:ender_pearl').weight(40).count([1, 4])
            pool.addItem('minecraft:ghast_tear').weight(35).count([1, 4])
            pool.addItem('apocalypsenow:money_block').weight(30).count([1, 4])
            pool.addItem('minecraft:blaze_rod').weight(25).count([1, 4])
            pool.addItem('minecraft:diamond').weight(20).count([1, 4])
            pool.addItem('minecraft:emerald').weight(15).count([1, 4])
            pool.addItem('minecraft:golden_apple').weight(10).count([1, 4])
            pool.addEmpty(300)
            pool.rolls = 3
        })
    })

    event.modify('mryh:hotel_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:hotel_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_hotel = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "tacz:modern_kinetic_gun"
    ],
    // 幸运6+
    luck6: [

    ],
    // 困难模式
    hardMode: [

    ],
    // TAG
    TagMode: [
        "apocalypsenow:anarchy_boots",
        "apocalypsenow:anarchy_leggings",
        "apocalypsenow:anarchy_helmet",
        "apocalypsenow:anarchy_chestplate"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [
            "emxarms:emx_tknife",
            "bluearchive:ayane",
            "emxarms:emx_pulsex2",
            "cyber_armorer:3516",
            "emxarms:emx_kund50ex",
            "emxarms:emx_mac100",
            "cyber_armorer:yukimura_genjiroh",
            "cyber_armorer:yukimura_skippy",
            "emxarms:emx_mac50",
            "cyber_armorer:unity_cheetah",
            "cyber_armorer:unity_her_majesty",
            "bluearchive:noa",
            "emxarms:emx_kund50",
            "emxarms:emx_pulse",
            "cyber_armorer:yukimura",
            "cyber_armorer:unity"
        ],
        luck6: [
            "create_armorer:smg_auto_crank",
            "emxarms:emx_expel32",
            "bluearchive:fuuka",
            "emxarms:emx_expel32se",
            "applied_armorer:niklas_smg_freedom",
            "immersive_armorer:standard_rail_smg_mk1",
            "cyber_armorer:g58_dian_yinglong",
            "bf1:vp1915",
            "cyber_armorer:g58_dian",
            "cyber_armorer:saratoga",
            "gfl2:lioncubs",
            "emxarms:emx_umx32",
            "bf1:wex"
        ],
        hardMode: [
            "helldiver2:sg225_breaker",
            "emxarms:emx_scgraves",
            "cyber_armorer:carnage",
            "applied_armorer:moritz_shotgun_sg914",
            "tacz:aa12",
            "bf1:ef46",
            "emxarms:emx_enforcer",
            "cyber_armorer:m2038_the_headsman",
            "bluearchive:hoshino"
        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    }
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/hotel.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_hotel, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_hotel, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});