// 银行战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:bank_1', loot => {
        loot.addPool(pool => {
            pool.addItem('farmersdelight:hot_cocoa').weight(18).count([1, 3]);
            pool.addItem('farmersdelight:fried_egg').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:civilian_body_vest_chestplate').weight(22);
            pool.addItem('apocalypsenow:officer_helmet').weight(25);
            pool.addItem('apocalypsenow:press_bulletproof_vest_chestplate').weight(15);
            pool.addItem('minecraft:diamond_helmet').weight(20);
            pool.addItem('minecraft:diamond_leggings').weight(18);
            pool.addItem('minecraft:diamond_chestplate').weight(22);
            pool.addItem('minecraft:diamond_boots').weight(25);
            pool.addItem('apocalypsenow:money_block').weight(15).count([1, 3]);
            pool.addItem('minecraft:emerald').weight(20).count([1, 2]);
            pool.addItem('minecraft:redstone_block').weight(22).count([1, 4]);
            pool.addItem('minecraft:amethyst_block').weight(18).count([1, 3]);
            pool.addItem('minecraft:coal_block').weight(25).count([1, 2]);
            pool.addItem('minecraft:lapis_lazuli').weight(15).count([1, 4]);
            pool.addItem('minecraft:coal').weight(20).count([1, 3]);
            pool.addItem('minecraft:iron_ingot').weight(22).count([1, 2]);
            pool.addItem('minecraft:copper_ingot').weight(18).count([1, 4]);
            pool.addItem('minecraft:gold_ingot').weight(25).count([1, 3]);
            pool.addItem('farmersdelight:nether_salad').weight(15).count([1, 2]);
            pool.addItem('farmersdelight:bacon_sandwich').weight(20).count([1, 4]);
            pool.addItem('farmersdelight:hamburger').weight(22).count([1, 3]);
            pool.addItem('farmersdelight:baked_cod_stew').weight(18).count([1, 2]);
            pool.addItem('farmersdelight:bone_broth').weight(25).count([1, 4]);
            pool.addItem('farmersdelight:fried_rice').weight(15).count([1, 3]);
            pool.addItem('farmersdelight:honey_cookie').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:canned_beetroot').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:dogs_food').weight(18).count([1, 3]);
            pool.addItem('apocalypsenow:canned_soup').weight(25).count([1, 2]);
            pool.addItem('apocalypsenow:canned_rabbit_soup').weight(15).count([1, 4]);
            pool.addItem('apocalypsenow:canned_pork').weight(20).count([1, 3]);
            pool.addItem('apocalypsenow:canned_corn').weight(22).count([1, 2]);
            pool.addItem('farmersdelight:bacon_and_eggs').weight(18).count([1, 4]);
            pool.addItem('farmersdelight:sweet_berry_cheesecake_slice').weight(25).count([1, 3]);
            pool.addItem('farmersdelight:sweet_berry_cookie').weight(15).count([1, 2]);
            pool.addItem('farmersdelight:minced_beef').weight(20).count([1, 4]);
            pool.addItem('minecraft:gold_block').weight(22).count([1, 3]);
            pool.addItem('minecraft:iron_block').weight(18).count([1, 2]);
            pool.addItem('minecraft:lapis_block').weight(25).count([1, 4]);
            pool.addItem('minecraft:flint').weight(15).count([1, 3]);
            pool.addItem('minecraft:raw_iron').weight(20).count([1, 2]);
            pool.addItem('minecraft:raw_gold').weight(22).count([1, 4]);
            pool.addItem('minecraft:quartz').weight(18).count([1, 3]);
            pool.addItem('minecraft:redstone').weight(25).count([1, 2]);
            pool.addItem('minecraft:amethyst_shard').weight(15).count([1, 4]);
            pool.addItem('minecraft:writable_book').weight(20).count([1, 3]);
            pool.addItem('minecraft:sugar').weight(22).count([1, 2]);
            pool.addItem('minecraft:glowstone').weight(18).count([1, 4]);
            pool.addItem('minecraft:experience_bottle').weight(25).count([1, 3]);
            pool.addItem('minecraft:gunpowder').weight(15).count([1, 2]);
            pool.addItem('minecraft:name_tag').weight(20).count([1, 4]);
            pool.addItem('minecraft:map').weight(22).count([1, 3]);
            pool.addItem('minecraft:chipped_anvil').weight(18).count([1, 2]);
            pool.addItem('apocalypsenow:highvaluemoneyblock').weight(25).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:bank_2', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:name_tag').weight(20).count([1, 4]);
            pool.addItem('minecraft:torch').weight(25).count([1, 3]);
            pool.addItem('minecraft:magma_block').weight(15).count([1, 2]);
            pool.addItem('minecraft:smithing_table').weight(18).count([1, 4]);
            pool.addItem('minecraft:enchanting_table').weight(22).count([1, 3]);
            pool.addItem('minecraft:map').weight(18).count([1, 2]);
            pool.addItem('minecraft:writable_book').weight(20).count([1, 4]);
            pool.addItem('minecraft:chorus_fruit').weight(25).count([1, 3]);
            pool.addItem('minecraft:chipped_anvil').weight(15).count([1, 2]);
            pool.addItem('dummmmmmy:target_dummy').weight(20).count([1, 4]);
            pool.addItem('supplementaries:bomb_blue').weight(22).count([1, 3]);
            pool.addItem('supplementaries:bomb').weight(18).count([1, 2]);
            pool.addItem('supplementaries:soap').weight(25).count([1, 4]);
            pool.addItem('supplementaries:key').weight(15).count([1, 3]);
            pool.addItem('minecraft:gunpowder').weight(20).count([1, 2]);
            pool.addItem('minecraft:lead').weight(22).count([1, 4]);
            pool.addItem('minecraft:experience_bottle').weight(18).count([1, 3]);
            pool.addItem('minecraft:glowstone').weight(25).count([1, 2]);
            pool.addItem('minecraft:damaged_anvil').weight(15).count([1, 4]);
            pool.addItem('minecraft:sugar').weight(20).count([1, 3]);
            pool.addItem('minecraft:anvil').weight(22).count([1, 2]);
            pool.addItem('minecraft:bookshelf').weight(18).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:bank_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:bank_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_bank = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "minecraft:diamond_block",
        "minecraft:coal_block",
        "minecraft:lapis_block",
        "minecraft:iron_block",
        "minecraft:emerald_block",
        "minecraft:gold_block",
        "apocalypsenow:highvaluemoneyblock",
        "minecraft:diamond",
        "apocalypsenow:money_block",
        "minecraft:emerald",
        "minecraft:redstone_block",
        "minecraft:amethyst_block",
        "tacz:modern_kinetic_gun",
        "tacz:modern_kinetic_gun"
    ],
    // 幸运6+
    luck6: [
        "minecraft:netherite_scrap",
        "minecraft:ancient_debris",
        "minecraft:netherite_ingot",
        "minecraft:netherite_upgrade_smithing_template",
        "max_armory:lamellar_armor_piece",
        "max_armory:chain_armor_piece",
        "max_armory:iron_plate",
        "immersiveengineering:storage_aluminum"
    ],
    // 困难模式
    hardMode: [

    ],
    // TAG
    TagMode: [

    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [
            "cyber_armorer:saratoga",
            "cyber_armorer:g58_dian",
            "bluearchive:fuuka",
            "emxarms:emx_umx32",
            "cyber_armorer:g58_dian_yinglong",
            "bf1:vp1915",
            "emxarms:emx_expel32se",
            "gfl2:lioncubs",
            "emxarms:emx_expel32"
        ],
        luck6: [

        ],
        hardMode: [
            "emxarms:emx_pulse",
            "bluearchive:ayane",
            "emxarms:emx_kund50",
            "applied_armorer:niklas_pistol_double_win_win",
            "emxarms:emx_mac100",
            "emxarms:emx_pulsex2",
            "bluearchive:noa",
            "helldiver2:p19_redeemer",
            "emxarms:emx_kund50ex",
            "emxarms:emx_mac50",
            "cyber_armorer:3516",
            "emxarms:emx_tknife",
            "cyber_armorer:yukimura_genjiroh",
            "cyber_armorer:yukimura_skippy",
            "cyber_armorer:yukimura",
            "cyber_armorer:unity_cheetah",
            "cyber_armorer:unity_her_majesty",
            "cyber_armorer:unity",
            "helldiver2:authorized_gun"
        ],
        TagMode: [
            "cyber_armorer:carnage",
            "emxarms:emx_scgraves",
            "emxarms:emx_enforcer",
            "cyber_armorer:m2038_the_headsman",
            "bluearchive:hoshino",
            "bf1:ef46",
            "tacz:aa12",
            "bf1:wex"
        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/bank.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_bank, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_bank, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});