let $TimelessAPI = Java.loadClass("com.tacz.guns.api.TimelessAPI")

// 定义获取随机数的函数
function getRandomNumber(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

// 定义获取随机概率的函数
function getRandomChance(min, max) {
    return Math.random() * (max - min) + min;
}

// 提前计算不同难度和运气下的最终物品池
function getFinalLootPool(pool, luck, difficulty, player) {
    let finalLootPool = [];
    let chanceMultiplier = 1.0;

    // 根据运气值添加不同物品池
    if (luck >= 6) {
        finalLootPool = finalLootPool.concat(pool.luck6 || []);
        chanceMultiplier *= 1.5;
    }
    if (luck >= 2) {
        finalLootPool = finalLootPool.concat(pool.luck2 || []);
    }
    finalLootPool = finalLootPool.concat(pool.noLuck || []);

    // 根据难度添加不同物品池
    if (difficulty === 3) {
        chanceMultiplier *= 1.5;
        finalLootPool = finalLootPool.concat(pool.hardMode || []);
    }

    // 根据玩家标签添加特殊物品池
    if (player?.tags.contains('difficult_level_4')) {
        chanceMultiplier *= 1.5;
        finalLootPool = finalLootPool.concat(pool.TagMode || []);
    }

    return { finalLootPool: finalLootPool, chanceMultiplier: chanceMultiplier };

}

// 获取枪械ID列表
function getGunIds(pool, luck, difficulty, hasTagMode) {
    let currentGunIds = [];
    if (luck >= 6) {
        currentGunIds = pool.gunIds.luck6.slice();
    }
    if (luck >= 2) {
        let newGuns = pool.gunIds.luck2.filter(id => !currentGunIds.includes(id));
        currentGunIds = currentGunIds.concat(newGuns);
    }
    let baseGuns = pool.gunIds.noLuck.filter(id => !currentGunIds.includes(id));
    currentGunIds = currentGunIds.concat(baseGuns);
    if (difficulty === 3) {
        let hardGuns = pool.gunIds.hardMode.filter(id => !currentGunIds.includes(id));
        currentGunIds = currentGunIds.concat(hardGuns);
    }
    if (hasTagMode) {
        let tagGuns = pool.gunIds.TagMode.filter(id => !currentGunIds.includes(id));
        currentGunIds = currentGunIds.concat(tagGuns);
    }
    return currentGunIds;
}

// 获取子弹ID列表
function getAmmoIds(pool, luck, difficulty, hasTagMode) {
    let currentAmmoIds = [];
    if (luck >= 6) {
        currentAmmoIds = pool.ammoIds.luck6.slice();
    }
    if (luck >= 2) {
        let newAmmo = pool.ammoIds.luck2.filter(id => !currentAmmoIds.includes(id));
        currentAmmoIds = currentAmmoIds.concat(newAmmo);
    }
    let baseAmmo = pool.ammoIds.noLuck.filter(id => !currentAmmoIds.includes(id));
    currentAmmoIds = currentAmmoIds.concat(baseAmmo);
    if (difficulty === 3) {
        let hardAmmo = pool.ammoIds.hardMode.filter(id => !currentAmmoIds.includes(id));
        currentAmmoIds = currentAmmoIds.concat(hardAmmo);
    }
    if (hasTagMode) {
        let tagAmmo = pool.ammoIds.TagMode.filter(id => !currentAmmoIds.includes(id));
        currentAmmoIds = currentAmmoIds.concat(tagAmmo);
    }
    return currentAmmoIds;
}

// 获取配件ID列表
function getAttachmentId(pool, luck, difficulty, hasTagMode) {
    let currentAttachmentIds = [];
    if (luck >= 6) {
        currentAttachmentIds = pool.attachmentId.luck6.slice();
    }
    if (luck >= 2) {
        let newAttachment = pool.attachmentId.luck2.filter(id => !currentAttachmentIds.includes(id));
        currentAttachmentIds = currentAttachmentIds.concat(newAttachment);
    }
    let baseAttachment = pool.attachmentId.noLuck.filter(id => !currentAttachmentIds.includes(id));
    currentAttachmentIds = currentAttachmentIds.concat(baseAttachment);
    if (difficulty === 3) {
        let hardAttachment = pool.attachmentId.hardMode.filter(id => !currentAttachmentIds.includes(id));
        currentAttachmentIds = currentAttachmentIds.concat(hardAttachment);
    }
    if (hasTagMode) {
        let tagAttachment = pool.attachmentId.TagMode.filter(id => !currentAttachmentIds.includes(id));
        currentAttachmentIds = currentAttachmentIds.concat(tagAttachment);
    }
    return currentAttachmentIds;
}

// 获取枪械可用的开火模式
function getNextFireMode(gunId) {
    let nextFireMode = ''
    let firModeSet = []
    $TimelessAPI.getCommonGunIndex(gunId).map(gunIndex => {
        firModeSet = gunIndex.getGunData().getFireModeSet()
    })
    if (firModeSet.length > 0) {
        if (firModeSet.indexOf('AUTO') != -1) {
            nextFireMode = 'AUTO'
        } else if (firModeSet.indexOf('BURST') != -1) {
            nextFireMode = 'BURST'
        } else {
            nextFireMode = firModeSet[0]
        }
    }
    return nextFireMode
}

// 生成单个战利品条目
function createLootEntry(context, selectedItem, pool, luck, difficulty, hasTagMode, finalChance) {
    let count;
    if (isEquipmentOrTool(selectedItem)) {
        count = 1;
    } else {
        count = getRandomNumber(1, 3);
    }
    let randomEntryChance = getRandomChance(0.1, 0.5);
    let entry;
    if (selectedItem === 'tacz:modern_kinetic_gun') {
        let currentGunIds = getGunIds(pool, luck, difficulty, hasTagMode);
        if (currentGunIds.length > 0) {
            let randomGunId = currentGunIds[Math.floor(Math.random() * currentGunIds.length)];
            let nextFireMode = getNextFireMode(randomGunId)
            if (nextFireMode) {
                entry = LootEntry.of(Item.of('tacz:modern_kinetic_gun', '{GunId: "' + randomGunId + '", GunFireMode: "' + nextFireMode + '"}'), 1)
                    .withChance(randomEntryChance)
                    .when(c => c.randomChance(finalChance));
            } else {
                entry = LootEntry.of('tacz:modern_kinetic_gun', 1, { GunId: randomGunId })
                    .withChance(randomEntryChance)
                    .when(c => c.randomChance(finalChance));
            }
        }
    } else if (selectedItem === 'tacz:ammo') {
        let currentAmmoIds = getAmmoIds(pool, luck, difficulty, hasTagMode);
        if (currentAmmoIds.length > 0) {
            let randomAmmoId = currentAmmoIds[Math.floor(Math.random() * currentAmmoIds.length)];
            entry = LootEntry.of('tacz:ammo', count, { AmmoId: randomAmmoId })
                .withChance(randomEntryChance)
                .when((c) => c.randomChance(finalChance));
        }
    } else if (selectedItem === 'tacz:attachment') {
        let currentattachmentId = getAttachmentId(pool, luck, difficulty, hasTagMode);
        if (currentattachmentId.length > 0) {
            let randomattachmentId = currentattachmentId[Math.floor(Math.random() * currentattachmentId.length)];
            entry = LootEntry.of('tacz:attachment', 1, { AttachmentId: randomattachmentId })
                .withChance(randomEntryChance)
                .when((c) => c.randomChance(finalChance));
        }
    } else {
        entry = LootEntry.of(selectedItem, count)
            .withChance(randomEntryChance)
            .when((c) => c.randomChance(finalChance));
    }

    return entry;
}

// 判断是否是装备或工具
function isEquipmentOrTool(itemId) {
    let equipmentAndTools = [
        "apocalypsenow:anarchy_boots",
        "apocalypsenow:anarchy_leggings",
        "apocalypsenow:anarchy_helmet",
        "apocalypsenow:anarchy_chestplate",
        "sophisticatedbackpacks:compacting_upgrade",
        "sophisticatedbackpacks:restock_upgrade",
        "sophisticatedbackpacks:smoking_upgrade",
        "sophisticatedbackpacks:filter_upgrade",
        "sophisticatedbackpacks:refill_upgrade",
        "sophisticatedbackpacks:void_upgrade",
        "sophisticatedbackpacks:smelting_upgrade",
        "sophisticatedbackpacks:smithing_upgrade",
        "sophisticatedbackpacks:blasting_upgrade",
        "sophisticatedbackpacks:iron_backpack",
        "sophisticatedbackpacks:copper_backpack",
        "sophisticatedbackpacks:gold_backpack",
        "sophisticatedbackpacks:backpack",
        "sophisticatedbackpacks:pump_upgrade",
        "sophisticatedbackpacks:tank_upgrade",
        "sophisticatedbackpacks:stonecutter_upgrade",
        "sophisticatedbackpacks:everlasting_upgrade",
        "sophisticatedbackpacks:battery_upgrade",
        "sophisticatedbackpacks:upgrade_base",
        "sophisticatedbackpacks:deposit_upgrade",
        "sophisticatedbackpacks:magnet_upgrade",
        "sophisticatedbackpacks:pickup_upgrade",
        "sophisticatedbackpacks:tool_swapper_upgrade",
        "sophisticatedbackpacks:inception_upgrade",
        "sophisticatedbackpacks:stack_upgrade_starter_tier",
        "sophisticatedbackpacks:feeding_upgrade",
        "sophisticatedbackpacks:crafting_upgrade",
        "sophisticatedstorage:jukebox_upgrade",
        "sophisticatedstorage:stack_downgrade_tier_1",
        "sophisticatedstorage:stack_upgrade_tier_1_plus",
        "sophisticatedstorage:iron_barrel",
        "sophisticatedstorage:compacting_upgrade",
        "sophisticatedstorage:advanced_feeding_upgrade",
        "sophisticatedstorage:magnet_upgrade",
        "sophisticatedstorage:filter_upgrade",
        "sophisticatedstorage:feeding_upgrade",
        "refinedstorage:controller",
        "sophisticatedstorage:copper_barrel",
        "sophisticatedstorage:gold_barrel",
        "sophisticatedstorage:basic_to_iron_tier_upgrade",
        "sophisticatedstorage:void_upgrade",
        "sophisticatedstorage:iron_to_gold_tier_upgrade",
        "sophisticatedstorage:copper_to_iron_tier_upgrade",
        "sophisticatedstorage:compression_upgrade",
        "sophisticatedstorage:stack_downgrade_tier_2",
        "sophisticatedstorage:stonecutter_upgrade",
        "sophisticatedstorage:auto_blasting_upgrade",
        "sophisticatedstorage:advanced_compacting_upgrade",
        "sophisticatedstorage:smoking_upgrade",
        "sophisticatedstorage:auto_smoking_upgrade",
        "sophisticatedstorage:blasting_upgrade",
        "sophisticatedstorage:crafting_upgrade",
        "sophisticatedstorage:advanced_void_upgrade",
        "sophisticatedstorage:auto_smelting_upgrade",
        "sophisticatedstorage:stack_upgrade_tier_1",
        "sophisticatedstorage:advanced_pickup_upgrade",
        "sophisticatedstorage:advanced_magnet_upgrade",
        "sophisticatedstorage:advanced_filter_upgrade",
        "sophisticatedstorage:pickup_upgrade",
        "sophisticatedstorage:hopper_upgrade",
        "sophisticatedstorage:pump_upgrade",
        "supplementaries:key",
        "apocalypsenow:nurse_leggings",
        "marbledsarsenal:hazmat_armor_boots",
        "marbledsarsenal:hazmat_armor_chestplate",
        "marbledsarsenal:hazmat_armor_helmet",
        "marbledsarsenal:hazmat_armor_leggings",
        "zombie_extreme:hazmat_suit_boots",
        "zombie_extreme:hazmat_suit_chestplate",
        "zombie_extreme:hazmat_suit_helmet",
        "zombie_extreme:hazmat_suit_leggings",
        "apocalypsenow:level_a_hazmatsuit_boots",
        "apocalypsenow:level_a_hazmatsuit_chestplate",
        "apocalypsenow:hazmat_suit_helmet",
        "apocalypsenow:hazmat_suit_boots",
        "apocalypsenow:contamination_suit_white_leggings",
        "apocalypsenow:contamination_suit_white_helmet",
        "apocalypsenow:contamination_suit_white_chestplate",
        "apocalypsenow:contamination_suit_white_boots",
        "apocalypsenow:contamination_suit_green_helmet",
        "apocalypsenow:contamination_suit_green_chestplate",
        "apocalypsenow:contamination_suit_blue_leggings",
        "apocalypsenow:contamination_suit_blue_helmet",
        "apocalypsenow:contamination_suit_blue_chestplate",
        "apocalypsenow:advanced_hazmat_suit_leggings",
        "apocalypsenow:advanced_hazmat_suit_helmet",
        "apocalypsenow:advanced_hazmat_suit_chestplate",
        "apocalypsenow:advanced_hazmat_suit_boots",
        "apocalypsenow:hazmat_suit_leggings",
        "apocalypsenow:level_a_hazmatsuit_helmet",
        "apocalypsenow:level_a_hazmatsuit_leggings",
        "apocalypsenow:nurse_boots",
        "apocalypsenow:nurse_chestplate",
        "marbledsarsenal:olive_juggernaut_armor_chestplate",
        "marbledsarsenal:black_juggernaut_armor_helmet",
        "marbledsarsenal:black_juggernaut_armor_boots",
        "marbledsarsenal:desert_military_armor_helmet",
        "marbledsarsenal:swat_armor_boots",
        "marbledsarsenal:olive_plate_carrier_heavy",
        "marbledsarsenal:black_plate_carrier_heavy",
        "marbledsarsenal:medical_olive_combat_helmet",
        "marbledsarsenal:medical_combat_helmet",
        "marbledsarsenal:un_combat_helmet",
        "marbledsarsenal:riot_armor_helmet",
        "marbledsarsenal:riot_armor_chestplate",
        "marbledsarsenal:desert_military_armor_boots",
        "marbledsarsenal:olive_juggernaut_armor_boots",
        "marbledsarsenal:olive_combat_helmet",
        "marbledsarsenal:riot_armor_leggings",
        "marbledsarsenal:winter_military_armor_helmet",
        "marbledsarsenal:olive_juggernaut_armor_helmet",
        "marbledsarsenal:black_juggernaut_armor_leggings",
        "marbledsarsenal:black_plate_carrier_light",
        "marbledsarsenal:black_juggernaut_armor_chestplate",
        "marbledsarsenal:olive_juggernaut_armor_leggings",
        "marbledsarsenal:winter_military_armor_boots",
        "marbledsarsenal:winter_military_armor_chestplate",
        "marbledsarsenal:swat_armor_chestplate",
        "marbledsarsenal:combat_helmet",
        "marbledsarsenal:swat_armor_helmet",
        "marbledsarsenal:medical_un_combat_helmet",
        "marbledsarsenal:olive_plate_carrier_light",
        "marbledsarsenal:riot_armor_boots",
        "marbledsarsenal:swat_armor_leggings",
        "marbledsarsenal:winter_military_armor_leggings",
        "marbledsarsenal:desert_military_armor_chestplate",
        "apocalypsenow:riot_shield",
        "apocalypsenow:swat_chestplate",
        "apocalypsenow:swat_leggings",
        "apocalypsenow:police_leggings",
        "apocalypsenow:police_boots",
        "zombie_extreme:swat_suit_boots",
        "zombie_extreme:swat_suit_leggings",
        "zombie_extreme:swat_suit_chestplate",
        "zombie_extreme:swat_suit_helmet",
        "apocalypsenow:police_shield",
        "zombie_extreme:police_suit_chestplate",
        "zombie_extreme:police_suit_helmet",
        "marbledsarsenal:riot_armor_helmet",
        "marbledsarsenal:riot_armor_boots",
        "apocalypsenow:swatriotcontrol_helmet",
        "apocalypsenow:swat_boots",
        "apocalypsenow:swat_helmet",
        "apocalypsenow:swatriotcontrol_boots",
        "apocalypsenow:swatriotcontrol_leggings",
        "apocalypsenow:police_helmet",
        "apocalypsenow:police_chestplate",
        "marbledsarsenal:riot_armor_chestplate",
        "marbledsarsenal:riot_armor_leggings",
        "apocalypsenow:swatriotcontrol_chestplate",
        "zombiekit:standard_tactical_boots",
        "zombiekit:standard_tactical_chestplate",
        "zombiekit:standard_tactical_leggings",
        "zombiekit:standard_tactical_helmet",
        "apocalypsenow:jet_pilot_helmet",
        "apocalypsenow:jet_pilot_leggings",
        "apocalypsenow:jet_pilot_chestplate",
        "apocalypsenow:jet_pilot_boots",
        "apocalypsenow:electric_baton",
        "apocalypsenow:night_stick",
        "zombie_extreme:police_baton",
        "apocalypsenow:fire_figther_chestplate",
        "cold_sweat:goat_fur_boots",
        "cold_sweat:hoglin_hooves",
        "minecraft:leather_chestplate",
        "minecraft:leather_helmet",
        "minecraft:leather_leggings",
        "minecraft:leather_boots",
        "apocalypsenow:red_crowbar",
        "zombiekit:netherite_crowbar",
        "zombiekit:crowbar",
        "modern_structures:crowbar",
        "zombie_extreme:crowbar",
        "apocalypsenow:crowbar",
        "apocalypsenow:wooden_fire_axe",
        "cold_sweat:goat_fur_parka",
        "cold_sweat:goat_fur_cap",
        "cold_sweat:goat_fur_pants",
        "cold_sweat:hoglin_headpiece",
        "cold_sweat:hoglin_trousers",
        "cold_sweat:hoglin_tunic",
        "zombie_extreme:fireaxe",
        "apocalypsenow:fire_axe",
        "zombiekit:fire_axe",
        "apocalypsenow:fire_figther_boots",
        "apocalypsenow:fire_figther_leggings",
        "apocalypsenow:fire_figther_helmet",
        "marbledsarsenal:medical_helmet_cm8m_gas_mask",
        "marbledsarsenal:black_gp5_gas_mask",
        "spore:gas_mask",
        "modern_structures:tactic_chestplate",
        "marbledsarsenal:un_helmet_cm7m_gas_mask",
        "marbledsarsenal:un_helmet_cm8m_gas_mask",
        "marbledsarsenal:un_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_un_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_un_helmet_cm7m_gas_mask",
        "marbledsarsenal:helmet_cm7m_gas_mask",
        "marbledsarsenal:cm8m_gas_mask",
        "marbledsarsenal:helmet_cm8m_gas_mask",
        "marbledsarsenal:crowbar",
        "marbledsarsenal:fire_axe",
        "marbledsarsenal:katana",
        "marbledsarsenal:machete",
        "marbledsarsenal:pipe_wrench",
        "marbledsarsenal:modern_axe",
        "marbledsarsenal:sledgehammer",
        "marbledsarsenal:stop_sign",
        "marbledsarsenal:tanto",
        "marbledsarsenal:tomahawk",
        "marbledsarsenal:olive_helmet_cm7m_gas_mask",
        "marbledsarsenal:olive_helmet_cm8m_gas_mask",
        "marbledsarsenal:olive_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm8m_gas_mask",
        "marbledsarsenal:combat_helmet",
        "marbledsarsenal:medical_helmet_cm7m_gas_mask",
        "modern_structures:tactic_helmet",
        "modern_structures:tacticshield",
        "modern_structures:tactic_leggings",
        "modern_structures:batlleaxe",
        "marbledsarsenal:medical_un_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_helmet_cm6m_gas_mask",
        "marbledsarsenal:bone_saw",
        "marbledsarsenal:cm6m_gas_mask",
        "marbledsarsenal:helmet_cm6m_gas_mask",
        "marbledsarsenal:cm7m_gas_mask",
        "immersive_aircraft:cargo_airship",
        "immersive_aircraft:warship",
        "marbledsarsenal:desert_military_armor_boots",
        "apocalypsenow:royal_canada_police_officer_leggings",
        "apocalypsenow:us_army_helmet",
        "apocalypsenow:us_army_leggings",
        "apocalypsenow:us_army_chestplate",
        "apocalypsenow:us_army_boots",
        "marbledsarsenal:medical_un_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_un_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_un_combat_helmet",
        "apocalypsenow:military_beret_chestplate",
        "apocalypsenow:military_bulletprooft_vest_chestplate",
        "apocalypsenow:military_riot_armor_helmet",
        "apocalypsenow:military_riot_armor_chestplate",
        "apocalypsenow:military_riot_armor_boots",
        "apocalypsenow:military_pilotheadset",
        "apocalypsenow:military_pilot_headset_chestplate",
        "apocalypsenow:military_knife",
        "marbledsarsenal:medical_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_combat_helmet",
        "apocalypsenow:desert_military_bulletproof_vest_chestplate",
        "apocalypsenow:tactical_saber",
        "marbledsarsenal:winter_military_armor_boots",
        "marbledsarsenal:winter_military_armor_chestplate",
        "marbledsarsenal:winter_military_armor_leggings",
        "marbledsarsenal:winter_military_armor_helmet",
        "zombie_extreme:military_suit_boots",
        "apocalypsenow:military_riot_armor_leggings",
        "marbledsarsenal:desert_military_armor_leggings",
        "marbledsarsenal:desert_military_armor_chestplate",
        "marbledsarsenal:desert_military_armor_helmet",
        "zombie_extreme:military_suit_leggings",
        "zombie_extreme:military_suit_chestplate",
        "apocalypsenow:military_shovel",
        "apocalypsenow:military_urban_chestplate",
        "apocalypsenow:military_urban_leggings",
        "apocalypsenow:military_urban_helmet",
        "marbledsarsenal:medical_un_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_olive_combat_helmet",
        "marbledsarsenal:medical_olive_helmet_cm6m_gas_mask",
        "zombie_extreme:m_9_knife",
        "apocalypsenow:military_beret_helmet",
        "apocalypsenow:military_radio",
        "apocalypsenow:military_urban_boots",
        "apocalypsenow:japanese_army_boots",
        "apocalypsenow:usa_armor_helmet",
        "apocalypsenow:usa_armor_leggings",
        "apocalypsenow:usa_armor_chestplate",
        "apocalypsenow:usa_armor_boots",
        "apocalypsenow:british_army_helmet",
        "apocalypsenow:british_army_leggings",
        "apocalypsenow:british_army_boots",
        "apocalypsenow:british_army_chestplate",
        "apocalypsenow:chinese_army_helmet",
        "apocalypsenow:chinese_army_leggings",
        "apocalypsenow:chinese_army_chestplate",
        "apocalypsenow:chinese_army_boots",
        "apocalypsenow:russian_army_helmet",
        "apocalypsenow:russian_army_leggings",
        "apocalypsenow:russian_army_chestplate",
        "apocalypsenow:russian_army_boots",
        "apocalypsenow:canadian_army_helmet",
        "apocalypsenow:canadian_army_leggings",
        "apocalypsenow:canadian_army_chestplate",
        "apocalypsenow:canadian_army_boots",
        "apocalypsenow:italian_bersaglieri_army_chestplate",
        "apocalypsenow:italian_bersaglieri_army_leggings",
        "apocalypsenow:italian_bersaglieri_army_helmet",
        "apocalypsenow:italian_bersaglieri_army_boots",
        "apocalypsenow:brazilian_army_boots",
        "apocalypsenow:brazilian_army_chestplate",
        "apocalypsenow:brazilian_army_leggings",
        "apocalypsenow:brazilian_army_helmet",
        "apocalypsenow:mexican_army_boots",
        "apocalypsenow:mexican_army_chestplate",
        "apocalypsenow:mexican_army_leggings",
        "apocalypsenow:mexican_army_helmet",
        "apocalypsenow:japanese_army_helmet",
        "apocalypsenow:japanese_army_leggings",
        "apocalypsenow:japanese_army_chestplate",
        "apocalypsenow:army_helmet",
        "apocalypsenow:army_leggings",
        "apocalypsenow:army_chestplate",
        "apocalypsenow:army_boots",
        "immersiveengineering:pickaxe_steel",
        "immersiveengineering:sword_steel",
        "immersiveengineering:axe_steel",
        "immersiveengineering:wirecutter",
        "immersiveengineering:screwdriver",
        "immersiveengineering:hammer",
        "zombiekit:baseball_bat",
        "zombiekit:wrench",
        "zombiekit:chainsaw",
        "immersiveengineering:hoe_steel",
        "immersiveengineering:shovel_steel",
        "apocalypsenow:jet_pilot_helmet",
        "zombiekit:standard_tactical_helmet",
        "zombiekit:standard_tactical_leggings",
        "zombiekit:skiing_boots",
        "zombiekit:skiing_helmet",
        "zombiekit:skiing_leggings",
        "zombiekit:skiing_chestplate",
        "zombiekit:standard_tactical_boots",
        "zombiekit:standard_tactical_chestplate",
        "apocalypsenow:forestguard_boots",
        "apocalypsenow:forestguard_chestplate",
        "apocalypsenow:forestguard_leggings",
        "apocalypsenow:forestguard_helmet",
        "apocalypsenow:anarchy_boots",
        "apocalypsenow:anarchy_chestplate",
        "apocalypsenow:anarchy_leggings",
        "apocalypsenow:anarchy_helmet",
        "apocalypsenow:jet_pilot_boots",
        "apocalypsenow:jet_pilot_chestplate",
        "apocalypsenow:jet_pilot_leggings",
        "zombie_extreme:juggernaut_suit_chestplate",
        "zombie_extreme:juggernaut_suit_boots",
        "max_armory:mingguang_armor_chestplate",
        "max_armory:lamellar_armor_leggings",
        "apocalypsenow:spec_ops_helmet",
        "apocalypsenow:spec_ops_leggings",
        "apocalypsenow:spec_ops_chestplate",
        "apocalypsenow:spec_ops_boots",
        "spore:surgery_table",
        "zombie_extreme:juggernaut_suit_leggings",
        "zombie_extreme:juggernaut_suit_helmet",
        "zombie_extreme:exo_suit_boots",
        "zombie_extreme:exo_suit_chestplate",
        "zombie_extreme:exo_suit_leggings",
        "zombie_extreme:exo_suit_helmet",
        "max_armory:mingguang_armor_helmet",
        "apocalypsenow:army_boots",
        "apocalypsenow:army_chestplate",
        "apocalypsenow:army_leggings",
        "max_armory:lamellar_armor_boots",
        "zombiekit:bomb_helmet",
        "apocalypsenow:bombsquad_boots",
        "apocalypsenow:bombsquad_chestplate",
        "apocalypsenow:bombsquad_leggings",
        "apocalypsenow:bombsquad_helmet",
        "apocalypsenow:juggernaut_boots",
        "apocalypsenow:juggernaut_chestplate",
        "apocalypsenow:juggernaut_leggings",
        "apocalypsenow:juggernaut_helmet",
        "zombiekit:bomb_boots",
        "zombiekit:bomb_chestplate",
        "zombiekit:bomb_leggings",
        "create:netherite_diving_helmet",
        "create:netherite_diving_boots",
        "constructionwand:iron_wand",
        "minecraft:spyglass",
        "supplementaries:key",
        "minecraft:golden_pickaxe",
        "minecraft:iron_shovel",
        "minecraft:stone_shovel",
        "minecraft:golden_shovel",
        "minecraft:flint_and_steel",
        "minecraft:iron_pickaxe",
        "minecraft:iron_axe",
        "minecraft:diamond_axe",
        "minecraft:skeleton_skull",
        "minecraft:zombie_head",
        "apocalypsenow:cellphone",
        "apocalypsenow:watch",
        "apocalypsenow:goldenwatch",
        "minecraft:clock",
        "apocalypsenow:toothbrush",
        "apocalypsenow:toothpaste",
        "zombiekit:skiing_helmet",
        "zombiekit:skiing_chestplate",
        "zombiekit:skiing_leggings",
        "zombiekit:skiing_boots",
        "apocalypsenow:hazmat_suit_helmet",
        "apocalypsenow:hazmat_suit_boots",
        "apocalypsenow:hazmat_suit_chestplate",
        "apocalypsenow:hazmat_suit_leggings",
        "artifacts:snowshoes",
        "artifacts:bunny_hoppers",
        "artifacts:scarf_of_invisibility",
        "artifacts:lucky_scarf",
        "artifacts:cowboy_hat",
        "artifacts:anglers_hat",
        "artifacts:kitty_slippers",
        "artifacts:everlasting_beef",
        "apocalypsenow:spec_ops_helmet",
        "artifacts:panic_necklace",
        "artifacts:shock_pendant",
        "artifacts:flame_pendant",
        "artifacts:thorn_pendant",
        "artifacts:charm_of_sinking",
        "artifacts:cloud_in_a_bottle",
        "artifacts:obsidian_skull",
        "artifacts:onion_ring",
        "artifacts:rooted_boots"
    ];

    return equipmentAndTools.includes(itemId);
}