let $TimelessAPI = Java.loadClass("com.tacz.guns.api.TimelessAPI")

// 定义获取随机数的函数
function getRandomNumber(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

// 定义获取随机概率的函数
function getRandomChance(min, max) {
    return Math.random() * (max - min) + min;
}


ServerEvents.chestLootTables(event => {
    event.modify('mryh:public_chest', loot => {
        loot.addPool(pool => {
            pool.addItem('copper_ingot').weight(100).count([1, 4])
            pool.addEmpty(300)
            pool.rolls = 3
        })
    })

    event.modify('mryh:money', loot => {
        loot.addPool(pool => {
            pool.addItem('apocalypsenow:money').weight(100).count([1, 5])
            pool.addItem('apocalypsenow:money_block').weight(10).count([1, 2])
            pool.addEmpty(200)
            pool.rolls = 3
        })
    })
})



// 定义垃圾列表
let POOLS_public_chest_trash = {
    noLuck: [
        "apocalypsenow:sock",
        "minecraft:cobweb",
        "apocalypsenow:glue",
        "apocalypsenow:can",
        "apocalypsenow:papertrash",
        "apocalypsenow:bricktoys",
        "apocalypsenow:wallet",
        "apocalypsenow:goldenwatch",
        "apocalypsenow:oil_canister",
        "apocalypsenow:toiletpaper",
        "apocalypsenow:magazine",
        "apocalypsenow:pet_bottle",
        "apocalypsenow:cellphone",
        "apocalypsenow:watch",
        "apocalypsenow:newspaper",
        "apocalypsenow:files",
        "apocalypsenow:old_mug",
        "apocalypsenow:smartphone",
        "apocalypsenow:broken_radio",
        "apocalypsenow:copperwire",
        "minecraft:chain",
        "apocalypsenow:toy",
        "apocalypsenow:toothpaste",
        "apocalypsenow:toothbrush",
        "apocalypsenow:cooked_cockroach",
        "apocalypsenow:foam",
        "apocalypsenow:alcohol",
        "apocalypsenow:emptyshampoo",
        "zombiekit:death_bat",
        "minecraft:egg",
        "apocalypsenow:cigarettes",
        "apocalypsenow:perfume",
        "apocalypsenow:deodorant",
        "apocalypsenow:glassbottle",
        "apocalypsenow:emptyconditioner",
        "apocalypsenow:bottle",
        "apocalypsenow:cards",
        "apocalypsenow:credit_card",
        "apocalypsenow:aabattery",
        "apocalypsenow:comb",
        "apocalypsenow:dead_cockroach",
        "apocalypsenow:dead_rat",
        "apocalypsenow:towel"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义防具列表
let POOLS_public_chest_armor = {
    noLuck: [
        "minecraft:diamond_leggings",
        "minecraft:diamond_boots",
        "apocalypsenow:yellow_football_armor_helmet",
        "apocalypsenow:red_football_armor_helmet",
        "apocalypsenow:red_football_armor_boots",
        "minecraft:diamond_chestplate",
        "apocalypsenow:pink_bikers_helmet",
        "apocalypsenow:bikers_helmet",
        "apocalypsenow:life_jacket_bullet_helmet_chestplate",
        "apocalypsenow:black_football_armor_boots",
        "minecraft:leather_leggings",
        "minecraft:leather_chestplate",
        "apocalypsenow:patriotmotorcyclehelmet_helmet",
        "minecraft:leather_boots",
        "apocalypsenow:yellow_football_armor_chestplate",
        "apocalypsenow:red_football_armor_chestplate",
        "apocalypsenow:red_football_armor_leggings",
        "minecraft:diamond_helmet",
        "apocalypsenow:red_bikers_helmet",
        "apocalypsenow:civilian_body_vest_chestplate",
        "minecraft:leather_helmet",
        "apocalypsenow:rusty_helmet",
        "apocalypsenow:rusty_chestplate",
        "apocalypsenow:press_bulletproof_vest_chestplate",
        "apocalypsenow:green_bikers_helmet",
        "apocalypsenow:officer_helmet",
        "apocalypsenow:jasonmask_helmet",
        "apocalypsenow:black_football_armor_helmet",
        "apocalypsenow:black_football_armor_leggings",
        "minecraft:iron_boots",
        "minecraft:iron_leggings",
        "minecraft:iron_chestplate",
        "minecraft:iron_helmet",
        "apocalypsenow:divingsuit_chestplate",
        "apocalypsenow:divingsuit_leggings",
        "apocalypsenow:divingsuit_boots",
        "apocalypsenow:rusty_leggings",
        "apocalypsenow:yellow_football_armor_leggings",
        "apocalypsenow:blue_football_armor_chestplate",
        "apocalypsenow:blue_football_armor_boots",
        "apocalypsenow:yellow_football_armor_boots",
        "apocalypsenow:bluemotorcyclehelmet_helmet",
        "apocalypsenow:black_motorcycle_helmet_helmet",
        "apocalypsenow:blue_football_armor_leggings",
        "apocalypsenow:black_football_armor_chestplate",
        "apocalypsenow:red_motorcycle_helmet_helmet",
        "apocalypsenow:black_bikers_helmet",
        "apocalypsenow:blue_football_armor_helmet",
        "apocalypsenow:divingsuit_helmet",
        "apocalypsenow:rusty_boots"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义武器列表
let POOLS_public_chest_weapon = {
    noLuck: [
        "apocalypsenow:cleaver",
        "apocalypsenow:black_cleaver",
        "apocalypsenow:golf_stick",
        "apocalypsenow:table_knife",
        "zombie_extreme:baseball_bat",
        "zombie_extreme:modern_axe",
        "zombie_extreme:kitchen_knife",
        "apocalypsenow:iron_pipe",
        "apocalypsenow:chainsaw_bat",
        "apocalypsenow:fork",
        "apocalypsenow:guitar",
        "apocalypsenow:dumbbell",
        "apocalypsenow:fixed_baseball_bat",
        "apocalypsenow:baseball_bat",
        "apocalypsenow:slitting_pears",
        "apocalypsenow:wooden_fire_axe",
        "apocalypsenow:hookey_stick",
        "apocalypsenow:hatchet",
        "apocalypsenow:broken_pool_cue",
        "apocalypsenow:wired_baseball_bat",
        "apocalypsenow:spiked_baseball_bat",
        "apocalypsenow:knife_utensils",
        "apocalypsenow:knife",
        "apocalypsenow:makeshift_knife",
        "apocalypsenow:phillipsscrewdriver",
        "apocalypsenow:wrapped_baseball_bat",
        "apocalypsenow:umbrella",
        "apocalypsenow:kitchen_knife",
        "apocalypsenow:lumber_jack_axe",
        "apocalypsenow:nailed_table_leg",
        "apocalypsenow:combat_knife",
        "apocalypsenow:switch_knife",
        "apocalypsenow:spiked_iron_baseball_bat",
        "apocalypsenow:scissorst",
        "apocalypsenow:scissors",
        "apocalypsenow:razor",
        "apocalypsenow:soap_in_a_sock",
        "apocalypsenow:stapler",
        "apocalypsenow:electrical_baseball_bat",
        "apocalypsenow:broken_bottle",
        "apocalypsenow:rusty_machete",
        "apocalypsenow:fire_axe",
        "apocalypsenow:laminated_iron_baseball_bat",
        "apocalypsenow:crowbar",
        "apocalypsenow:broken_glass",
        "minecraft:iron_sword",
        "minecraft:diamond_sword",
        "minecraft:golden_sword",
        "apocalypsenow:saw_baseball_bat",
        "apocalypsenow:saw",
        "apocalypsenow:pan",
        "apocalypsenow:makeshift_axe",
        "apocalypsenow:pipe",
        "apocalypsenow:red_crowbar",
        "apocalypsenow:mosquito_knife",
        "apocalypsenow:butterfly_knife",
        "apocalypsenow:screwdriver",
        "apocalypsenow:survival_knife",
        "zombie_extreme:golf_club",
        "zombie_extreme:frying_pan",
        "zombie_extreme:wrench",
        "zombie_extreme:fittings",
        "apocalypsenow:spoon",
        "apocalypsenow:bass",
        "apocalypsenow:iron_baseball_bat",
        "apocalypsenow:hanger"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义仓储列表
let POOLS_public_chest_storage = {
    noLuck: [
        "zombiekit:compressed_biscuit",
        "minecraft:tropical_fish",
        "minecraft:mutton",
        "minecraft:cod",
        "minecraft:chicken",
        "minecraft:melon_slice",
        "minecraft:carrot",
        "zombiekit:canned_luncheon_meat",
        "farmersdelight:cabbage_leaf",
        "apocalypsenow:canned_rabbit_soup",
        "apocalypsenow:canned_corn",
        "apocalypsenow:canned_tomatos",
        "apocalypsenow:canned_carrot",
        "apocalypsenow:canned_chili",
        "apocalypsenow:canned_beans",
        "apocalypsenow:canned_melon",
        "apocalypsenow:canned_strawberry",
        "apocalypsenow:canned_pork",
        "minecraft:rabbit",
        "zombiekit:canned_yellow_peach",
        "zombiekit:canned_bread",
        "farmersdelight:chicken_cuts",
        "farmersdelight:tomato",
        "farmersdelight:wheat_dough",
        "minecraft:pumpkin_pie",
        "minecraft:porkchop",
        "minecraft:beef",
        "minecraft:beetroot",
        "zombiekit:chocolate",
        "zombiekit:canned_beans",
        "zombiekit:canned_beef_hotpot",
        "zombiekit:canned_tomatoes",
        "zombiekit:canned_fish_in_black_bean_sauce",
        "farmersdelight:raw_pasta",
        "farmersdelight:onion",
        "minecraft:potato",
        "apocalypsenow:canned_soup",
        "apocalypsenow:dogs_food",
        "apocalypsenow:canned_beetroot",
        "apocalypsenow:canned_food",
        "apocalypsenow:canned_fish",
        "farmersdelight:pumpkin_slice",
        "farmersdelight:cabbage"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义方块列表
let POOLS_public_chest_block = {
    noLuck: [
        "minecraft:quartz_slab",
        "minecraft:chiseled_quartz_block",
        "minecraft:weathered_copper",
        "minecraft:exposed_cut_copper_stairs",
        "minecraft:weathered_cut_copper",
        "minecraft:waxed_exposed_copper",
        "minecraft:waxed_exposed_cut_copper",
        "supplementaries:fine_wood_slab",
        "minecraft:nether_bricks",
        "minecraft:mangrove_log",
        "minecraft:bamboo_block",
        "minecraft:cobblestone",
        "minecraft:mossy_cobblestone",
        "minecraft:cobblestone_wall",
        "minecraft:stone_bricks",
        "minecraft:oak_log",
        "minecraft:polished_granite",
        "minecraft:andesite",
        "minecraft:polished_andesite",
        "minecraft:oak_planks",
        "minecraft:stripped_birch_wood",
        "minecraft:oak_button",
        "minecraft:birch_planks",
        "minecraft:birch_fence",
        "minecraft:birch_stairs",
        "minecraft:stripped_dark_oak_log",
        "minecraft:dark_oak_trapdoor",
        "minecraft:dark_oak_door",
        "minecraft:oak_pressure_plate",
        "minecraft:oak_trapdoor",
        "minecraft:waxed_exposed_cut_copper_stairs",
        "supplementaries:daub",
        "minecraft:exposed_copper",
        "minecraft:waxed_cut_copper_stairs",
        "minecraft:netherrack",
        "minecraft:red_nether_brick_stairs",
        "minecraft:brick_stairs",
        "minecraft:bricks",
        "supplementaries:stone_tile_slab",
        "supplementaries:stone_tile_stairs",
        "minecraft:brick_slab",
        "minecraft:birch_log",
        "minecraft:spruce_log",
        "minecraft:oak_slab",
        "minecraft:dark_oak_log",
        "minecraft:jungle_log",
        "minecraft:birch_trapdoor",
        "minecraft:acacia_log",
        "minecraft:oak_fence"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义工具列表
let POOLS_public_chest_tool = {
    noLuck: [
        "minecraft:golden_pickaxe",
        "minecraft:golden_shovel",
        "minecraft:golden_hoe",
        "minecraft:golden_axe",
        "minecraft:stone_pickaxe",
        "minecraft:stone_shovel",
        "minecraft:stone_hoe",
        "minecraft:stone_axe",
        "minecraft:diamond_axe",
        "apocalypsenow:scissors",
        "explorerscompass:explorerscompass",
        "apocalypsenow:bomb_defusing_kit",
        "zombie_extreme:crowbar",
        "modern_structures:crowbar",
        "zombiekit:crowbar",
        "apocalypsenow:can_opener",
        "zombiekit:netherite_crowbar",
        "apocalypsenow:red_crowbar",
        "naturescompass:naturescompass",
        "minecraft:rail",
        "minecraft:lead",
        "minecraft:spyglass",
        "minecraft:clock",
        "minecraft:fishing_rod",
        "minecraft:iron_pickaxe",
        "minecraft:compass",
        "minecraft:flint_and_steel",
        "minecraft:shears",
        "minecraft:iron_axe",
        "minecraft:iron_hoe",
        "minecraft:iron_shovel",
        "minecraft:firework_rocket",
        "apocalypsenow:crowbar",
        "apocalypsenow:scissorst",
        "minecraft:name_tag"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义饰品列表
let POOLS_public_chest_curios = {
    noLuck: [
        "artifacts:aqua_dashers",
        "artifacts:vampiric_glove",
        "artifacts:cloud_in_a_bottle",
        "artifacts:night_vision_goggles",
        "artifacts:umbrella",
        "artifacts:pocket_piston",
        "artifacts:eternal_steak",
        "artifacts:universal_attractor",
        "artifacts:crystal_heart",
        "artifacts:scarf_of_invisibility",
        "artifacts:golden_hook",
        "artifacts:helium_flamingo",
        "artifacts:thorn_pendant",
        "artifacts:cowboy_hat",
        "artifacts:anglers_hat",
        "artifacts:antidote_vessel",
        "artifacts:charm_of_sinking",
        "artifacts:novelty_drinking_hat",
        "artifacts:everlasting_beef",
        "artifacts:rooted_boots",
        "artifacts:whoopee_cushion",
        "artifacts:pickaxe_heater",
        "artifacts:flippers",
        "artifacts:steadfast_spikes",
        "artifacts:snowshoes",
        "artifacts:kitty_slippers",
        "artifacts:bunny_hoppers",
        "artifacts:running_shoes",
        "artifacts:superstitious_hat",
        "artifacts:fire_gauntlet",
        "artifacts:power_glove",
        "artifacts:feral_claws",
        "artifacts:digging_claws",
        "artifacts:onion_ring",
        "artifacts:obsidian_skull",
        "artifacts:plastic_drinking_hat",
        "artifacts:lucky_scarf",
        "artifacts:cross_necklace",
        "artifacts:flame_pendant",
        "artifacts:villager_hat",
        "artifacts:snorkel",
        "artifacts:shock_pendant",
        "artifacts:panic_necklace"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义食物列表
let POOLS_public_chest_food = {
    noLuck: [
        "apocalypsenow:cheese",
        "apocalypsenow:cream_cracker",
        "apocalypsenow:large_soda",
        "apocalypsenow:beer",
        "apocalypsenow:coffee",
        "apocalypsenow:coke",
        "apocalypsenow:mre",
        "apocalypsenow:vodka",
        "apocalypsenow:porpsi",
        "apocalypsenow:cooked_chicken_wing",
        "apocalypsenow:cooked_canned_fish",
        "apocalypsenow:cooked_canned_chilie",
        "apocalypsenow:cooked_canned_pork",
        "apocalypsenow:cooked_canned_rabbit_soup",
        "apocalypsenow:cooked_canned_food",
        "apocalypsenow:cooked_canned_beans",
        "apocalypsenow:cooked_canned_soup",
        "apocalypsenow:contaminated_water",
        "apocalypsenow:water",
        "apocalypsenow:orange",
        "apocalypsenow:orange_juice",
        "apocalypsenow:open_canned_pork",
        "apocalypsenow:open_canned_melon",
        "apocalypsenow:open_canned_beetroot",
        "apocalypsenow:open_canned_tomatos",
        "apocalypsenow:open_canned_carrot",
        "apocalypsenow:open_canned_strawberry",
        "apocalypsenow:open_canned_beans",
        "apocalypsenow:open_canned_chili",
        "apocalypsenow:open_canned_food",
        "apocalypsenow:sugar_free_soda",
        "apocalypsenow:nonalcoholic_beer",
        "apocalypsenow:marmalade",
        "apocalypsenow:open_canned_rabbit_soup",
        "apocalypsenow:chocolate_bar",
        "apocalypsenow:macandcheese",
        "apocalypsenow:open_canned_corn",
        "apocalypsenow:open_canned_soup",
        "apocalypsenow:canned_water",
        "apocalypsenow:vitamins",
        "apocalypsenow:tomato",
        "apocalypsenow:lettuce",
        "apocalypsenow:donut",
        "apocalypsenow:open_dogs_food",
        "apocalypsenow:milk",
        "farmersdelight:barbecue_stick",
        "farmersdelight:smoked_ham",
        "farmersdelight:baked_cod_stew",
        "farmersdelight:fried_rice",
        "farmersdelight:ham",
        "farmersdelight:mixed_salad",
        "farmersdelight:kelp_roll",
        "farmersdelight:kelp_roll_slice",
        "farmersdelight:hamburger",
        "farmersdelight:fruit_salad",
        "farmersdelight:chocolate_pie_slice",
        "farmersdelight:bone_broth",
        "apocalypsenow:wine",
        "apocalypsenow:chips",
        "apocalypsenow:cereal",
        "apocalypsenow:chicken_wing",
        "apocalypsenow:butter",
        "farmersdelight:nether_salad",
        "farmersdelight:pumpkin_soup",
        "farmersdelight:cabbage_rolls",
        "farmersdelight:glow_berry_custard",
        "farmersdelight:bacon_sandwich",
        "farmersdelight:bacon_and_eggs",
        "farmersdelight:stuffed_potato",
        "apocalypsenow:nutrition_bar",
        "apocalypsenow:applejuicebox",
        "apocalypsenow:energy_drink",
        "farmersdelight:beef_patty",
        "farmersdelight:beef_stew",
        "farmersdelight:cooked_chicken_cuts",
        "farmersdelight:cooked_cod_slice",
        "farmersdelight:cooked_salmon_slice",
        "farmersdelight:cooked_mutton_chops",
        "farmersdelight:cooked_bacon",
        "farmersdelight:fried_egg",
        "farmersdelight:hot_cocoa",
        "farmersdelight:chicken_soup",
        "farmersdelight:chicken_sandwich",
        "farmersdelight:cod_roll",
        "farmersdelight:salmon_roll",
        "farmersdelight:fish_stew",
        "farmersdelight:pie_crust",
        "farmersdelight:dumplings",
        "farmersdelight:noodle_soup",
        "farmersdelight:melon_juice",
        "farmersdelight:melon_popsicle",
        "farmersdelight:honey_cookie",
        "farmersdelight:cake_slice",
        "farmersdelight:bacon",
        "farmersdelight:mutton_chops",
        "farmersdelight:salmon_slice",
        "farmersdelight:cod_slice",
        "farmersdelight:tomato_sauce",
        "farmersdelight:cooked_rice",
        "farmersdelight:pasta_with_mutton_chop",
        "farmersdelight:mutton_wrap",
        "farmersdelight:pasta_with_meatballs",
        "farmersdelight:apple_pie_slice",
        "farmersdelight:apple_cider",
        "farmersdelight:vegetable_soup",
        "farmersdelight:sweet_berry_cheesecake_slice",
        "farmersdelight:sweet_berry_cookie",
        "farmersdelight:minced_beef",
        "zombie_extreme:whiskey",
        "zombie_extreme:vodka",
        "supplementaries:candy",
        "minecraft:bread",
        "minecraft:apple",
        "minecraft:salmon",
        "minecraft:cookie",
        "minecraft:glow_berries",
        "farmersdelight:egg_sandwich",
        "zombie_extreme:cat_food",
        "zombie_extreme:canned_fruit",
        "zombie_extreme:canned_soup",
        "zombie_extreme:canned_apples",
        "zombie_extreme:canned_beans",
        "zombie_extreme:canned_food",
        "zombie_extreme:soda",
        "zombie_extreme:chips",
        "zombie_extreme:green_apple",
        "zombie_extreme:dog_food",
        "zombie_extreme:rotten_apple",
        "zombie_extreme:canned_stew"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义杂物列表
let POOLS_public_chest_odds = {
    noLuck: [
        "apocalypsenow:textilethread",
        "minecraft:feather",
        "zombiekit:latex",
        "zombiekit:quartz_sand",
        "minecraft:leather",
        "zombiekit:sulfur",
        "zombiekit:hydrogen_nitrate",
        "zombiekit:saltpeter",
        "zombiekit:saltpeter_soil",
        "apocalypsenow:ducttape",
        "zombiekit:cloth",
        "minecraft:stick",
        "minecraft:book",
        "minecraft:rabbit_foot",
        "zombiekit:plastics",
        "apocalypsenow:plastic",
        "apocalypsenow:plasticplate",
        "minecraft:ink_sac",
        "minecraft:phantom_membrane",
        "apocalypsenow:scrapmetal",
        "apocalypsenow:money",
        "minecraft:blaze_powder",
        "apocalypsenow:electrical_scrap",
        "zombiekit:crude_nitrate",
        "minecraft:sugar",
        "zombiekit:fibre",
        "minecraft:paper",
        "minecraft:prismarine_crystals",
        "zombiekit:rubber",
        "zombiekit:camphor",
        "minecraft:slime_ball",
        "apocalypsenow:engineering_parts",
        "zombiekit:smokeless_gunpowder",
        "zombiekit:alcohol",
        "apocalypsenow:gunpowder_can",
        "minecraft:prismarine_shard",
        "minecraft:bone_meal",
        "minecraft:bone",
        "minecraft:clay_ball",
        "apocalypsenow:sawi",
        "zombiekit:iron_wire",
        "zombiekit:nitrocellulose",
        "minecraft:spider_eye",
        "minecraft:honeycomb"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义矿物列表
let POOLS_public_chest_mineral = {
    noLuck: [
        "create:raw_zinc",
        "minecraft:raw_copper",
        "minecraft:raw_iron",
        "minecraft:raw_gold",
        "minecraft:flint",
        "minecraft:coal",
        "minecraft:gunpowder",
        "minecraft:charcoal",
        "minecraft:quartz",
        "minecraft:iron_nugget",
        "minecraft:gold_ingot",
        "minecraft:gold_nugget",
        "minecraft:iron_ingot",
        "minecraft:copper_ingot",
        "minecraft:lapis_lazuli",
        "minecraft:glowstone_dust",
        "minecraft:redstone",
        "minecraft:amethyst_shard"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};
// 定义子弹列表
let POOLS_public_chest_ammo = {
    noLuck: [
        "cyber_armorer:bullet_rifle",
        "cyber_armorer:bullet_buckshot",
        "cyber_armorer:bullet_sniper",
        "tacz:57x28",
        "tacz:762x25",
        "tacz:46x30",
        "tacz:762x54",
        "tacz:45acp",
        "tacz:12g",
        "tacz:357mag",
        "tacz:50bmg",
        "tacz:308",
        "tacz:338",
        "tacz:762x39",
        "tacz:556x45",
        "tacz:30_06",
        "tacz:58x42",
        "tacz:68x51fury",
        "tacz:9mm",
        "tacz:50ae",
        "cyber_armorer:bullet_pistol"
    ],
    luck2: [
    ],
    luck6: [
    ],
    hardMode: [
    ],
    TagMode: [
    ]
};
// 定义枪械列表
let POOLS_public_chest_gun = {
    noLuck: [
        "tacz:ump45",
        "bluearchive:mika",
        "bluearchive:kurumi",
        "bf1:smg0818",
        "gfl2:mourningwhispers",
        "tacz:p90",
        "tacz:hk_mp5a5",
        "mpworld:ls30d",
        "bluearchive:miyako",
        "applied_armorer:niklas_pistol_semi_pride",
        "create_armorer:pistol_auto_stress",
        "applied_armorer:niklas_pistol_semi_union",
        "create_armorer:pistol_revolver_torque",
        "tacz:cz75",
        "bf1:kolibri",
        "immersive_armorer:standard_rail_pistol_mk3",
        "tacz:p320",
        "bf1:sw_model3",
        "tacz:deagle_golden",
        "mpworld:leftdeagle",
        "tacz:deagle",
        "applied_armorer:niklas_pistol_semi_right",
        "immersive_armorer:standard_rail_pistol_mk2",
        "mpworld:leftdeagle2",
        "bf1:syringe",
        "gfl2:ppsh_41",
        "trisdyna:cms92",
        "tacz:uzi",
        "mpworld:ms39",
        "mpworld:ise_52b",
        "tacz:vector45",
        "mpworld:ise_52",
        "gfl2:suomi",
        "bluearchive:natsu",
        "mpworld:ise_52c",
        "immersive_armorer:standard_rail_pistol_mk1",
        "bf1:obrez",
        "immersive_armorer:pistol_9mm",
        "helldiver2:p2_peacemaker",
        "tacz:m1911",
        "mpworld:qs38",
        "tacz:glock_17",
        "immersive_armorer:revolver",
        "bf1:handgun",
        "tacz:db_short",
        "bluearchive:niko",
        "tacz:db_long",
        "cyber_armorer:m2038",
        "create_armorer:shotgun_db_stone",
        "bf1:model10",
        "mpworld:shot",
        "create_armorer:shotgun_pump_bearing",
        "tacz:m870",
        "mpworld:m870s",
        "bc:dd",
        "immersive_armorer:pump_shotgun",
        "immersive_armorer:standard_rail_pistol_mk4"
    ],
    luck2: [
    ],
    luck6: [
    ],
    hardMode: [
    ],
    TagMode: [
    ]
};
// 定义无名饰品列表
let POOLS_public_chest_nameless = {
    noLuck: [
        "nameless_trinkets:rage_mind",
        "nameless_trinkets:fertilizer",
        "nameless_trinkets:creeper_sense",
        "nameless_trinkets:sleeping_pills",
        "nameless_trinkets:spider_legs",
        "nameless_trinkets:reforger",
        "nameless_trinkets:gills",
        "nameless_trinkets:amphibious_hands",
        "nameless_trinkets:unknown_fragment",
        "nameless_trinkets:fractured_nullstone",
        "nameless_trinkets:miners_soul",
        "nameless_trinkets:tick",
        "nameless_trinkets:broken_magnet",
        "nameless_trinkets:experience_magnet",
        "nameless_trinkets:wooden_stick",
        "nameless_trinkets:super_magnet",
        "nameless_trinkets:vampire_blood",
        "nameless_trinkets:speed_force",
        "nameless_trinkets:ice_cube",
        "nameless_trinkets:callus",
        "nameless_trinkets:blindfold",
        "nameless_trinkets:electric_paddle",
        "nameless_trinkets:what_magnet",
        "nameless_trinkets:tear_of_the_sea",
        "nameless_trinkets:nelumbo",
        "nameless_trinkets:dark_nelumbo",
        "nameless_trinkets:four_leaf_clover",
        "nameless_trinkets:pocket_lightning_rod",
        "nameless_trinkets:fragile_cloud",
        "nameless_trinkets:scarab_amulet",
        "nameless_trinkets:puffer_fish_liver",
        "nameless_trinkets:blaze_nucleus",
        "nameless_trinkets:fate_emerald",
        "nameless_trinkets:light_gloves",
        "nameless_trinkets:dragons_eye",
        "nameless_trinkets:moon_stone",
        "nameless_trinkets:sigil_of_baphomet",
        "nameless_trinkets:ethereal_wings",
        "nameless_trinkets:missing_page",
        "nameless_trinkets:reverse_card",
        "nameless_trinkets:experience_battery",
        "nameless_trinkets:explosion_proof_jacket",
        "nameless_trinkets:ghast_eye",
        "nameless_trinkets:true_heart_of_the_sea",
        "nameless_trinkets:lucky_rock",
        "nameless_trinkets:cracked_crown",
        "nameless_trinkets:gods_crown"
    ],
    luck2: [

    ],
    luck6: [

    ],
    hardMode: [

    ],
    TagMode: [

    ]
};

// 获取枪械可用的开火模式
function getNextFireMode(gunId) {
	let nextFireMode = ''
	let firModeSet = []
	$TimelessAPI.getCommonGunIndex(gunId).map(gunIndex => {
		firModeSet = gunIndex.getGunData().getFireModeSet()
	})
	if(firModeSet.length > 0) {
		if(firModeSet.indexOf('AUTO') != -1) {
			nextFireMode = 'AUTO'
		} else if(firModeSet.indexOf('BURST') != -1) {
			nextFireMode = 'BURST'
		} else {
			nextFireMode = firModeSet[0]
		}
	}
	return nextFireMode
}

// 战利品表修改器
LootJS.modifiers(e => {
    // 统一的战利品表修改逻辑
    let modifyLootTable = (tableId, config) => {
        e.addLootTableModifier(tableId)
            .randomChance(config.randomChanceValue)
            .apply(context => {
                let { luck, level, player } = context;
                let difficulty = level.difficulty.id;
                if (!player) return;

                // 获取最终物品池和概率乘数
                let { finalLootPool, chanceMultiplier } = getFinalLootPool(
                    config.pool,
                    luck,
                    difficulty,
                    player
                );

                // 如果物品池为空则不添加战利品
                if (finalLootPool.length === 0) return;

                // 基础概率
                let BASE_CHANCE = 0.3;
                let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);

                // 随机生成物品数量
                let rolls = getRandomNumber(config.minRolls, config.maxRolls);

                // 为每次roll添加随机物品
                for (let i = 0; i < rolls; i++) {
                    let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                    let selectedItem = finalLootPool[randomIndex];
                    let count = getRandomNumber(config.minCount, config.maxCount);

                    // 随机条目概率
                    let randomEntryChance = getRandomChance(config.minchance, config.maxchance);

                    // 创建战利品条目
                    let entry;
                    if (config.isAmmo) {
                        // 子弹物品特殊处理
                        entry = LootEntry.of('tacz:ammo', count, { AmmoId: selectedItem })
                            .withChance(randomEntryChance)
                            .when(c => c.randomChance(finalChance));
                    } else if (config.isGun) {
                        let nextFireMode = getNextFireMode(selectedItem)
                        if(nextFireMode) {
							entry = LootEntry.of(Item.of('tacz:modern_kinetic_gun', '{GunId: "' + selectedItem + '", GunFireMode: "' + nextFireMode + '"}'), 1)
								.withChance(randomEntryChance)
								.when(c => c.randomChance(finalChance));
                        } else {
							entry = LootEntry.of('tacz:modern_kinetic_gun', 1, { GunId: selectedItem })
								.withChance(randomEntryChance)
								.when(c => c.randomChance(finalChance));
						}
                    } else {
                        // 普通物品
                        entry = LootEntry.of(selectedItem, count)
                            .withChance(randomEntryChance)
                            .when(c => c.randomChance(finalChance));
                    }

                    context.addLoot(entry);
                }
            });
    };

    // 应用各种物品池到公共箱子
    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_trash,
        randomChanceValue: 0.5,
        minRolls: 1,
        maxRolls: 3,
        minCount: 1,
        maxCount: 2,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_block,
        randomChanceValue: 0.4,
        minRolls: 1,
        maxRolls: 3,
        minCount: 3,
        maxCount: 10,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_odds,
        randomChanceValue: 0.3,
        minRolls: 1,
        maxRolls: 2,
        minCount: 2,
        maxCount: 5,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_food,
        randomChanceValue: 0.3,
        minRolls: 1,
        maxRolls: 2,
        minCount: 1,
        maxCount: 5,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_storage,
        randomChanceValue: 0.3,
        minRolls: 1,
        maxRolls: 3,
        minCount: 1,
        maxCount: 5,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_ammo,
        randomChanceValue: 0.3,
        minRolls: 1,
        maxRolls: 2,
        minCount: 5,
        maxCount: 20,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: true,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_mineral,
        randomChanceValue: 0.2,
        minRolls: 1,
        maxRolls: 2,
        minCount: 1,
        maxCount: 5,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_gun,
        randomChanceValue: 0.1,
        minRolls: 1,
        maxRolls: 2,
        minCount: 1,
        maxCount: 1,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: true
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_tool,
        randomChanceValue: 0.1,
        minRolls: 1,
        maxRolls: 2,
        minCount: 1,
        maxCount: 1,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_weapon,
        randomChanceValue: 0.1,
        minRolls: 1,
        maxRolls: 2,
        minCount: 1,
        maxCount: 1,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_armor,
        randomChanceValue: 0.1,
        minRolls: 1,
        maxRolls: 2,
        minCount: 1,
        maxCount: 1,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_curios,
        randomChanceValue: 0.02,
        minRolls: 1,
        maxRolls: 1,
        minCount: 1,
        maxCount: 1,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });

    modifyLootTable('mryh:chests/public_chest', {
        pool: POOLS_public_chest_nameless,
        randomChanceValue: 0.01,
        minRolls: 1,
        maxRolls: 1,
        minCount: 1,
        maxCount: 1,
        minchance: 0.1,
        maxchance: 0.5,
        isAmmo: false,
        isGun: false
    });
});    