



ItemEvents.tooltip(event => {
    let lang = "kubejs/assets/mryh/lang/" + Client.languageManager.selected.toString() + ".json";
    let json = JsonIO.read(lang);
    json = JsonIO.toObject(json);

    json.forEach(element => {
        // 根据langkey组织物品id
        if (element.includes("item.") && element.includes("tooltip")) {
            // 获取modid
            let modid = element.split('.')[1];
            // 将id和langkey组织到1个列表，以便于addAdvanced的内部函数可以访问到langkey
            let itemID = modid + ":" + element.split('.')[2];
            let itemElement = [itemID, element];
            event.addAdvanced(itemElement[0], (item, advance, text) => {
                // 检查是否按下了Shift或Alt键
                if (event.isShift()) {
                    // Shift键
                    for (let i = 1; i < itemElement.length; i++) {
                        const element = itemElement[i];
                        text.add(i, Text.translate(element + ".shift"));
                    }
                } else if (event.isAlt()) {
                    // Alt键
                    for (let i = 1; i < itemElement.length; i++) {
                        const element = itemElement[i];
                        text.add(i, Text.translate(element + ".alt"));
                    }
                } else {
                    // 默认显示
                    for (let i = 1; i < itemElement.length; i++) {
                        const element = itemElement[i];
                        text.add(i, Text.translate(element));
                    }
                }
            });
        }
    });
});

//例子
/*
"item.mryh.example.tooltip": "Default tooltip text"
"item.mryh.example.tooltip.alt": "Alt key tooltip text"
"item.mryh.example.tooltip.shift": "Shift key tooltip text"
*/



ItemEvents.tooltip(e => {
    let items = [
        "zombiekit:exo_helmet",
        "marbledsarsenal:hazmat_armor_helmet",
        "apocalypsenow:contamination_suit_green_helmet",
        "apocalypsenow:hazmat_suit_helmet",
        "apocalypsenow:advanced_hazmat_suit_helmet",
        "apocalypsenow:contamination_suit_white_helmet",
        "apocalypsenow:level_a_hazmatsuit_helmet",
        "zombie_extreme:hazmat_suit_helmet",
        "spore:plated_helmet",
        "spore:living_helmet",
        "spore:inf_helmet",
        "zombie_extreme:juggernaut_suit_helmet",
        "apocalypsenow:brazilian_army_helmet",
        "apocalypsenow:british_army_helmet",
        "apocalypsenow:canadian_army_helmet",
        "apocalypsenow:chinese_army_helmet",
        "apocalypsenow:bombsquad_helmet",
        "zombiekit:bomb_helmet",
        "apocalypsenow:italian_bersaglieri_army_helmet",
        "apocalypsenow:japanese_army_helmet",
        "zombie_extreme:exo_suit_helmet",
        "apocalypsenow:mexican_army_helmet",
        "apocalypsenow:russian_army_helmet",
        "apocalypsenow:juggernaut_helmet",
        "apocalypsenow:usa_armor_helmet",
        "apocalypsenow:army_helmet",
        "zombiekit:exo_chestplate",
        "marbledsarsenal:hazmat_armor_chestplate",
        "apocalypsenow:advanced_hazmat_suit_chestplate",
        "apocalypsenow:contamination_suit_white_chestplate",
        "apocalypsenow:contamination_suit_blue_chestplate",
        "apocalypsenow:level_a_hazmatsuit_chestplate",
        "zombie_extreme:hazmat_suit_chestplate",
        "spore:inf_chest",
        "spore:plated_chest",
        "spore:living_chest",
        "spore:r_elytron",
        "spore:inf_up_chest",
        "zombie_extreme:juggernaut_suit_chestplate",
        "apocalypsenow:brazilian_army_chestplate",
        "apocalypsenow:british_army_chestplate",
        "apocalypsenow:canadian_army_chestplate",
        "apocalypsenow:chinese_army_chestplate",
        "apocalypsenow:bombsquad_chestplate",
        "zombiekit:bomb_chestplate",
        "apocalypsenow:italian_bersaglieri_army_chestplate",
        "apocalypsenow:japanese_army_chestplate",
        "zombie_extreme:exo_suit_chestplate",
        "apocalypsenow:mexican_army_chestplate",
        "apocalypsenow:russian_army_chestplate",
        "apocalypsenow:juggernaut_chestplate",
        "apocalypsenow:usa_armor_chestplate",
        "apocalypsenow:army_chestplate",
        "zombiekit:exo_leggings",
        "marbledsarsenal:hazmat_armor_leggings",
        "apocalypsenow:hazmat_suit_leggings",
        "apocalypsenow:advanced_hazmat_suit_leggings",
        "apocalypsenow:contamination_suit_white_leggings",
        "apocalypsenow:level_a_hazmatsuit_leggings",
        "zombie_extreme:hazmat_suit_leggings",
        "apocalypsenow:contamination_suit_blue_leggings",
        "spore:inf_pants",
        "spore:plated_pants",
        "spore:living_pants",
        "zombie_extreme:juggernaut_suit_leggings",
        "apocalypsenow:brazilian_army_leggings",
        "apocalypsenow:british_army_leggings",
        "apocalypsenow:canadian_army_leggings",
        "apocalypsenow:chinese_army_leggings",
        "apocalypsenow:bombsquad_leggings",
        "zombiekit:bomb_leggings",
        "apocalypsenow:italian_bersaglieri_army_leggings",
        "apocalypsenow:japanese_army_leggings",
        "zombie_extreme:exo_suit_leggings",
        "apocalypsenow:mexican_army_leggings",
        "apocalypsenow:russian_army_leggings",
        "apocalypsenow:juggernaut_leggings",
        "apocalypsenow:usa_armor_leggings",
        "apocalypsenow:army_leggings",
        "zombiekit:exo_boots",
        "marbledsarsenal:hazmat_armor_boots",
        "apocalypsenow:hazmat_suit_boots",
        "apocalypsenow:advanced_hazmat_suit_boots",
        "apocalypsenow:contamination_suit_white_boots",
        "apocalypsenow:level_a_hazmatsuit_boots",
        "spore:inf_boots",
        "spore:plated_boots",
        "spore:living_boots",
        "zombie_extreme:juggernaut_suit_boots",
        "apocalypsenow:brazilian_army_boots",
        "apocalypsenow:british_army_boots",
        "apocalypsenow:canadian_army_boots",
        "apocalypsenow:chinese_army_boots",
        "apocalypsenow:bombsquad_boots",
        "zombiekit:bomb_boots",
        "apocalypsenow:italian_bersaglieri_army_boots",
        "apocalypsenow:japanese_army_boots",
        "zombie_extreme:exo_suit_boots",
        "apocalypsenow:mexican_army_boots",
        "apocalypsenow:russian_army_boots",
        "apocalypsenow:juggernaut_boots",
        "apocalypsenow:usa_armor_boots",
        "apocalypsenow:army_boots"
    ]
    items.forEach(item => {
        e.add(item, Text.yellow("辐射防护能力"))
    });
})

// 撬棍概率提示
ItemEvents.tooltip(e => {
    e.add('zombiekit:crowbar', Text.yellow("有60%概率撬开战利品容器"))
    e.add('zombiekit:netherite_crowbar', Text.yellow("有90%概率撬开战利品容器"))
})

// 开罐器提示
ItemEvents.tooltip(e => {
    let items = [
        'apocalypsenow:canned_carrot',
        'apocalypsenow:canned_fish',
        'apocalypsenow:canned_strawberry',
        'apocalypsenow:canned_tomatos',
        'apocalypsenow:canned_food',
        'apocalypsenow:canned_pork',
        'apocalypsenow:canned_beans',
        'apocalypsenow:canned_rabbit_soup',
        'apocalypsenow:canned_corn',
        'apocalypsenow:canned_chili',
        'apocalypsenow:canned_beetroot'
    ]
    items.forEach(item => {
        e.add(item, Text.yellow("需要「开罐器」"))
    });
})

ItemEvents.tooltip(e => {
    e.add('endrem:magical_eye', Text.yellow("可用任意枪械进行合成"))
})

ItemEvents.tooltip(e => {

    let items = [
        'apocalypsenow:bandage',
        'apocalypsenow:stringandneedle',
        'apocalypsenow:rags',
        'apocalypsenow:cleanrags'
    ]

    items.forEach(item => {
        e.addAdvanced(item, (item, advanced, text) => {
            text.remove(1)
            text.add(1, Text.red("[用于止血]"))
        })
    });
})