#version 120
#extension GL_ARB_shader_texture_lod : enable
#extension GL_EXT_gpu_shader4 : enable

#define THIS_IS_DISTANT_HORIZONS 1
uniform vec3 cameraPosition;

//#define SHADOW_DISABLE_ALPHA_MIPMAPS // Disables mipmaps on the transparency of alpha-tested things like foliage, may cost a few fps in some cases
//#define Stochastic_Transparent_Shadows // Highly recommanded to enable SHADOW_DISABLE_ALPHA_MIPMAPS with it. Uses noise to simulate transparent objects' shadows (not colored). It is also recommended to increase Min_Shadow_Filter_Radius with this.
varying vec2 texcoord;
uniform sampler2D tex;
uniform sampler2D specular;
uniform sampler2D noisetex;

#define FIX_SSS_LIGHT_LEAK 1 //[0 1] //turning this off will make things directly on top of honey or leaves not cast shadows into it . off will make forest canopies brighter as branches and trunks will not cast shadows on leaves . off may save performance

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
float blueNoise(){
  return texelFetch2D(noisetex, ivec2(gl_FragCoord.xy)%512, 0).a;
}
varying vec3 positiona; 
varying vec3 orientation;
uniform vec3 upPosition;
uniform float far;
void main() {

 if(length(positiona.xyz-cameraPosition) < far) discard;

	gl_FragData[0] = texture2D(tex,texcoord.xy);
	//clamp(1.-distance(normalize(sunPosition.xyz),face_normals)/1.42,0.,1.)
	
	//float o2 =dot(orientation,normalize(upPosition));// .001*(floor(orientation.z*500+500)+floor(orientation.y*50*50)+floor(orientation.x*5+5));
	 float o2 =dot(orientation,mat3(gl_ModelViewMatrix) * vec3(0.0,1.0,0.0));
	
	//gl_FragData[1] = vec4(orientation);
	#if THIS_IS_DISTANT_HORIZONS != 1
	gl_FragData[1] = vec4(texture2D(specular,texcoord.xy).rgb,o2); // 13
	#ifdef SHADOW_DISABLE_ALPHA_MIPMAPS
	 gl_FragData[0].a = texture2DLod(tex,texcoord.xy,0).a;
	#endif
	#else
	gl_FragData[1] = vec4(0.04,0.04,1.,o2); // 13
	#ifdef SHADOW_DISABLE_ALPHA_MIPMAPS
	 gl_FragData[0].a = 1.;
	#endif
	#endif
	
	
  #ifdef Stochastic_Transparent_Shadows
	 gl_FragData[0].a = float(gl_FragData[0].a >= blueNoise());
  #endif
}
