#version 120
//Render sky, volumetric clouds, direct lighting
#extension GL_EXT_gpu_shader4 : enable
//#define POM
#define Depth_Write_POM	// POM adjusts the actual position, so screen space shadows can cast shadows on POM
#define POM_DEPTH 0.15 // [0.025 0.05 0.075 0.1 0.125 0.15 0.20 0.25 0.30 0.50 0.75 1.0] //Increase to increase POM strength
#define CAVE_LIGHT_LEAK_FIX // Hackish way to remove sunlight incorrectly leaking into the caves. Can inacurrately create shadows in some places
//#define CLOUDS_SHADOWS
#define CLOUDS_SHADOWS_STRENGTH 1.0 //[0.1 0.125 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.9 1.0]
#define CLOUDS_QUALITY 0.35 //[0.1 0.125 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.9 1.0]
#define TORCH_R 1.0 // [0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.0]
#define TORCH_G 0.4 // [0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.0]
#define TORCH_B 0.15 // [0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.2 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.3 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.4 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.5 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.6 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.7 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.8 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.9 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99 1.0]
#define Emissive_Strength 1.00 // [0.10 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.20 0.22 0.23 0.25 0.27 0.29 0.32 0.34 0.37 0.40 0.43 0.46 0.50 0.54 0.58 0.63 0.68 0.74 0.79 0.86 0.93 1.00 1.08 1.17 1.26 1.36 1.47 1.59 1.71 1.85 2.00 2.16 2.33 2.51 2.72 2.93 3.17 3.42 3.69 3.99 4.30 4.65 5.02 5.42 5.85 6.32 6.82 7.37 7.95 8.59 9.27 10.01 10.81 11.68 12.61 13.61 14.70 15.87 17.14 18.51 19.99 21.58 23.30 25.16 27.17 29.34 31.68 34.21 36.94 39.89 43.07 46.50 50.22 54.22 58.55 63.22 68.27 73.72 79.60 85.95 92.81 100.22 108.21 116.85 126.17 136.24 147.11 158.85 171.53 185.22 200.00]

#define AMBIENT_LIGHT_FLAT 0.2 //[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //multiply the old flat chocapic13's ambient light . Use this to brighten shadows . This will easily hide raytraced lighting!
#define INTEGRATED_SSS 1.0 //[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //multiply chocapic13's INTEGRATED Sub Surface Scattering   . which makes things without a pbr texture still maybe have the effect
#define SSS_DECAY_RATE 1.0 //[0.25 0.5 0.75 1.0 1.5 2.0 2.5 3.0] //Sub Surface Scattering will be absorbed faster by this rate . 1.0 is 3 blocks of depth . 3.0 is about 1 block of depth

#define SSS_SCATTER_WIDTH 30.0 //[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 7.0 10.0 20 30 40 50 100]

#define BORDER_FOG 3 //[0 1 2 3 4 5 6 7 8 9 10] // amount of render distance in tenths to use for border fog . it's a fade out effect . high values will have light leak in fog at sunset
#define BORDER_FOG_CLOUDS 4 //[0 1 2 3 4 5 6 7 8 9 10] // amount of the fog distance in tenths to have clouds in . 0 or too low will create pop-in! 10 will be very smooth fade in with clouds in it . 10 was the old default
#define BORDER_FOG_ALTITUDE 3 //[0 1 2 3 4 5 6 7 8 9 10] // add height based fog this high

#define LIGHT_LEAK_ANGLE_LIMIT 0.9 //[ 0.0 0.01 0.02 0.03 0.1 0.15 0.16 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.5 2.0] //adjusting this will reduce shadow seams in seamless 3d textures when using no-cubes . high might disable light leak fix for corners . low will create shadow seams on block edges that are smooth, not sharp

uniform int heldBlockLightValue2;


#include "/settings_1.glsl"
uniform float frameTime;
//DEBUG FIX ME HERE AND IN JANKTRACING5
float randomfast(in float x)
{
return fract(sin(x));
}
uniform float far;
uniform float near;
#if defined IS_IRIS && defined DISTANT_HORIZONS

	uniform float dhNearPlane;
	uniform float dhFarPlane;
	
	//define far1 dhFarPlane
	//define near1 dhNearPlane
	
	#define far1 far
	#define near1 near
#else
	#define far1 far
	#define near1 near
#endif


#if defined IS_IRIS && defined DISTANT_HORIZONS

float linearize_depth_dh(in float d)
{
#if CPF_near1_far1__WORKAROUND == 1
float far = RENDER_DISTANCE_CPF;
float near = 0.05;
#endif
    // from gl_FragCoord.z to world measurements
    return 2.0 * dhNearPlane  * dhFarPlane / (dhFarPlane + dhNearPlane - (2.0 * d - 1.0) * (dhFarPlane - dhNearPlane));

}
#endif

vec4 tangent;
uniform float wetness;
uniform vec3 sunPosition;
uniform vec3 upPosition;

float  insun2;
uniform int worldTime;

const bool shadowHardwareFiltering = true;

flat varying vec4 lightCol; //main light source color (rgb),used light source(1=sun,-1=moon)
flat varying vec3 ambientUp;
flat varying vec3 ambientLeft;
flat varying vec3 ambientRight;
flat varying vec3 ambientB;
flat varying vec3 ambientF;
flat varying vec3 ambientDown;
flat varying vec3 WsunVec;
flat varying vec2 TAA_Offset;
flat varying float tempOffsets;
flat varying vec3 refractedSunVec;

uniform sampler2D colortex0;//clouds
uniform sampler2D colortex1;//albedo(rgb),material(alpha) RGBA16
uniform sampler2D colortex4;//Skybox
uniform sampler2D colortex9;//specular
uniform sampler2D colortex11;//tangent

uniform sampler2D colortex10;//tangent2
/*
const bool colortex10MipmapEnabled = true;
*/
uniform sampler2D colortex12;//specular 2

uniform sampler2D colortex13;//specular sss
uniform sampler2D colortex14;//specular 3, screen space
uniform sampler2D colortex15;//specular 3,relative position
uniform sampler2D shadowcolor1;
uniform sampler2D colortex3;
uniform sampler2D colortex5;
uniform sampler2D colortex7;
uniform sampler2D  shadowtex1;
uniform sampler2D colortex6; // Noise
uniform sampler2D depthtex1;//depth
uniform sampler2D depthtex0;//depth
uniform sampler2D noisetex;//depth
uniform sampler2DShadow shadow;

uniform int heldBlockLightValue;
uniform int frameCounter;
uniform int isEyeInWater;


uniform float frameTimeCounter;
uniform float rainStrength;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform vec3 previousCameraPosition;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferModelView;
uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform vec2 texelSize;
uniform vec3 cameraPosition;
uniform vec3 sunVec;
uniform ivec2 eyeBrightnessSmooth;
//uniform vec3 waterfogcolor;
#include "lib/Shadow_Params.glsl"
float linearize_depth_cpf(in float d)
{
#if CPF_near1_far1__WORKAROUND == 1
float far1 = RENDER_DISTANCE_CPF;
float near1 = 0.05;
#endif
    // from gl_FragCoord.z to world measurements
    return 2.0 * near1  * far1 / (far1 + near1 - (2.0 * d - 1.0) * (far1 - near1));

}



float delinearize_depth_cpf(in float dee)
{// from world measurements to gl_FragDepth

#if CPF_near1_far1__WORKAROUND == 1
float far1 = RENDER_DISTANCE_CPF;
float near1 = 0.05;
#endif
    return ( ( (far1 + near1 - 2.0 * near1 * far1 / dee) / (far1 - near1) )  + 1.0) / 2.0;
}


float shadow2(in vec3 sh,in float b)//sss
{
//vec4 shadow_info =   texture2D(shadowcolor1,projectedShadowPosition.xy);
//float occluder_has_sss = shadow_info.b>=64.5/255.0? 1.0 : 0.0;
//float occluder_has_sss = texture2D(shadowcolor1,sh.xy).b >=64.5/255.0? 1.0 : 0.0;
#if FIX_SSS_LIGHT_LEAK == 1
float sss_here = texture2D(shadowcolor1,sh.xy).b >=64.5/255.0? 1.0 : 0.0;;//occluder_has_sss;//1.0;//texture2D(colortex13,sh.xy).b >=64.5/255.0 ? 1:0;
#else
float sss_here = 1.0;//
#endif
//return 1-fract((sh.z+1-1)*255-255*(texture2D(shadowtex1,sh.xy).x));
return sss_here > 0.01 ? clamp(1-SSS_DECAY_RATE * clamp((sh.z+1-1)*256-256*(texture2D(shadowtex1,sh.xy).x),0.0,1.0),0.0,1.0) :  clamp(1-9 * clamp((sh.z+1-1)*256-256*(texture2D(shadowtex1,sh.xy).x),0.0,1.0),0.0,1.0);;
return 1-clamp((sh.z+1-1)*8*shadowDistance-8*shadowDistance*(texture2D(shadowtex1,sh.xy).x),0.0,1.0);
// return 1-fract((sh.z+1)*8*shadowDistance-8*shadowDistance*(texture2D(shadowtex1,sh.xy).x));
// return 1-clamp((sh.z)+1-(texture2D(shadowtex1,sh.xy).x),0.0,1.0);
	//return clamp(mix(shadow2D(shadow,sh.xyz).x, shadow2D(shadow,sh.xyz+vec3(0.0,0.0,-0.1)).x,1), 0.0,1.0);
}
float shadow_for_pom(in vec3 sh,in float pd)
{

//return 1-fract((sh.z+1-1)*255-255*(texture2D(shadowtex1,sh.xy).x));
return pd >= 0.01? (((sh.z)>(texture2D(shadowtex1,sh.xy).x)))?0.0:1.0 : 1.0- clamp( ((9 *256*((sh.z+1-1)-(texture2D(shadowtex1,sh.xy).x))) )  ,0.0,1.0);//> pd? 1.0:0.0 
return 1-clamp((sh.z+1-1)*8*shadowDistance-8*shadowDistance*(texture2D(shadowtex1,sh.xy).x),0.0,1.0);
// return 1-fract((sh.z+1)*8*shadowDistance-8*shadowDistance*(texture2D(shadowtex1,sh.xy).x));
// return 1-clamp((sh.z)+1-(texture2D(shadowtex1,sh.xy).x),0.0,1.0);
	//return clamp(mix(shadow2D(shadow,sh.xyz).x, shadow2D(shadow,sh.xyz+vec3(0.0,0.0,-0.1)).x,1), 0.0,1.0);
}


#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toScreenSpace(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}
vec3 toScreenSpacePrev(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}

#include "lib/res_params.glsl"
#include "lib/waterOptions.glsl"

#include "lib/color_transforms.glsl"
#include "lib/sky_gradient.glsl"
#include "lib/stars.glsl"
#include "lib/volumetricClouds.glsl"

vec3 normVec (vec3 vec){
	return vec*inversesqrt(dot(vec,vec));
}
float lengthVec (vec3 vec){
	return sqrt(dot(vec,vec));
}
#define fsign(a)  (clamp((a)*1e35,0.,1.)*2.-1.)
float triangularize(float dither)
{
    float center = dither*2.0-1.0;
    dither = center*inversesqrt(abs(center));
    return clamp(dither-fsign(center),0.0,1.0);
}
float interleaved_gradientNoise(float temp){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y)+temp);
}
vec3 fp10Dither(vec3 color,float dither){
	const vec3 mantissaBits = vec3(6.,6.,5.);
	vec3 exponent = floor(log2(color));
	return color + dither*exp2(-mantissaBits)*exp2(exponent);
}



float facos(float sx){
    float x = clamp(abs( sx ),0.,1.);
    return sqrt( 1. - x ) * ( -0.16882 * x + 1.56734 );
}
vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}

vec2 decodeVec2(float a){
    const vec2 constant1 = 65535. / vec2( 256., 65536.);
    const float constant2 = 256. / 255.;
    return fract( a * constant1 ) * constant2 ;
}
float linZ(float depth) {
    return (2.0 * near1) / (far1 + near1 - depth * (far1 - near1));
	// l = (2*n)/(f+n-d(f-n))
	// f+n-d(f-n) = 2n/l
	// -d(f-n) = ((2n/l)-f-n)
	// d = -((2n/l)-f-n)/(f-n)

}
float invLinZ (float lindepth){
	return -((2.0*near1/lindepth)-far1-near1)/(far1-near1);
}

vec3 toClipSpace3(vec3 viewSpacePosition) {
    return projMAD(gbufferProjection, viewSpacePosition) / -viewSpacePosition.z * 0.5 + 0.5;
}

float rayTraceShadow(vec3 dir,vec3 position,float dither){

    const float quality = 16.;
    vec3 clipPosition = toClipSpace3(position);
	//prevents the ray from going behind the camera
	float rayLength = ((position.z + dir.z * far1*sqrt(3.)) > -near1) ?
       (-near1 -position.z) / dir.z : far1*sqrt(3.);
    vec3 direction = toClipSpace3(position+dir*rayLength)-clipPosition;  //convert to clip space
    direction.xyz = direction.xyz/max(abs(direction.x)/texelSize.x,abs(direction.y)/texelSize.y);	//fixed step size




    vec3 stepv = direction *3. * clamp(MC_RENDER_QUALITY,1.,2.0)*vec3(RENDER_SCALE,1.0);

	vec3 spos = clipPosition*vec3(RENDER_SCALE,1.0)+vec3(TAA_Offset*vec2(texelSize.x,texelSize.y)*0.5,0.0)+stepv*dither;





	for (int i = 0; i < int(quality); i++) {
		spos += stepv;

		float sp = texture2D(depthtex1,spos.xy).x;
        if( sp < spos.z) {

			float dist = abs(linZ(sp)-linZ(spos.z))/linZ(spos.z);

			if (dist < 0.01 ) return 0.0;



	}

	}
    return 1.0;
}



float ld(float dist) {
    return (2.0 * near1) / (far1 + near1 - dist * (far1 - near1));
}


vec2 tapLocation(int sampleNumber,int nb, float nbRot,float jitter,float distort)
{
		float alpha0 = sampleNumber/nb;
    float alpha = (sampleNumber+jitter)/nb;
    float angle = jitter*6.28 + alpha * 84.0 * 6.28;

    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);

    return vec2(cos_v, sin_v)*sqrt(alpha);
}



vec3 BilateralFiltering(sampler2D tex, sampler2D depth,vec2 coord,float frDepth,float maxZ){
  vec4 sampled = vec4(texelFetch2D(tex,ivec2(coord),0).rgb,1.0);

  return vec3(sampled.x,sampled.yz/sampled.w);
}
float blueNoise(){
  return fract(texelFetch2D(noisetex, ivec2(gl_FragCoord.xy)%512, 0).a + 1.0/1.6180339887 * frameCounter);
}
vec4 blueNoise(vec2 coord){
  return texelFetch2D(colortex6, ivec2(coord)%512, 0);
}
float R2_dither(){
	vec2 alpha = vec2(0.75487765, 0.56984026);
	return fract(alpha.x * gl_FragCoord.x + alpha.y * gl_FragCoord.y + 1.0/1.6180339887 * frameCounter);
}
vec3 toShadowSpaceProjected(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    p3 = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
    p3 = diagonal3(shadowProjection) * p3 + shadowProjection[3].xyz;

    return p3;
}

float waterCaustics(vec3 wPos, vec3 lightSource){
	vec2 pos = (wPos.xz - lightSource.xz/lightSource.y*wPos.y)*4.0 ;
	vec2 movement = vec2(-0.02*frameTimeCounter);
	float caustic = 0.0;
	float weightSum = 0.0;
	float radiance =  2.39996;
	mat2 rotationMatrix  = mat2(vec2(cos(radiance),  -sin(radiance)),  vec2(sin(radiance),  cos(radiance)));
	vec2 displ = texture2D(noisetex, pos*vec2(3.0,1.0)/96. + movement).bb*2.0-1.0;
	pos = pos/2.+vec2(1.74*frameTimeCounter) ;
	for (int i = 0; i < 3; i++){
		pos = rotationMatrix * pos;
		caustic += pow(0.5+sin(dot(pos * exp2(0.8*i)+ displ*3.1415,vec2(0.5)))*0.5,6.0)*exp2(-0.8*i)/1.41;
		weightSum += exp2(-0.8*i);
	}
	return caustic * weightSum;
}

void waterVolumetrics(inout vec3 inColor, vec3 rayStart, vec3 rayEnd, float estEndDepth, float estSunDepth, float rayLength, float dither, vec3 waterCoefs, vec3 scatterCoef, vec3 ambient, vec3 lightSource, float VdotL){
		inColor *= exp(-rayLength * waterCoefs);	//No need to take the integrated value
		int spCount = rayMarchSampleCount;
		vec3 start = toShadowSpaceProjected(rayStart);
		vec3 end = toShadowSpaceProjected(rayEnd);
		vec3 dV = (end-start);
		//limit ray length at 32 blocks for performance and reducing integration error
		//you can't see above this anyway
		float maxZ = min(rayLength,32.0)/(1e-8+rayLength);
		dV *= maxZ;
		vec3 dVWorld = -mat3(gbufferModelViewInverse) * (rayEnd - rayStart) * maxZ;
		rayLength *= maxZ;
		estEndDepth *= maxZ;
		estSunDepth *= maxZ;
		vec3 absorbance = vec3(1.0);
		vec3 vL = vec3(0.0);
		float phase = phaseg(VdotL, Dirt_Mie_Phase);
		float expFactor = 11.0;
		vec3 progressW = gbufferModelViewInverse[3].xyz+cameraPosition;
		for (int i=0;i<spCount;i++) {
			float d = (pow(expFactor, float(i+dither)/float(spCount))/expFactor - 1.0/expFactor)/(1-1.0/expFactor);
			float dd = pow(expFactor, float(i+dither)/float(spCount)) * log(expFactor) / float(spCount)/(expFactor-1.0);
			vec3 spPos = start.xyz + dV*d;
			progressW = gbufferModelViewInverse[3].xyz+cameraPosition + d*dVWorld;
			//project into biased shadowmap space
			float distortFactor = calcDistort(spPos.xy);
			vec3 pos = vec3(spPos.xy*distortFactor, spPos.z);
			float sh = 1.0;
			if (abs(pos.x) < 1.0-0.5/2048. && abs(pos.y) < 1.0-0.5/2048){
				pos = pos*vec3(0.5,0.5,0.5/6.0)+0.5;
				sh =  shadow2D( shadow, pos,sh).x;
				//insun2=shadow2(pos,sh);
			}
			vec3 ambientMul = exp(-estEndDepth * d * waterCoefs * 1.1);
			vec3 sunMul = exp(-estSunDepth * d * waterCoefs);
			vec3 light = (sh * lightSource*8./150./3.0 * phase * sunMul + ambientMul * ambient)*scatterCoef;
			vL += (light - light * exp(-waterCoefs * dd * rayLength)) / waterCoefs *absorbance;
			absorbance *= exp(-dd * rayLength * waterCoefs);
		}
		inColor += vL;
}

vec3 RT(vec3 dir,vec3 position,float noise, vec3 N){
	float stepSize = STEP_LENGTH;
	int maxSteps = STEPS;
	vec3 clipPosition = toClipSpace3(position);
	float rayLength = ((position.z + dir.z * sqrt(3.0)*far1) > -sqrt(3.0)*near1) ?
	   								(-sqrt(3.0)*near1 -position.z) / dir.z : sqrt(3.0)*far1;
	vec3 end = toClipSpace3(position+dir*rayLength);
	vec3 direction = end-clipPosition;  //convert to clip space
	float len = max(abs(direction.x)/texelSize.x,abs(direction.y)/texelSize.y)/stepSize;
	//get at which length the ray intersects with the edge of the screen
	vec3 maxLengths = (step(0.,direction)-clipPosition) / direction;
	float mult = min(min(maxLengths.x,maxLengths.y),maxLengths.z);
	vec3 stepv = direction/len;
	int iterations = min(int(min(len, mult*len)-2), maxSteps);
	//Do one iteration for closest texel (good contact shadows)
	vec3 spos = clipPosition*vec3(RENDER_SCALE,1.0) + stepv/stepSize*6.0;
	spos.xy += TAA_Offset*texelSize*0.5*RENDER_SCALE;
	float sp = sqrt(texelFetch2D(colortex4,ivec2(spos.xy/texelSize/4),0).w/65000.0);
	float currZ = linZ(spos.z);
	if( sp < currZ) {
		float dist = abs(sp-currZ)/currZ;
		if (dist <= 0.035) return vec3(spos.xy, invLinZ(sp))/vec3(RENDER_SCALE,1.0);
	}
	stepv *= vec3(RENDER_SCALE,1.0);
	spos += stepv*noise;
  for(int i = 0; i < iterations; i++){
		float sp = sqrt(texelFetch2D(colortex4,ivec2(spos.xy/texelSize/4),0).w/65000.0);
		float currZ = linZ(spos.z);
		if( sp < currZ) {
			float dist = abs(sp-currZ)/currZ;
			if (dist <= 0.035) return vec3(spos.xy, invLinZ(sp))/vec3(RENDER_SCALE,1.0);
		}
			spos += stepv;
	}
	return vec3(1.1);
}
vec2 R2_samples(int n){
	vec2 alpha = vec2(0.75487765, 0.56984026);
	return fract(alpha * n);
}

vec3 cosineHemisphereSample(vec2 Xi)
{
    float r = sqrt(Xi.x);
    float theta = 2.0 * 3.14159265359 * Xi.y;

    float x = r * cos(theta);
    float y = r * sin(theta);

    return vec3(x, y, sqrt(clamp(1.0 - Xi.x,0.,1.)));
}
vec3 TangentToWorld(vec3 N, vec3 H)
{
    vec3 UpVector = abs(N.z) < 0.999 ? vec3(0.0, 0.0, 1.0) : vec3(1.0, 0.0, 0.0);
    vec3 T = normalize(cross(UpVector, N));
    vec3 B = cross(N, T);

    return vec3((T * H.x) + (B * H.y) + (N * H.z));
}
vec3 rtGI(vec3 normal,vec4 noise,vec3 fragpos, vec3 ambient, float translucent, vec3 torch, vec3 albedo){
	int nrays = RAY_COUNT;
	vec3 intRadiance = vec3(0.0);
	float occlusion = 0.0;
	float accLight = 0.0;
	for (int i = 0; i < nrays; i++){
		int seed = (frameCounter%40000)*nrays+i;
		vec2 ij = fract(R2_samples(seed) + noise.rg);
		vec3 rayDir = normalize(cosineHemisphereSample(ij));
		rayDir = TangentToWorld(normal,rayDir);
		vec3 rayHit = RT(mat3(gbufferModelView)*rayDir, fragpos, fract(seed/1.6180339887 + noise.b), mat3(gbufferModelView)*normal);
		if (rayHit.z < 1.){
			vec3 previousPosition = mat3(gbufferModelViewInverse) * toScreenSpace(rayHit) + gbufferModelViewInverse[3].xyz + cameraPosition-previousCameraPosition;
			previousPosition = mat3(gbufferPreviousModelView) * previousPosition + gbufferPreviousModelView[3].xyz;
			previousPosition.xy = projMAD(gbufferPreviousProjection, previousPosition).xy / -previousPosition.z * 0.5 + 0.5;
			if (previousPosition.x > 0.0 && previousPosition.y > 0.0 && previousPosition.x < 1.0 && previousPosition.x < 1.0)
				intRadiance += texture2D(colortex5,previousPosition.xy).rgb + ambient*albedo*translucent;
			else
				intRadiance += ambient + ambient*translucent*albedo;
			occlusion += 1.0;
		}
		else {
		//	float bounceAmount = float(rayDir.y > 0.0) + clamp(-rayDir.y*0.1+0.1, 0.0,1.0);
			//vec3 sky_c = skyCloudsFromTex(rayDir,colortex4).rgb * bounceAmount;
			intRadiance += ambient;
		}
	}
	return intRadiance/nrays + (1.0-occlusion/nrays)*torch;
}

vec2 tapLocation(int sampleNumber, float spinAngle,int nb, float nbRot,float r0)
{
    float alpha = (float(sampleNumber*1.0f + r0) * (1.0 / (nb)));
    float angle = alpha * (nbRot * 6.28) + spinAngle*6.28;

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);

    return vec2(cos_v, sin_v)*ssR;
}

void ssao(inout float occlusion,vec3 fragpos,float mulfov,float dither,vec3 normal)
{
	ivec2 pos = ivec2(gl_FragCoord.xy);
	const float tan70 = tan(70.*3.14/180.);
	float mulfov2 = gbufferProjection[1][1]/tan70;

	const float PI = 3.14159265;
	const float samplingRadius = 0.712;
	float angle_thresh = 0.05;
	float maxR2 = fragpos.z*fragpos.z*mulfov2*2.*1.412/50.0;



	float rd = mulfov2*0.04;
	//pre-rotate direction
	float n = 0.;

	occlusion = 0.0;

	vec2 acc = -vec2(TAA_Offset)*texelSize*0.5;
	float mult = (dot(normal,normalize(fragpos))+1.0)*0.5+0.5;

	vec2 v = fract(vec2(dither,R2_dither()) + (frameCounter%10000) * vec2(0.75487765, 0.56984026));
	for (int j = 0; j < 7 ;j++) {

			vec2 sp = tapLocation(j,v.x,7,88.,v.y);
			vec2 sampleOffset = sp*rd;
			ivec2 offset = ivec2(gl_FragCoord.xy + sampleOffset*vec2(viewWidth,viewHeight*aspectRatio)*RENDER_SCALE);
			if (offset.x >= 0 && offset.y >= 0 && offset.x < viewWidth*RENDER_SCALE.x && offset.y < viewHeight*RENDER_SCALE.y ) {
				vec3 t0 = toScreenSpace(vec3(offset*texelSize+acc+0.5*texelSize,texelFetch2D(depthtex1,offset,0).x) * vec3(1.0/RENDER_SCALE, 1.0));

				vec3 vec = t0.xyz - fragpos;
				float dsquared = dot(vec,vec);
				if (dsquared > 1e-5){
					if (dsquared < maxR2){
						float NdotV = clamp(dot(vec*inversesqrt(dsquared), normalize(normal)),0.,1.);
						occlusion += NdotV * clamp(1.0-dsquared/maxR2,0.0,1.0);
					}
					n += 1.0;
				}
			}
		}



		occlusion = clamp(1.0-occlusion/n*1.6,0.,1.0);
		//occlusion = mult;

}

#if PBR_QUALITY_CPF == 4

#endif

vec4 get_ambient_cpf(in vec2 lightmapa,in vec3 custom_lightmapa)
{
return   vec4(0.005* textureLod(colortex4,vec2(.25*CLOUDS_QUALITY,.6*CLOUDS_QUALITY),0).rgb , lightmapa.y);//texcoord
			//combine all light sources
			//	gl_FragData[0].rgb =	albedo*shading + get_ambient_cpf(lightmapa,custom_lightmap);
			vec3 skylight= vec3(0.5);
			skylight.b=1.0;
			return vec4(custom_lightmapa.rgb, lightmapa.y);
			//return vec4(0.5);
}

void main() {
vec2 texcoord = gl_FragCoord.xy*texelSize;
vec3 ambient_torch = vec3(0.0);

bool doing_pbr ;//=  > 0.01);
bool is_hand_held;//
#define HANDD 1
{
float aa = texture2D(colortex14,texcoord).a;
 doing_pbr = aa > 0.0;
 is_hand_held = aa > 0.04 && aa <.6;
}

vec3 color_0_out;
float debugvalue;
vec3 debugvalue3;
	
	tangent =   textureLod(colortex11,texcoord.xy,0);
	
	
	float dirtAmount = Dirt_Amount;
	vec3 waterEpsilon = vec3(Water_Absorb_R, Water_Absorb_G, Water_Absorb_B);
	vec3 dirtEpsilon = vec3(Dirt_Absorb_R, Dirt_Absorb_G, Dirt_Absorb_B);
	vec3 totEpsilon = dirtEpsilon*dirtAmount + waterEpsilon;
	vec3 scatterCoef = dirtAmount * vec3(Dirt_Scatter_R, Dirt_Scatter_G, Dirt_Scatter_B);
	float z0 = texture2D(depthtex0,texcoord).x;
	float z = texture2D(depthtex1,texcoord).x;
	vec2 tempOffset=TAA_Offset;
	float noise = blueNoise();

	vec3 fragpos = toScreenSpace(vec3(texcoord/RENDER_SCALE-vec2(tempOffset)*texelSize*0.5,z));
	vec3 p3 = mat3(gbufferModelViewInverse) * fragpos;
	vec3 np3 = normVec(p3);

vec3 fog_color ;
float border_fog;
{
#if BORDER_FOG != 100
gl_FragData[1]= textureLod(colortex15,texcoord.xy,0).rgba;
				#else
				 			
				#define DH_FOG .8 //[0. .1 .2 .3 .4 .5 .6 .7 .75 .77 .8 .82 .85 .9]
				
			#if defined IS_IRIS && defined DISTANT_HORIZONS
					float BORDER_FOG2 = 10.;//BORDER_FOG* 10./3./
					 float border_fog= (clamp((  	max(-texture2D(colortex15,texcoord.xy).w,
					
				
					  min(
					  max(0.,linearize_depth_cpf(texture2D(depthtex1,texcoord).r)),
					  
					 1111.
					 )
					 
					 )   -far1*(1.-BORDER_FOG*.1))/(dhfar1Plane*(1.-DH_FOG)),0.,1.));
	
		
		border_fog = pow(border_fog,1. - DH_FOG);
				 #else
				float border_fog  = textureLod(depthtex0,texcoord.xy,0).x;
				// from gl_FragCoord.z to world measurements
				border_fog = 2.0 * near  * far / (far + near - (2.0 * border_fog - 1.0) * (far - near));
				
				border_fog=clamp(2*border_fog/far,0.0,2.0);
				float curve = distance(texcoord.xy-.5,vec2(0.0));
				border_fog=border_fog+.5*curve;
				//border_fog=border_fog>1.5?0.:border_fog;
				
				
				
				border_fog=clamp((border_fog-(1.-BORDER_FOG*.1))/(BORDER_FOG*.1),0.0,1.0);//
					#endif
				
				
				
				border_fog=clamp(border_fog,0.,1.);
		//if(border_fog > 0.0)
	
		{
		vec3 color = vec3(0.0);
		vec3 color2 = vec3(0.0);
		vec4 cloud = texture2D_bicubic(colortex0,texcoord*CLOUDS_QUALITY);
		if (np3.y > 0.){
			color2 += stars(np3);
			color2 += drawSun(dot(lightCol.a*WsunVec,np3),0, lightCol.rgb/150.,vec3(0.0));
		}
		color=  color + skyFromTex(np3,colortex4)/150. ;//+ toLinear(texture2D(colortex1,texcoord).rgb)/10.*4.0*ffstep(0.985,-dot(lightCol.a*WsunVec,np3)) ;
		color2+=color;
		
		color2 = color2*cloud.a+cloud.rgb;
		color2 = clamp(fp10Dither(color2*8./3.,triangularize(noise)),0.0,65000.);
		//if (gl_FragData[0].r > 65000.) 	gl_FragData[0].rgb = vec3(0.0);
		vec4 trpData = texture2D(colortex7,texcoord);
		bool iswater = texture2D(colortex7,texcoord).a > 0.99;
		if (false&&iswater){
			vec3 fragpos0 = toScreenSpace(vec3(texcoord/RENDER_SCALE-vec2(tempOffset)*texelSize*0.5,z0));
			float Vdiff = distance(fragpos,fragpos0);
			float VdotU = np3.y;
			float estimatedDepth = Vdiff * abs(VdotU);	//assuming water plane
			float estimatedSunDepth = estimatedDepth/abs(refractedSunVec.y); //assuming water plane

			vec3 lightColVol = lightCol.rgb * (1.0-pow(1.0-WsunVec.y,5.0));	//fresnel
			vec3 ambientColVol = ambientUp*8./150./3.*0.5 * eyeBrightnessSmooth.y / 240.0;
			if (isEyeInWater == 0)
				waterVolumetrics(color2, fragpos0, fragpos, estimatedDepth, estimatedSunDepth, Vdiff, noise, totEpsilon, scatterCoef, ambientColVol, lightColVol, dot(np3, WsunVec));
		}
		color = vec4(1.,0.,0.,1.);//
		//mix(color,color2,0);
		fog_color=color*1000.;
		gl_FragData[1]=vec4(fog_color.rgb,1.0);
		
	}
	
	
	//color_0_out.rgb = mix(color_0_out.rgb,fog_color ,border_fog);
				#endif
}

vec3 estimatedDepth2 = vec3(1.0);
vec4 estimatedDepth3 = vec4(1.0);

	//sky
	//if (z >=1.0  ) {
	float dddd = -textureLod(colortex15,texcoord.xy,0).z;
	if(dddd > far1*4333.9|| dddd <=0.){
	    gl_FragData[1]= textureLod(colortex15,texcoord.xy,0).rgba;
		#define HIDECLOUDSINREFLC 1
		#if HIDECLOUDSINREFLC == 1
		 gl_FragData[1].z=-far1;
		 #endif
		vec3 color = vec3(0.0);
		vec4 cloud = texture2D_bicubic(colortex0,texcoord*CLOUDS_QUALITY);
		if (np3.y > 0.){
			color += stars(np3);
			color += drawSun(dot(lightCol.a*WsunVec,np3),0, lightCol.rgb/150.,vec3(0.0));
		}
		color += skyFromTex(np3,colortex4)/150. + toLinear(texture2D(colortex1,texcoord).rgb)/10.*4.0*ffstep(0.985,-dot(lightCol.a*WsunVec,np3));
		color = color*cloud.a+cloud.rgb;
		gl_FragData[0].rgb = clamp(fp10Dither(color*8./3.,triangularize(noise)),0.0,65000.);
		//if (gl_FragData[0].r > 65000.) 	gl_FragData[0].rgb = vec3(0.0);
		vec4 trpData = texture2D(colortex7,texcoord);
		bool iswater = texture2D(colortex7,texcoord).a > 0.99;
		if (iswater){
			vec3 fragpos0 = toScreenSpace(vec3(texcoord/RENDER_SCALE-vec2(tempOffset)*texelSize*0.5,z0));
			float Vdiff = distance(fragpos,fragpos0);
			float VdotU = np3.y;
			float estimatedDepth = Vdiff * abs(VdotU);	//assuming water plane
			float estimatedSunDepth = estimatedDepth/abs(refractedSunVec.y); //assuming water plane

			vec3 lightColVol = lightCol.rgb * (1.0-pow(1.0-WsunVec.y,5.0));	//fresnel
			vec3 ambientColVol = ambientUp*8./150./3.*0.5 * eyeBrightnessSmooth.y / 240.0;
			if (isEyeInWater == 0)
				waterVolumetrics(gl_FragData[0].rgb, fragpos0, fragpos, estimatedDepth, estimatedSunDepth, Vdiff, noise, totEpsilon, scatterCoef, ambientColVol, lightColVol, dot(np3, WsunVec));
		}
	}
	//land
	else {
	
		p3 += gbufferModelViewInverse[3].xyz;

		vec4 trpData = texture2D(colortex7,texcoord);
		bool iswater = texture2D(colortex7,texcoord).a > 0.99;

		vec4 data = texture2D(colortex1,texcoord);
		vec4 dataUnpacked0 = vec4(decodeVec2(data.x),decodeVec2(data.y));
		vec4 dataUnpacked1 = vec4(decodeVec2(data.z),decodeVec2(data.w));

		vec3 albedo = toLinear(vec3(dataUnpacked0.xz,dataUnpacked1.x));
		//if (luma(albedo) < 0.15) albedo = vec3(1.0,0.,0.);
		vec3 normal = mat3(gbufferModelViewInverse) * decode(dataUnpacked0.yw);




	vec3 fragpos0 = toScreenSpace(vec3(texcoord/RENDER_SCALE-vec2(tempOffset)*texelSize*0.5,z0));
				vec3 projectedShadowPosition = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
			projectedShadowPosition = diagonal3(shadowProjection) * projectedShadowPosition + shadowProjection[3].xyz;
			//apply distortion
			float distortFactor = calcDistort(projectedShadowPosition.xy);
			projectedShadowPosition.xy *= distortFactor;
			projectedShadowPosition=projectedShadowPosition* vec3(0.5,0.5,0.5/6.0) + vec3(0.5,0.5,0.5);
			vec4 shadow_info = vec4(0.0);
			//do shadows only if on shadow map
			if (abs(projectedShadowPosition.x) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.y) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.z) < 6.0)
			{
			shadow_info =   texture2D(shadowcolor1,projectedShadowPosition.xy);
			}
			
		//	float fnormworld = texture2D(colortex11,texcoord.xy).a;
	float o2 =texture2D(colortex11,texcoord.xy).a;;///.5+.5*dot(fnormworld,normalize(upPosition));// texture2D( shadowcolor1, toShadowSpaceProjected(fragpos0).xy);//toShadowSpaceProjected(fragpos).xy);//texcoord);//tangent.a;
	float pom_depth =  abs(shadow_info.a-o2)>LIGHT_LEAK_ANGLE_LIMIT?1:0;
	pom_depth = texture2D(colortex14,texcoord).a == 0.0? 0:pom_depth; //do pbr flag == 0
			
	//float occluder_has_sss = shadow_info.b>=64.5/255.0? 1.0 : 0.0;
    //debugvalue3=vec3(o2,shadow_info.a,pom_depth);//shadow_info.aaa;
	
	
		vec2 lightmap = dataUnpacked1.yz;
		vec4 relative_position2 = textureLod(colortex15,texcoord.xy,0);
		#if HAND_HELD_TORCH > 0 
		float torch_hand_light = heldBlockLightValue > 0 || heldBlockLightValue2 > 0 ? TORCH_BRIGHTNESS*clamp( 1.-distance( vec3(0.),relative_position2.xyz )/ HAND_HELD_TORCH_RANGE ,0.,1.)
		 
		#if TORCH_LIGHT_3D == 1
		*
		(
		(heldBlockLightValue>0?1.:0.) * clamp(dot(decode(dataUnpacked0.yw),normalize(vec3(0.5,-.5,1.))),0.0,1.) 
		+
		(heldBlockLightValue2>0?1.:0.) * clamp(dot(decode(dataUnpacked0.yw),normalize(vec3(-0.5,-.5,1.))),0.0,1.)
		)
		#endif
		#if TORCH_LIGHT_3D == 2
		*
		(
		(heldBlockLightValue>0?1.:0.) * clamp(dot(decode(dataUnpacked0.yw),normalize(-relative_position2.xyz-vec3(-TORCH_HORIZONTAL_OFFSET,-TORCH_V_OFFSET,0.))),0.0,1.) 
		+
		(heldBlockLightValue2>0?1.:0.) * clamp(dot(decode(dataUnpacked0.yw),normalize(-relative_position2.xyz-vec3(TORCH_HORIZONTAL_OFFSET,-TORCH_V_OFFSET,0.))),0.0,1.)
		)
		#endif
		: 0.0;
		#else
		float torch_hand_light = 0.;
		#endif

		bool translucent = abs(dataUnpacked1.w-0.5) <0.01;	// Strong translucency
		bool translucent2 = abs(dataUnpacked1.w-0.6) <0.01;	// Weak translucency
		bool hand = abs(dataUnpacked1.w-0.75) <0.01;
		bool emissive = abs(dataUnpacked1.w-0.9) <0.01;
		float NdotLGeom = dot(normal,WsunVec);
		float NdotL = NdotLGeom;
		if ((iswater && isEyeInWater == 0) || (!iswater && isEyeInWater ==1))
			NdotL = dot(normal,refractedSunVec);

		float diffuseSun = clamp(NdotL,0.,1.0);
		vec3 filtered = vec3(1.412,1.0,0.0);
		if (!hand){
			filtered = texture2D(colortex3,texcoord).rgb;
		}
		float shading = 1.0 - filtered.b;
		float pShadow = filtered.b*2.0-1.0;

		vec3 SSS = vec3(0.0);
		float sssAmount = 0.0;
		#ifdef Variable_Penumbra_Shadows
		// compute shadows only if not backfacing the sun
		// or if the blocker search was full or empty
		// always compute all shadows at close range where artifacts may be more visible
		if (diffuseSun > 0.001) {
		#else
		if (translucent) {
			sssAmount = 0.5;
			diffuseSun = mix(max(phaseg(dot(np3, WsunVec),0.5), 2.0*phaseg(dot(np3, WsunVec),0.1))*3.14150*1.6, diffuseSun, 0.3);
		}
		if (diffuseSun > 0.000) 
		{
		#endif
			vec3 projectedShadowPosition = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
			projectedShadowPosition = diagonal3(shadowProjection) * projectedShadowPosition + shadowProjection[3].xyz;
			//apply distortion
			float distortFactor = calcDistort(projectedShadowPosition.xy);
			projectedShadowPosition.xy *= distortFactor;
			//do shadows only if on shadow map
			if (abs(projectedShadowPosition.x) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.y) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.z) < 6.0){
				float rdMul = filtered.x*distortFactor*d0*k/shadowMapResolution;
				const float threshMul = max(2048.0/shadowMapResolution*shadowDistance/128.0,0.95);
				float distortThresh = (sqrt(1.0-NdotLGeom*NdotLGeom)/NdotLGeom+0.7)/distortFactor;
				#ifdef Variable_Penumbra_Shadows
				float diffthresh = distortThresh/6000.0*threshMul;
				#else
				float diffthresh = translucent? 0.0001 : distortThresh/6000.0*threshMul;
				//float diffthresh =  distortThresh/6000.0*threshMul;
				#endif
				#ifdef POM
				#ifdef Depth_Write_POM
					diffthresh += POM_DEPTH/128./4./6.0;
				#endif
				#endif
				projectedShadowPosition = projectedShadowPosition * vec3(0.5,0.5,0.5/6.0) + vec3(0.5,0.5,0.5);
				shading = 0.0;
				
				for(int i = 0; i < SHADOW_FILTER_SAMPLE_COUNT; i++){
					vec2 offsetS = tapLocation(i,SHADOW_FILTER_SAMPLE_COUNT, 0.0,noise,0.0);

					float weight = 1.0+(i+noise)*rdMul/SHADOW_FILTER_SAMPLE_COUNT*shadowMapResolution;
					//float isShadow = shadow2D(shadow,vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight))).x;
					float isShadow = shadow_for_pom(vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight)),pom_depth);
					//insun2 += shadow2(vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight)),isShadow);//sh = textureLod(shadow,pos,0).x-pos.z;
					shading += isShadow/SHADOW_FILTER_SAMPLE_COUNT;
				}
			}
		}
		{
			vec3 projectedShadowPosition = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
			projectedShadowPosition = diagonal3(shadowProjection) * projectedShadowPosition + shadowProjection[3].xyz;
			//apply distortion
			float distortFactor = calcDistort(projectedShadowPosition.xy);
			projectedShadowPosition.xy *= distortFactor;
			//do shadows only if on shadow map
			if (abs(projectedShadowPosition.x) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.y) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.z) < 6.0){
				float rdMul = filtered.x*distortFactor*d0*k/shadowMapResolution;
				const float threshMul = max(2048.0/shadowMapResolution*shadowDistance/128.0,0.95);
				float distortThresh = (sqrt(1.0-NdotLGeom*NdotLGeom)/NdotLGeom+0.7)/distortFactor;
				#ifdef Variable_Penumbra_Shadows
				float diffthresh = distortThresh/6000.0*threshMul;
				#else
				float diffthresh = translucent? 0.0001 : distortThresh/6000.0*threshMul;
				//float diffthresh = distortThresh/6000.0*threshMul;
				#endif
				#ifdef POM
				#ifdef Depth_Write_POM
					diffthresh += POM_DEPTH/128./4./6.0;
				#endif
				#endif
				projectedShadowPosition = projectedShadowPosition * vec3(0.5,0.5,0.5/6.0) + vec3(0.5,0.5,0.5);
				//shading = 0.0;
				insun2=0.0;
				float sundepth = 1-shadow2(vec3(projectedShadowPosition),insun2);
				//debugvalue=1-sundepth;
				 int sssblur = int((1+clamp(5*  1*(sundepth),0,5)));//sh = 
				 sundepth=clamp(sundepth,0.0,4.0);
				for(int i = 0; i < sssblur; i++){
					vec2 offsetS = SSS_SCATTER_WIDTH  *sundepth*tapLocation(i,1, 0.0,noise,0.0);

					float weight = 1.0+(i+noise)*rdMul/sssblur*shadowMapResolution;
					//float isShadow = shadow2D(shadow,vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight))).x;
					insun2 += shadow2(vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight)),insun2)/sssblur;//sh = textureLod(shadow,pos,0).x-pos.z;
					//shading += isShadow/1;
				}
				//debugvalue=insun2;
				//shading = 0.0;
				//insun2=0.0;
			   /*
				for(int i = 0; i < sssblur; i++){
					vec2 offsetS = tapLocation(i,sssblur, 0.0,noise,0.0);

					float weight = 1.0+(i+noise)*rdMul/sssblur*shadowMapResolution;
					//float isShadow = shadow2D(shadow,vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight))).x;
					insun2 += shadow2(vec3(projectedShadowPosition + vec3(rdMul*offsetS,-diffthresh*weight)),isShadow);//sh = textureLod(shadow,pos,0).x-pos.z;
					//shading += isShadow/sssblur;
				}
				*/
				
			}
		}

		//custom shading model for translucent objects
		#ifdef Variable_Penumbra_Shadows
		if (translucent) {
			sssAmount = 0.5;
			vec3 extinction = 1.0 - albedo*0.85;
			// Should be somewhat energy conserving
			SSS = exp(-filtered.y*11.0*extinction) + 3.0*exp(-filtered.y*11./3.*extinction);
			float scattering = clamp((0.7+0.3*pi*phaseg(dot(np3, WsunVec),0.85))*1.5/4.0*sssAmount,0.0,1.0);
			SSS *= scattering;
			shading *= 1.0 - sssAmount;
			SSS *= sqrt(lightmap.y);
		}

		if (translucent2) {
			sssAmount = 0.2;
			vec3 extinction = 1.0 - albedo*0.85;
			// Should be somewhat energy conserving
			SSS = exp(-filtered.y*11.0*extinction) + 3.0*exp(-filtered.y*11./3.*extinction);
			float scattering = clamp((0.7+0.3*pi*phaseg(dot(np3, WsunVec),0.85))*1.26/4.0*sssAmount,0.0,1.0);
			SSS *= scattering;
			shading *= 1.0 - sssAmount;
			SSS *= sqrt(lightmap.y);
		}
		#endif

		if (diffuseSun*shading > 0.001 ){
			#ifdef SCREENSPACE_CONTACT_SHADOWS
				vec3 vec = lightCol.a*sunVec;
				float screenShadow = rayTraceShadow(vec,fragpos,noise);
				shading = min(screenShadow, shading);
			#endif

		#ifdef CAVE_LIGHT_LEAK_FIX
			shading = mix(0.0, shading, clamp(eyeBrightnessSmooth.y/255.0 + lightmap.y,0.0,1.0));
		#endif
		}
		#ifdef CLOUDS_SHADOWS
			vec3 pos = p3 + cameraPosition;
			const int rayMarchSteps = 6;
			float cloudShadow = 0.0;
			for (int i = 0; i < rayMarchSteps; i++){
				vec3 cloudPos = pos + WsunVec/abs(WsunVec.y)*(1500+(noise+i)/rayMarchSteps*1700-pos.y);
				cloudShadow += getCloudDensity(cloudPos, 0);
			}
			cloudShadow = mix(1.0,exp(-cloudShadow*cloudDensity*1700/rayMarchSteps),mix(CLOUDS_SHADOWS_STRENGTH,1.0,rainStrength));
			shading *= cloudShadow;
			
			SSS *= cloudShadow;
		#endif



//vec4 relative_position2 = textureLod(colortex15,texcoord.xy,0); //moved back 6-24

#if defined IS_IRIS && defined DISTANT_HORIZONS && BUGGY_DH_SHADING != 2

	#define DH_FADE .3 //[0.0001 .1 .2 .3 .4 .5]// how far1 to fade close chunks into far1 chunks
		float ddddd = clamp(((distance(vec3(0.),relative_position2.xyz)/far1)-(1.-DH_FADE))*(1./DH_FADE),0.,1.);
#endif

#if defined IS_IRIS && defined DISTANT_HORIZONS && BUGGY_DH_SHADING == 2

#define DH_BLEND_MODE 2 //[0 1 2 3]// 0=none, 1-dither, 2-fade, 3-both
	#define DH_FADE .3 //[0.0001 .1 .2 .3 .4 .5]// how far1 to fade close chunks into far1 chunks
	#if DH_BLEND_MODE == 1 || DH_BLEND_MODE == 3
		float ddddd = clamp(((distance(vec3(0.),relative_position2.xyz)/far1)-(1.-DH_FADE))*(1./DH_FADE),0.,1.);
		if(ddddd > fract(sin(gl_FragCoord.x *10.0+gl_FragCoord.y+gl_FragCoord.z *31.0)))
		{
			shading=1.0;//debug
		}
	#else
	#if DH_BLEND_MODE == 0
		float ddddd = clamp(((distance(vec3(0.),relative_position2.xyz)/far1)-(1.-DH_FADE))*(1./DH_FADE),0.,1.);
		if(ddddd > 0.99)
		{
		
			shading = 1.;//mix(shading,1.,ddddd);
			//insun2 = mix(insun2);
			
		}
		#else
			float ddddd = clamp(((distance(vec3(0.),relative_position2.xyz)/far1)-(1.-DH_FADE))*(1./DH_FADE),0.,1.);
		//if(ddddd > 0.9)
		{
		
			shading = mix(shading,1.,ddddd);
			//insun2 = mix(insun2);
			
		}
		#endif
	#endif
#endif
		
		
		vec3 ambientCoefs = normal/dot(abs(normal),vec3(1.));
		vec3 ambientLight = ambientUp*mix(clamp(ambientCoefs.y,0.,1.), 1.0/6.0, sssAmount);
		ambientLight += ambientDown*mix(clamp(-ambientCoefs.y,0.,1.), 1.0/6.0, sssAmount);
		ambientLight += ambientRight*mix(clamp(ambientCoefs.x,0.,1.), 1.0/6.0, sssAmount);
		ambientLight += ambientLeft*mix(clamp(-ambientCoefs.x,0.,1.), 1.0/6.0, sssAmount);
		ambientLight += ambientB*mix(clamp(ambientCoefs.z,0.,1.), 1.0/6.0, sssAmount);
		ambientLight += ambientF*mix(clamp(-ambientCoefs.z,0.,1.), 1.0/6.0, sssAmount);

		vec3 directLightCol = lightCol.rgb;
		vec3 custom_lightmap = texture2D(colortex4,(lightmap*15.0+0.5+vec2(0.0,19.))*texelSize).rgb*8./150./3.;
		float emitting = 0.0;
		if (emissive || (hand && heldBlockLightValue > 0.1)){
			emitting = luma(albedo)*3.0*Emissive_Strength;
			custom_lightmap.y = 0.0;
		}
		if ((iswater && isEyeInWater == 0) || (!iswater && isEyeInWater ==1)){

			vec3 fragpos0 = toScreenSpace(vec3(texcoord/RENDER_SCALE-vec2(tempOffset)*texelSize*0.5,z0));
			float Vdiff = distance(fragpos,fragpos0);
			float VdotU = np3.y;
			float estimatedDepth = Vdiff * abs(VdotU);	//assuming water plane
			if (isEyeInWater == 1){
				Vdiff = length(fragpos);
				estimatedDepth =  clamp((15.5-lightmap.y*16.0)/15.5,0.,1.0);
				estimatedDepth *= estimatedDepth*estimatedDepth*32.0;
				#ifndef lightMapDepthEstimation
					estimatedDepth = max(Water_Top_Layer - (cameraPosition.y+p3.y),0.0);
				#endif
			}
			// k = 1-r*r*(1-sy*sy)
			float estimatedSunDepth = estimatedDepth/abs(refractedSunVec.y); //assuming water plane
			directLightCol *= exp(-totEpsilon*estimatedSunDepth)*(1.0-pow(1.0-WsunVec.y,5.0));
			float caustics = waterCaustics(mat3(gbufferModelViewInverse) * fragpos + gbufferModelViewInverse[3].xyz + cameraPosition, refractedSunVec);
			directLightCol *= mix(caustics*0.5+0.5,1.0,exp(-estimatedSunDepth/3.0));
			
			
			
//estimatedDepth2=clamp(vec3(0.99-estimatedDepth*0.3,1.0-estimatedDepth*0.05,1.0-estimatedDepth*0.01),0.0,1.0);//1.0-estimatedDepth*6.0;
			
			#if defined IS_IRIS && defined DISTANT_HORIZONS
			//&&(DH_BLEND_MODE == 2 || DH_BLEND_MODE == 3)
			#define BLEND_WATER 1.0 // [ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
				#define WATER_SKIN_B1 mix(WATER_SKIN_B,1.,ddddd*BLEND_WATER)
				#define WATER_SKIN_R1 mix(WATER_SKIN_B,0.2,ddddd*BLEND_WATER)
				#define WATER_SKIN_G1 mix(WATER_SKIN_B,0.2,ddddd*BLEND_WATER)
	estimatedDepth2=clamp(vec3(WATER_SKIN_R1-estimatedDepth*WATER_ABSORB_R,WATER_SKIN_G1-estimatedDepth*WATER_ABSORB_G,WATER_SKIN_B1-estimatedDepth*WATER_ABSORB_B),0.0,1.0);//1.0-estimatedDepth*6.0;
			//directLightCol*= estimatedDepth2;
			float distt = -textureLod(colortex15,texcoord.xy,0).b;
		estimatedDepth3 = max( vec4(estimatedDepth2,1.0-estimatedDepth*DIRTY_WATER), clamp(vec4(WATER_SKIN_R1-distt*WATER_ABSORB_R,WATER_SKIN_G1-distt*WATER_ABSORB_G,WATER_SKIN_B1-distt*WATER_ABSORB_B,1.0-distt*DIRTY_WATER),0.0,1.0));//1.0-estimatedDepth*6.0;0.0,1.0));
			#else
				estimatedDepth2=clamp(vec3(WATER_SKIN_R-estimatedDepth*WATER_ABSORB_R,WATER_SKIN_G-estimatedDepth*WATER_ABSORB_G,WATER_SKIN_B-estimatedDepth*WATER_ABSORB_B),0.0,1.0);//1.0-estimatedDepth*6.0;
			//directLightCol*= estimatedDepth2;
			float distt = -textureLod(colortex15,texcoord.xy,0).b;
		estimatedDepth3 = max( vec4(estimatedDepth2,1.0-estimatedDepth*DIRTY_WATER), clamp(vec4(WATER_SKIN_R-distt*WATER_ABSORB_R,WATER_SKIN_G-distt*WATER_ABSORB_G,WATER_SKIN_B-distt*WATER_ABSORB_B,1.0-distt*DIRTY_WATER),0.0,1.0));//1.0-estimatedDepth*6.0;0.0,1.0));
			#endif
			
			
			if (isEyeInWater == 0){
				ambientLight *= min(exp(-totEpsilon*estimatedDepth), custom_lightmap.x);
				ambientLight += custom_lightmap.z;
				
			}
			else {
				ambientLight += 10.0 * exp(-totEpsilon*8.0);
				ambientLight *= exp(-totEpsilon*estimatedDepth)*8./150./3.;
				
			}
			ambientLight *= mix(caustics,1.0,0.85);
			//ambientLight += (custom_lightmap.y+torch_hand_light)*vec3(TORCH_R,TORCH_G,TORCH_B)*TORCH_DIV_BOUNCES;
			ambient_torch=(custom_lightmap.y+torch_hand_light
			
			)*vec3(TORCH_R,TORCH_G,TORCH_B)*TORCH_DIV_BOUNCES;
			#ifdef SSGI
				float ao = 1.0;
				if (!hand)
					ssao(ao,fragpos,1.0,noise,decode(dataUnpacked0.yw));
				ambientLight *= ao;
			#endif
			
		
			
		#if PBR_QUALITY_CPF == 5
				//combine all light sources
				vec4 sky_light_cpf=get_ambient_cpf(lightmap,custom_lightmap);
				gl_FragData[0].rgb =	clamp( albedo*shading);// * directLightCol);// + albedo*sky_light_cpf.rgb*sky_light_cpf.a , 0.0, 1.0);
			//	gl_FragData[0].rgb = ((shading*diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight+ emitting)*albedo;
			#else
				//combine all light sources
				
				
				
				color_0_out = (mix(1.0,shading,estimatedDepth3.a)*(diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight+ emitting)*mix(vec3(DIRTY_WATER_R,DIRTY_WATER_G,DIRTY_WATER_B),albedo.rgb,estimatedDepth3.a);
				
				
			gl_FragData[0].rgb =color_0_out;
	
			#endif
			//Bruteforce integration is probably overkill
			vec3 lightColVol = lightCol.rgb * (1.0-pow(1.0-WsunVec.y,5.0));	//fresnel
			vec3 ambientColVol =  ambientUp*8./150./3.*0.5 / 240.0 * eyeBrightnessSmooth.y;
			if (isEyeInWater == 0)
				waterVolumetrics(gl_FragData[0].rgb, fragpos0, fragpos, estimatedDepth, estimatedSunDepth, Vdiff, noise, totEpsilon, scatterCoef, ambientColVol, lightColVol, dot(np3, WsunVec));
			//gl_FragData[0].rgb *= exp(-Vdiff * totEpsilon);
		//	gl_FragData[0].rgb += (ambientUp*8./150./3. + custom_lightmap.z + lightCol.rgb*0.5) * ;
		//	gl_FragData[0].rgb = vec3(caustics);
		}
		else {
	
			 ambientLight= texture2D(colortex14,texcoord).a == 1.0? ambientLight * ( AMBIENT_LIGHT_FLAT) : ambientLight;//use unfaded old ambient on creatures and hand where pbr are diisabled   is_hand_held ? HANDHELD_AMBIENT_LIGHT_FLAT :
			
			sssAmount*= INTEGRATED_SSS;
			#ifdef SSGI
				if (!hand)
					ambientLight = rtGI(normal, blueNoise(gl_FragCoord.xy), fragpos, ambientLight* custom_lightmap.x, sssAmount, custom_lightmap.z*vec3(0.9,1.0,1.5) + custom_lightmap.y*vec3(TORCH_R,TORCH_G,TORCH_B), normalize(albedo+1e-5)*0.7);
				else
					ambientLight = ambientLight* custom_lightmap.x + custom_lightmap.z*vec3(0.9,1.0,1.5);
					ambient_torch=(custom_lightmap.y+torch_hand_light)*vec3(TORCH_R,TORCH_G,TORCH_B)*TORCH_DIV_BOUNCES;
			#else
					ambientLight = ambientLight* custom_lightmap.x + custom_lightmap.z*vec3(0.9,1.0,1.5); 
					ambient_torch=(custom_lightmap.y+torch_hand_light)*vec3(TORCH_R,TORCH_G,TORCH_B)*TORCH_DIV_BOUNCES;
			#endif
			
			
			 color_0_out = ((shading * diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight + emitting)*albedo;
			
			
			}//land
			
			
			#if PBR_QUALITY_CPF == 5
				//combine all light sources
				//vec4 sky_light_cpf=get_ambient_cpf(lightmap,custom_lightmap);
				gl_FragData[0].rgb =	clamp( albedo*shading);// * directLightCol);// + albedo*sky_light_cpf.rgb*sky_light_cpf.a , 0.0, 1.0);
			//	gl_FragData[0].rgb = ((shading*diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight+ emitting)*albedo;
			#else
			
			
			
			vec4 albedo_target = vec4(albedo.rgb,1.0);
			vec4 specular_target = textureLod(colortex9,texcoord.xy,0);// *insun ;//colortex9.rgb *insun;
			vec4 normal_target;
			normal_target.xyz = normal;
			//tangent =   textureLod(colortex11,texcoord.xy,0);
			//tangent.z*=-1;
			vec4 tangent2 =   textureLod(colortex10,texcoord.xy,0);
			//tangent2.z*=-1;
			

			vec4 spec2 = textureLod(colortex12,texcoord.xy,0);
			float reflectivity_angle_face = spec2.x;
			float sky_exposure_cpf = spec2.y;//sky_reflection
			//float uppish = spec2.w;
			float sky_reflection;
			#include "/pbr.glsl"
			albedo.rgb = albedo_target.rgb;
			
				#if PBR_SPARKLE_CUTOFF == 1000
				float insun =  clamp(min(shading, diffuseSun)*spec2.w,0.0,1.0)  ;
				#else
				float insun =  min(shading, diffuseSun)*spec2.w > PBR_SPARKLE_CUTOFF*0.01 ? 1: 0 ;
				#endif
				
				
				
				
			#if PBR_LIGHTING ==0 
			//combine all light sources
			
			#else
			
			vec4 sky_light_cpf;
			vec4 sky_light_diffuse ;
			
			
			
			if(doing_pbr)//do pbr flag == 0
			{
#if defined IS_IRIS && defined DISTANT_HORIZONS && BUGGY_DH_SHADING == 2

	#define DH_BLEND_MODE 2 //[0 1 2]// how far1 to fade close chunks into far1 chunks
	#define DH_FADE .3 //[0.01 .1 .2 .3 .4 .5]// how far1 to fade close chunks into far1 chunks
	#if DH_BLEND_MODE == 1 || DH_BLEND_MODE == 3
		float ddddd = clamp(((distance(vec3(0.),relative_position2.xyz)/far1)-(1.-DH_FADE))*(1./DH_FADE),0.,1.);
		if(ddddd > fract(sin(gl_FragCoord.x *10.0+gl_FragCoord.y+gl_FragCoord.z *31.0)))
		{
				insun = .5;
			insun2 = .5;
		}
	#else
		float ddddd = clamp(((distance(vec3(0.),relative_position2.xyz)/far1)-(1.-DH_FADE))*(1./DH_FADE),0.,1.);
		#if DH_BLEND_MODE == 0
if(ddddd > 0.9)
		{
		//ddddd = clamp(ddddd,0.,1.);
			//insun = mix(insun,.5,ddddd);
			//insun2 = mix(insun2,.5,ddddd);
				insun = .5;
			insun2 = .5;
			
		}
		#else		
		//if(ddddd > 0.9)
		{
		//ddddd = clamp(ddddd,0.,1.);
			insun = mix(insun,.5,ddddd);
			insun2 = mix(insun2,.5,ddddd);
			//	insun = .5;
		//	insun2 = .5;
			
		}
		#endif
		
	#endif
#endif
/*
			#if defined IS_IRIS && defined DISTANT_HORIZONS
				#if BUGGY_DH_SHADING == 2
		if(ddddd > fract(sin(relative_position2.x *10.0+relative_position2.y+relative_position2.z *31.0)))
{
			//shading=0.5;//debug
		//	insun = .5;
		//	insun2 = .5;
		}
		#endif
		
			#endif
*/
			
				//combine all light sources
			
				
				
				//insun2=insun;
				//gl_FragData[0].rgb = (shading*(diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight + emitting)*albedo;
				//gl_FragData[0].rgb = (insun*albedo);//(diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight + emitting)*albedo;
				
				//combine all light sources
				//vec4 
				sky_light_cpf = get_ambient_cpf(spec2.xy,custom_lightmap) ;
				//sky_light_cpf = get_ambient_cpf(vec2(1.0),custom_lightmap) ;
				//vec4 sky_light_cpf = get_ambient_cpf(textureLod(colortex15,texcoord.xy,0).xz,custom_lightmap) ;
				
				//sky_light_cpf.rgb*=directLightCol.rgb*.02;
				
				sky_light_diffuse = sky_light_cpf; //POTENTIAL PROBLEM, SHOULD BE EXPOSURE, NOT REFLECTION, WHICH IS IT
				
				#define CATCH_COLOR 0
				#define CATCH_SKY 0
				#include "/jank_tracing5.glsl"
				vec3 bounce_light = vec3(0.0);// BOUNCE_LIGHT_M *(SPECULAR_BOUNCE_LIGHT*.1*reflection_color_total*mix(reflectivity_total,(1.0),OVERDRIVE_S) + reflection_color_total2*DIFFUSE_BOUNCE_LIGHT*.1 *mix(albedo.rgb,vec3(1.0),OVERDRIVE_D));
				
				//color_0_out = color_0_out+ (shading*(diffuseSun*insun + SSS)/pi*8./150./3.*directLightCol.rgb+ ambientLight + emitting)*albedo.rgb;//
				//albedo.rgb =	( albedo*insun)* directLightCol.rgb + albedo.rgb*sky_light_cpf.rgb*sky_light_cpf.a*sky_reflection;
				
				//directLightCol.rgb = vec3(1.0);
				//albedo.rgb = albedo.rgb * diffuse_lighting *insun*directLightCol.rgb;
				
				//pbr specular
				sky_light_cpf.rgb  = metalness < 1.0 ? sky_light_cpf.rgb  : sky_light_cpf.rgb  * albedo_target.rgb;
				
				//reduce diffuse for specular
				albedo.rgb=mix(albedo.rgb,vec3(0.0),reflectivity_total*REDUCE_DIFFUSE_BY_REFLECTIVITY);
				color_0_out.rgb=mix(color_0_out.rgb,vec3(0.0),reflectivity_total*REDUCE_DIFFUSE_BY_REFLECTIVITY);
				
				vec3 bouncy = vec3(0.0);//(ray_emit2+ray_emit)*PBR_EMMISSIVE_STRENGTH+reflection_color_total*SPECULAR_BOUNCE_LIGHT*mix(reflectivity_total,(1.0),OVERDRIVE_S) + reflection_color_total2*DIFFUSE_BOUNCE_LIGHT *mix(albedo.rgb,vec3(1.0),OVERDRIVE_D);
				
				color_0_out.rgb= bounce_light+(sky_light_cpf.rgb *sky_light_cpf.a) *sky_reflection *5 + color_0_out.rgb +.05 * SPECULAR_STRENGTH_ * directLightCol.rgb*highlights.rgb*insun  + diffuse_sky_ambient*sky_light_diffuse.rgb * SKY_AMBIENT_LIGHT*sky_light_diffuse.a   * mix(albedo_target.rgb,vec3(1.0),clamp(min(smoothness, reflectivity_total * HALF_RAYS ),0.02*HALF_RAYS,1.0)) ;
				//sss
				color_0_out.rgb=color_0_out.rgb+ albedo_target.rgb* back_lighting *SUBSURFACE_SCATTERING_CPF *sun_color *insun2 * mix( 0.001 * directLightCol.rgb,vec3(1.0),moon_light);
				
				
				
				//color_0_out.rgb = vec3(debugvalue);
				//color_0_out.rgb =albedo_target.rgb* back_lighting *SUBSURFACE_SCATTERING_CPF *sun_color *insun2 ;
				//color_0_out.rgb = albedo_target.rgb*vec3(insun2);
				
				//pbr diffuse night
				
				color_0_out.rgb = worldTime> 12000 ? color_0_out.rgb+ moon_light*0.7*abs(directLightCol.g)*abs(shading*insun)* sun_color*diffuse_lighting2*albedo_target.rgb: color_0_out.rgb;
				
				color_0_out.rgb*=estimatedDepth2;
				//estimatedDepth3=vec3(1.0);
				color_0_out.rgb+= albedo.rgb*(ambient_torch+emmissiveness * PBR_EMMISSIVE_STRENGTH)*estimatedDepth3.rgb*estimatedDepth3.a;
				
				
				
				
				//albedo.rgb = vec3(reflectivity_angle_face);
				
				//albedo.rgb= sky_light_cpf.rgb;//debug
				
				//	gl_FragData[0].rgb = ((shading*diffuseSun + SSS)/pi*8./150./3.*directLightCol.rgb + ambientLight+ emitting)*albedo;
			}//temp pbr disabled on hand and entities
			#endif
				
			//border_fog=1;//debug
				color_0_out.rgb = mix(color_0_out.rgb,fog_color *.001,border_fog);
			
			
			//debug area
			#if DEBUG_CPF
			vec4 data = texture2D(colortex1,texcoord.xy);
		vec4 dataUnpacked0 = vec4(decodeVec2(data.x),decodeVec2(data.y));
		vec4 dataUnpacked1 = vec4(decodeVec2(data.z),decodeVec2(data.w));

		vec3 albedo2 = toLinear(vec3(dataUnpacked0.xz,dataUnpacked1.x));
		 vec4 specular_target2 =  textureLod(colortex9,texcoord.xy,0);
					float emmissiveness2 = specular_target2.a < 254.5/255.0 ? specular_target2.a : 0;
					
					vec3 ray_emit2 = albedo2+15.0 * albedo2*emmissiveness2;
				debugvalue3  = ray_emit2;//bumpy_orth.xyz;//oorgb;//vec3(reflectivity_total);// fract( relative_position);//=.05*texture2D(colortex4,texcoord).rgb;//toLinear(texture2D(colortex4,texcoord).rgb)/10.*4.0*ffstep(0.985,-dot(lightCol.a*WsunVec,np3));
				
				//debugvalue3  = bumpy_orth.xyz;//
			    color_0_out.rgb =debugvalue3;//.5+.5*tangent2.xyz;
			#endif
			//color_0_out.rgb =11*texture2D(colortex13,texcoord.xy).rgb;//colortex13
		
			//color_0_out.rgb = diffuse_sky_ambient*sky_light_diffuse.rgb;//* albedo_target.rgb;// *sky_light_diffuse.a   * albedo_target.rgb;
			//color_0_out.rgb = vec3(reflectivity_angle_face); 
			//color_0_out.rgb = vec3(uppish);//sun_allowed_indoors
			//color_0_out.rgb = fract(vec3(relative_position.z));
			//color_0_out.r = (relative_position.z<0?1:0);
			//color_0_out.rgb = vec3(curved_lens2*.5+.5);
			//color_0_out.rgb =vec3(texcoord.xy,texture2D(depthtex0,texcoord.xy).x);
			//color_0_out.rgb = rayhit?vec3(1):vec3(oobrgb);
			//color_0_out.rgb =vec3(texture2D(depthtex0,texcoord.xy).x);
			
			//color_0_out.rgb = reflected_angle_orth*.5+.5;//bumpy_orth //reflected_angle_orth
			//color_0_out.rgb = .5+.5*bumpy_orth;// //reflected_angle_orth
			//color_0_out.rgb = .5+.5*vec3(clamp(1-distance(sun_angle,reflected_angle_orth),0,1));
			//color_0_out.rgb = vec3(reflectivity_angle);
			//color_0_out.rgb = vec3(fresnel);
			//[ 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
			
			//color_0_out.rgb = .5+.5*vec3(bumpy_orth.z);
			//color_0_out.rgb = .5+.5*vec3(bumpy_orth.z);
			//color_0_out.r = bumpy_orth.z>0?1:0;
			//color_0_out.rgb = vec3(rayspeed.z>0?1:0,rayspeed.z<0?1:0,0)*.5+.5;
			//color_0_out.rgb = texture2D(colortex1,texcoord).rgb);
				//albedo.rgb = clamp(.5+5*bumpy.xyz,0,1); //debug
				//color_0_out.rgb =  albedo_target.rgb* (subsurface_lighting ) *sun_color +albedo_target.rgb* back_lighting  *sun_color *insun2;
				//color_0_out.rgb = vec3(insun,insun2,0.0);
				//color_0_out.rgb = vec3(insun);
				//albedo.rgb = highlights.rgb;
				//albedo.rgb = fract(vec3((curved_lens.xy+1)*.5,0.0)*2);
				
				//albedo.rgb=clamp( vec3(0.0) *(1-reflectivity) + reflectivity*reflection_color ,0,1);
				//albedo.rgb = vec3(sky_reflectivity_angle);
				//albedo.rgb = vec3(.5+.5*spec2.zw,1.0-(abs(spec2.z)+abs(spec2.w)));
				
				
				gl_FragData[0].rgb = color_0_out.rgb ;

				//gl_FragData[0].rgb =  0.1* textureLod(colortex4,vec2(.25*CLOUDS_QUALITY,.6*CLOUDS_QUALITY),0).rgb;//texcoord
				//gl_FragData[0].rgb =  vec3(spec2.y);
				//waterfogcolor =  .02* texture2D(colortex4,vec2(.25*CLOUDS_QUALITY,.3*CLOUDS_QUALITY)).rgb;
				
			#endif
		//	gl_FragData[0].rgb = vec3(fwidth(filtered.b));
			//waterVolumetrics(gl_FragData[0].rgb, vec3(0.0), fragpos, 0.0, 0.0, length(fragpos), noise, waterEpsilon, ambientUp*8./150./3. + custom_lightmap.z, lightCol.rgb);
		//}
	}


				
/* RENDERTARGETS: 3,15 */
}
