
/*
const bool colortex4MipmapEnabled = true;
*/

layout(location = 0) out vec2 velocityData;
layout(location = 1) out vec4 temporalData;

/* DRAWBUFFERS:25 */

in vec2 texcoord;
flat in float exposure;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

#ifdef DOF_ENABLED
    flat in float centerDepthSmooth;
#endif

vec2 CalculateCameraVelocity(in vec2 coord, in float depth) {
    vec3 projection = vec3(coord, depth) * 2.0 - 1.0;
    projection = (vec3(vec2(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y) * projection.xy, 0.0) + gbufferProjectionInverse[3].xyz) / (gbufferProjectionInverse[2].w * projection.z + gbufferProjectionInverse[3].w);
    projection = mat3(gbufferModelViewInverse) * projection + gbufferModelViewInverse[3].xyz;

    if (depth < 1.0) projection += cameraPosition - previousCameraPosition;

    projection = mat3(gbufferPreviousModelView) * projection + gbufferPreviousModelView[3].xyz;
    projection = (vec3(gbufferPreviousProjection[0].x, gbufferPreviousProjection[1].y, gbufferPreviousProjection[2].z) * projection + gbufferPreviousProjection[3].xyz) / -projection.z * 0.5 + 0.5;
    return (coord - projection.xy);
}

#ifdef TAA_ENABLED
    vec3 reinhard(in vec3 color) {
        return color / (1.0 + GetLuminance(color));
    }
    vec3 invReinhard(in vec3 color) {
        return color / (1.0 - GetLuminance(color));
    }

    vec3 clipAABB(in vec3 boxMin, in vec3 boxMax, in vec3 previousSample) {
        vec3 p_clip = 0.5 * (boxMax + boxMin);
        vec3 e_clip = 0.5 * (boxMax - boxMin);

        vec3 v_clip = previousSample - p_clip;
        vec3 v_unit = v_clip / e_clip;
        vec3 a_unit = abs(v_unit);
        float ma_unit = maxOf(a_unit);

        if (ma_unit > 1.0) {
            return v_clip / ma_unit + p_clip;
        }else{
            return previousSample;
        }
    }

    #define maxOf(a, b, c, d, e, f, g, h, i) max(a, max(b, max(c, max(d, max(e, max(f, max(g, max(h, i))))))))
    #define minOf(a, b, c, d, e, f, g, h, i) min(a, min(b, min(c, min(d, min(e, min(f, min(g, min(h, i))))))))

	//approximation from SMAA presentation from siggraph 2016
	vec4 textureCatmullRomFast(in sampler2D tex, in vec2 coord, in const float sharpness) {
		//vec2 screenSize = textureSize(sampler, 0);
		//vec2 pixelSize = 1.0 / screenSize;

		vec2 position = screenSize * coord;
		vec2 centerPosition = floor(position - 0.5) + 0.5;
		vec2 f = position - centerPosition;
		vec2 f2 = f * f;
		vec2 f3 = f * f2;

		vec2 w0 = -sharpness        * f3 + 2.0 * sharpness         * f2 - sharpness * f;
		vec2 w1 = (2.0 - sharpness) * f3 - (3.0 - sharpness)       * f2 + 1.0;
		vec2 w2 = (sharpness - 2.0) * f3 + (3.0 - 2.0 * sharpness) * f2 + sharpness * f;
		vec2 w3 = sharpness         * f3 - sharpness               * f2;

		vec2 w12 = w1 + w2;

		vec2 tc0 = screenPixelSize * (centerPosition - 1.0);
		vec2 tc3 = screenPixelSize * (centerPosition + 2.0);
		vec2 tc12 = screenPixelSize * (centerPosition + w2 / w12);

		float l0 = w12.x * w0.y;
		float l1 = w0.x  * w12.y;
		float l2 = w12.x * w12.y;
		float l3 = w3.x  * w12.y;
		float l4 = w12.x * w3.y;

		vec4 color =  texture(tex, vec2(tc12.x, tc0.y )) * l0
					+ texture(tex, vec2(tc0.x,  tc12.y)) * l1
					+ texture(tex, vec2(tc12.x, tc12.y)) * l2
					+ texture(tex, vec2(tc3.x,  tc12.y)) * l3
					+ texture(tex, vec2(tc12.x, tc3.y )) * l4;

		return color / (l0 + l1 + l2 + l3 + l4);
	}

    vec3 TemporalReprojection(in vec2 coord, in vec2 velocity) {
	    vec2 previousCoord = coord - velocity;
        coord = saturate(coord + taaOffset * 0.5);
        ivec2 texel = ivec2(coord * screenSize);

        vec3 currentSample = texelFetch(colortex4, texel, 0).rgb;
        if (saturate(previousCoord) != previousCoord) return currentSample;

        #define SampleColor(shift) texelFetch(colortex4, texel + shift, 0).rgb;

        vec3 col1 = SampleColor(ivec2(-1,  1));
        vec3 col2 = SampleColor(ivec2( 0,  1));
        vec3 col3 = SampleColor(ivec2( 1,  1));
        vec3 col4 = SampleColor(ivec2(-1,  0));
        vec3 col5 = SampleColor(ivec2( 1,  0));
        vec3 col6 = SampleColor(ivec2(-1, -1));
        vec3 col7 = SampleColor(ivec2( 0, -1));
        vec3 col8 = SampleColor(ivec2( 1, -1));

        vec3 clipMin = minOf(currentSample, col1, col2, col3, col4, col5, col6, col7, col8);
        vec3 clipMax = maxOf(currentSample, col1, col2, col3, col4, col5, col6, col7, col8);
        //vec3 clipAVG = (currentSample + col1 + col2 + col3 + col4 + col5 + col6 + col7 + col8) * rcp(9.0);

        float blendWeight = 0.97;
        vec2 pixelVelocity = 1.0 - abs(fract(previousCoord * screenSize) * 2.0 - 1.0);
        blendWeight *= sqrt(pixelVelocity.x * pixelVelocity.y) * 0.25 + 0.75;

        #ifdef TAA_SHARPEN
            //currentSample = textureSmoothFilter(colortex4, coord).rgb;
            vec3 previousSample = max0(textureCatmullRomFast(colortex5, previousCoord, TAA_SHARPNESS).rgb);
        #else
            vec3 previousSample = max0(texture(colortex5, previousCoord).rgb);
        #endif
        previousSample = clipAABB(clipMin, clipMax, previousSample);

        return invReinhard(mix(reinhard(currentSample), reinhard(previousSample), blendWeight));
    }
#endif

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel = ivec2(gl_FragCoord.xy);
    float depth = texelFetch(depthtex0, texel, 0).x;
    velocityData = (depth < 0.56) ? vec2(0.0) : CalculateCameraVelocity(texcoord, depth);

    //velocityData = velocity * 0.5 + 0.5;

    #ifdef TAA_ENABLED
        temporalData.rgb = clamp16F(TemporalReprojection(texcoord, velocityData));
    #else
        temporalData.rgb = texelFetch(colortex4, texel, 0).rgb;
    #endif

    temporalData.a = 0.0;
    if (texel == ivec2(0)) temporalData.a = exposure;
    #ifdef DOF_ENABLED
        if (texel == ivec2(1)) temporalData.a = centerDepthSmooth;
    #endif
}
