/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

record Sin(float frequency, Noise alpha) implements Noise
{
    public static final Codec<Sin> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(Sin::frequency), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("alpha").forGetter(Sin::alpha)).apply((Applicative)instance, Sin::new));

    @Override
    public float compute(float x, float z, int seed) {
        float noise;
        float a = this.alpha.compute(x, z, seed);
        x *= this.frequency;
        z *= this.frequency;
        if (a == 0.0f) {
            noise = NoiseUtil.sin(x);
        } else if (a == 1.0f) {
            noise = NoiseUtil.sin(z);
        } else {
            float sx = NoiseUtil.sin(x);
            float sy = NoiseUtil.sin(z);
            noise = NoiseUtil.lerp(sx, sy, a);
        }
        return NoiseUtil.map(noise, -1.0f, 1.0f, 2.0f);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(new Sin(this.frequency, this.alpha.mapAll(visitor)));
    }

    public Codec<Sin> codec() {
        return CODEC;
    }
}

