/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.PerlinRidge;
import raccoonman.reterraforged.world.worldgen.noise.module.Simplex2;

record SimplexRidge(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation, float[] spectralWeights, float min, float max) implements Noise
{
    public static final Codec<PerlinRidge> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(PerlinRidge::frequency), (App)Codec.INT.fieldOf("octaves").forGetter(PerlinRidge::octaves), (App)Codec.FLOAT.fieldOf("lacunarity").forGetter(PerlinRidge::lacunarity), (App)Codec.FLOAT.fieldOf("gain").forGetter(PerlinRidge::gain), (App)Interpolation.CODEC.fieldOf("interpolation").forGetter(PerlinRidge::interpolation)).apply((Applicative)instance, PerlinRidge::new));

    public SimplexRidge(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation) {
        this(frequency, octaves, lacunarity, gain, interpolation, SimplexRidge.calculateSpectralWeights(lacunarity));
    }

    private SimplexRidge(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation, float[] spectralWeights) {
        this(frequency, octaves, lacunarity, gain, interpolation, spectralWeights, 0.0f, Simplex2.max(octaves, gain));
    }

    @Override
    public float compute(float x, float z, int seed) {
        x *= this.frequency;
        z *= this.frequency;
        float value = 0.0f;
        float weight = 1.0f;
        float offset = 1.0f;
        float amp = 2.0f;
        for (int octave = 0; octave < this.octaves; ++octave) {
            float signal = Simplex2.sample(x, z, seed + octave);
            signal = Math.abs(signal);
            signal = offset - signal;
            signal *= signal;
            signal *= weight;
            weight = signal * amp;
            weight = NoiseUtil.clamp(weight, 0.0f, 1.0f);
            value += signal * this.spectralWeights[octave];
            x *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(value, this.min, this.max, Math.abs(this.max - this.min));
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<PerlinRidge> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SimplexRidge)) return false;
        SimplexRidge other = (SimplexRidge)o;
        if (other.frequency != this.frequency) return false;
        if (other.octaves != this.octaves) return false;
        if (other.lacunarity != this.lacunarity) return false;
        if (other.gain != this.gain) return false;
        if (!other.interpolation.equals(this.interpolation)) return false;
        return true;
    }

    private static float[] calculateSpectralWeights(float lacunarity) {
        float frequency = 1.0f;
        float[] spectralWeights = new float[30];
        for (int i = 0; i < spectralWeights.length; ++i) {
            spectralWeights[i] = NoiseUtil.pow(frequency, -1.0f);
            frequency *= lacunarity;
        }
        return spectralWeights;
    }
}

