/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public record Simplex(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation, float min, float max) implements Noise
{
    public static final Codec<Simplex> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(Simplex::frequency), (App)Codec.INT.fieldOf("octaves").forGetter(Simplex::octaves), (App)Codec.FLOAT.fieldOf("lacunarity").forGetter(Simplex::lacunarity), (App)Codec.FLOAT.fieldOf("gain").forGetter(Simplex::gain), (App)Interpolation.CODEC.fieldOf("interpolation").forGetter(Simplex::interpolation)).apply((Applicative)instance, Simplex::new));
    private static final float[] SIGNALS = new float[]{1.0f, 0.989f, 0.81f, 0.781f, 0.708f, 0.702f, 0.696f};

    public Simplex(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation) {
        this(frequency, octaves, lacunarity, gain, interpolation, -Simplex.max(octaves, gain), Simplex.max(octaves, gain));
    }

    @Override
    public float compute(float x, float z, int seed) {
        x *= this.frequency;
        z *= this.frequency;
        float sum = 0.0f;
        float amp = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Simplex.sample(x, z, seed + i) * amp;
            x *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.max - this.min);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<Simplex> codec() {
        return CODEC;
    }

    public static float sample(float x, float y, int seed) {
        return Simplex.singleSimplex(x, y, seed, 79.869484f);
    }

    public static float singleSimplex(float x, float y, int seed, float scaler) {
        float n3;
        float n2;
        float n0;
        int j2;
        int i2;
        float Y0;
        float y2;
        int j;
        float t = (x + y) * 0.36602542f;
        int i = NoiseUtil.floor(x + t);
        float X0 = (float)i - (t = (float)(i + (j = NoiseUtil.floor(y + t))) * 0.21132487f);
        float x2 = x - X0;
        if (x2 > (y2 = y - (Y0 = (float)j - t))) {
            i2 = 1;
            j2 = 0;
        } else {
            i2 = 0;
            j2 = 1;
        }
        float x3 = x2 - (float)i2 + 0.21132487f;
        float y3 = y2 - (float)j2 + 0.21132487f;
        float x4 = x2 - 1.0f + 0.42264974f;
        float y4 = y2 - 1.0f + 0.42264974f;
        t = 0.5f - x2 * x2 - y2 * y2;
        if (t < 0.0f) {
            n0 = 0.0f;
        } else {
            t *= t;
            n0 = t * t * NoiseUtil.gradCoord2D_24(seed, i, j, x2, y2);
        }
        t = 0.5f - x3 * x3 - y3 * y3;
        if (t < 0.0f) {
            n2 = 0.0f;
        } else {
            t *= t;
            n2 = t * t * NoiseUtil.gradCoord2D_24(seed, i + i2, j + j2, x3, y3);
        }
        t = 0.5f - x4 * x4 - y4 * y4;
        if (t < 0.0f) {
            n3 = 0.0f;
        } else {
            t *= t;
            n3 = t * t * NoiseUtil.gradCoord2D_24(seed, i + 1, j + 1, x4, y4);
        }
        return scaler * (n0 + n2 + n3);
    }

    private static float max(int octaves, float gain) {
        float signal = Simplex.signal(octaves);
        float sum = 0.0f;
        float amp = 1.0f;
        for (int i = 0; i < octaves; ++i) {
            sum += amp * signal;
            amp *= gain;
        }
        return sum;
    }

    private static float signal(int octaves) {
        int index = Math.min(octaves, SIGNALS.length - 1);
        return SIGNALS[index];
    }
}

