/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public record LinearSpline(Noise input, List<Pair<Float, Noise>> points, float minValue, float maxValue) implements Noise
{
    public static final Codec<LinearSpline> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Noise.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(LinearSpline::input), (App)ExtraCodecs.m_144637_((Codec)Codec.pair((Codec)Codec.FLOAT, Noise.HOLDER_HELPER_CODEC).listOf()).fieldOf("points").forGetter(LinearSpline::points)).apply((Applicative)instance, LinearSpline::new));

    public LinearSpline(Noise input, List<Pair<Float, Noise>> points) {
        this(input, points, LinearSpline.min(points), LinearSpline.max(points));
    }

    @Override
    public float compute(float x, float z, int seed) {
        float input = this.input.compute(x, z, seed);
        int pointCount = this.points.size();
        Pair<Float, Noise> first = this.points.get(0);
        Pair<Float, Noise> last = this.points.get(pointCount - 1);
        if (input <= ((Float)first.getFirst()).floatValue()) {
            return ((Noise)first.getSecond()).compute(x, z, seed);
        }
        if (input >= ((Float)last.getFirst()).floatValue()) {
            return ((Noise)last.getSecond()).compute(x, z, seed);
        }
        int index = Mth.m_14049_((int)0, (int)pointCount, i -> input < ((Float)this.points.get(i).getFirst()).floatValue()) - 1;
        Pair<Float, Noise> start = this.points.get(index);
        Pair<Float, Noise> end = this.points.get(index + 1);
        float min = ((Float)start.getFirst()).floatValue();
        float max = ((Float)end.getFirst()).floatValue();
        float from = ((Noise)start.getSecond()).compute(x, z, seed);
        float to = ((Noise)end.getSecond()).compute(x, z, seed);
        float lerp = NoiseUtil.map(input, 0.0f, 1.0f, min, max);
        lerp = NoiseUtil.clamp(lerp, 0.0f, 1.0f);
        return NoiseUtil.lerp(from, to, lerp);
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(new LinearSpline(this.input.mapAll(visitor), this.points.stream().map(point -> Pair.of((Object)((Float)point.getFirst()), (Object)visitor.apply((Noise)point.getSecond()))).toList()));
    }

    public Codec<LinearSpline> codec() {
        return CODEC;
    }

    public static Builder builder(Noise noise) {
        return new Builder(noise);
    }

    private static float min(List<Pair<Float, Noise>> points) {
        return (float)points.stream().map(Pair::getSecond).mapToDouble(Noise::minValue).min().orElseThrow();
    }

    private static float max(List<Pair<Float, Noise>> points) {
        return (float)points.stream().map(Pair::getSecond).mapToDouble(Noise::maxValue).max().orElseThrow();
    }

    public static class Builder {
        private Noise input;
        private List<Pair<Float, Noise>> points;

        public Builder(Noise input) {
            this.input = input;
            this.points = new ArrayList<Pair<Float, Noise>>();
        }

        public Builder addPoint(float point, float value) {
            return this.addPoint(point, Noises.constant(value));
        }

        public Builder addPoint(float point, Noise value) {
            this.points.add((Pair<Float, Noise>)Pair.of((Object)Float.valueOf(point), (Object)value));
            return this;
        }

        public LinearSpline build() {
            return new LinearSpline(this.input, (List<Pair<Float, Noise>>)ImmutableList.copyOf(this.points));
        }
    }
}

