/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public record LegacyTemperature(float frequency, int power) implements Noise
{
    public static final Codec<LegacyTemperature> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(LegacyTemperature::frequency), (App)Codec.INT.fieldOf("power").forGetter(LegacyTemperature::power)).apply((Applicative)instance, LegacyTemperature::new));

    @Override
    public float compute(float x, float z, int seed) {
        float sin = NoiseUtil.sin(z *= this.frequency);
        sin = NoiseUtil.clamp(sin, -1.0f, 1.0f);
        float value = NoiseUtil.pow(sin, this.power);
        value = NoiseUtil.copySign(value, sin);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<LegacyTemperature> codec() {
        return CODEC;
    }
}

