/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public record LegacyMoisture(Noise source, int power) implements Noise
{
    public static final Codec<LegacyMoisture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Noise.HOLDER_HELPER_CODEC.fieldOf("source").forGetter(LegacyMoisture::source), (App)Codec.INT.fieldOf("power").forGetter(LegacyMoisture::power)).apply((Applicative)instance, LegacyMoisture::new));

    @Override
    public float compute(float x, float z, int seed) {
        float noise = this.source.compute(x, z, seed);
        if (this.power < 2) {
            return noise;
        }
        noise = (noise - 0.5f) * 2.0f;
        float value = NoiseUtil.pow(noise, this.power);
        value = NoiseUtil.copySign(value, noise);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(new LegacyMoisture(this.source.mapAll(visitor), this.power));
    }

    public Codec<LegacyMoisture> codec() {
        return CODEC;
    }
}

