/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.util.StringRepresentable;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public record Erosion(Noise input, int seed, int octaves, float strength, float gridSize, float amplitude, float lacunarity, float distanceFallOff, BlendMode blendMode, ThreadLocal<float[]> cache) implements Noise
{
    public static final Codec<Erosion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Noise.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(Erosion::input), (App)Codec.INT.fieldOf("seed").forGetter(Erosion::seed), (App)Codec.INT.fieldOf("octaves").forGetter(Erosion::octaves), (App)Codec.FLOAT.fieldOf("strength").forGetter(Erosion::strength), (App)Codec.FLOAT.fieldOf("grid_size").forGetter(Erosion::gridSize), (App)Codec.FLOAT.fieldOf("amplitude").forGetter(Erosion::amplitude), (App)Codec.FLOAT.fieldOf("lacunarity").forGetter(Erosion::lacunarity), (App)Codec.FLOAT.fieldOf("distance_falloff").forGetter(Erosion::distanceFallOff), (App)BlendMode.CODEC.fieldOf("blend_mode").forGetter(Erosion::blendMode)).apply((Applicative)instance, Erosion::new));

    public Erosion(Noise input, int seed, int octaves, float strength, float gridSize, float amplitude, float lacunarity, float distanceFallOff, BlendMode blendMode) {
        this(input, seed, octaves, strength, gridSize, amplitude, lacunarity, distanceFallOff, blendMode, ThreadLocal.withInitial(() -> new float[25]));
    }

    @Override
    public float compute(float x, float z, int seed) {
        float value = this.input.compute(x, z, seed);
        float erosion = this.getErosionValue(x, z, this.cache.get());
        return NoiseUtil.lerp(erosion, value, this.blendMode.blend(value, erosion, this.strength));
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return new Erosion(this.input.mapAll(visitor), this.seed, this.octaves, this.strength, this.gridSize, this.amplitude, this.lacunarity, this.distanceFallOff, this.blendMode);
    }

    public Codec<Erosion> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Erosion)) return false;
        Erosion other = (Erosion)o;
        if (!other.input.equals(this.input)) return false;
        if (other.seed != this.seed) return false;
        if (other.octaves != this.octaves) return false;
        if (other.strength != this.strength) return false;
        if (other.gridSize != this.gridSize) return false;
        if (other.amplitude != this.amplitude) return false;
        if (other.lacunarity != this.lacunarity) return false;
        if (other.distanceFallOff != this.distanceFallOff) return false;
        if (!other.blendMode.equals((Object)this.blendMode)) return false;
        return true;
    }

    private float getErosionValue(float x, float y, float[] cache) {
        float sum = 0.0f;
        float max = 0.0f;
        float gain = 1.0f;
        float distance = this.gridSize;
        for (int i = 0; i < this.octaves; ++i) {
            float value = this.getSingleErosionValue(x, y, distance, cache);
            sum += (value *= gain);
            max += gain;
            gain *= this.amplitude;
            distance *= this.distanceFallOff;
            x *= this.lacunarity;
            y *= this.lacunarity;
        }
        return sum / max;
    }

    private float getSingleErosionValue(float x, float y, float gridSize, float[] cache) {
        Arrays.fill(cache, -1.0f);
        int pix = NoiseUtil.floor(x / gridSize);
        int piy = NoiseUtil.floor(y / gridSize);
        float minHeight2 = Float.MAX_VALUE;
        for (int dy1 = -1; dy1 <= 1; ++dy1) {
            for (int dx1 = -1; dx1 <= 1; ++dx1) {
                int pax = pix + dx1;
                int pay = piy + dy1;
                NoiseUtil.Vec2f vec1 = NoiseUtil.cell(this.seed, pax, pay);
                float ax = ((float)pax + vec1.x()) * gridSize;
                float ay = ((float)pay + vec1.y()) * gridSize;
                float bx = ax;
                float by = ay;
                float lowestNeighbour = Float.MAX_VALUE;
                for (int dy2 = -1; dy2 <= 1; ++dy2) {
                    for (int dx2 = -1; dx2 <= 1; ++dx2) {
                        float candidateY;
                        int pbx = pax + dx2;
                        int pby = pay + dy2;
                        NoiseUtil.Vec2f vec2 = pbx == pax && pby == pay ? vec1 : NoiseUtil.cell(this.seed, pbx, pby);
                        float candidateX = ((float)pbx + vec2.x()) * gridSize;
                        float height = Erosion.getNoiseValue(dx1 + dx2, dy1 + dy2, candidateX, candidateY = ((float)pby + vec2.y()) * gridSize, this.input, cache);
                        if (!(height < lowestNeighbour)) continue;
                        lowestNeighbour = height;
                        bx = candidateX;
                        by = candidateY;
                    }
                }
                float height2 = Erosion.sd(x, y, ax, ay, bx, by);
                if (!(height2 < minHeight2)) continue;
                minHeight2 = height2;
            }
        }
        return NoiseUtil.clamp(Erosion.sqrt(minHeight2) / gridSize, 0.0f, 1.0f);
    }

    private static float getNoiseValue(int dx, int dy, float px, float py, Noise module, float[] cache) {
        int index = (dy + 2) * 5 + (dx + 2);
        float value = cache[index];
        if (value == -1.0f) {
            cache[index] = value = module.compute(px, py, 0);
        }
        return value;
    }

    private static float sd(float px, float py, float ax, float ay, float bx, float by) {
        float padx = px - ax;
        float pady = py - ay;
        float badx = bx - ax;
        float bady = by - ay;
        float paba = padx * badx + pady * bady;
        float baba = badx * badx + bady * bady;
        float h = NoiseUtil.clamp(paba / baba, 0.0f, 1.0f);
        return Erosion.len2(padx, pady, badx * h, bady * h);
    }

    private static float len2(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    private static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BlendMode implements StringRepresentable
    {
        CONSTANT("constant"){

            @Override
            public float blend(float value, float erosion, float strength) {
                return 1.0f - strength;
            }
        }
        ,
        INPUT_LINEAR("input_linear"){

            @Override
            public float blend(float value, float erosion, float strength) {
                return 1.0f - strength * value;
            }
        }
        ,
        OUTPUT_LINEAR("output_linear"){

            @Override
            public float blend(float value, float erosion, float strength) {
                return 1.0f - strength * erosion;
            }
        };

        public static final Codec<BlendMode> CODEC;
        private String name;

        private BlendMode(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public abstract float blend(float var1, float var2, float var3);

        static {
            CODEC = StringRepresentable.m_216439_(BlendMode::values);
        }
    }
}

