/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.function;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DistanceFunction implements StringRepresentable
{
    EUCLIDEAN("EUCLIDEAN"){

        @Override
        public float apply(float x, float y) {
            return x * x + y * y;
        }
    }
    ,
    MANHATTAN("MANHATTAN"){

        @Override
        public float apply(float x, float y) {
            return Math.abs(x) + Math.abs(y);
        }
    }
    ,
    NATURAL("NATURAL"){

        @Override
        public float apply(float x, float y) {
            return Math.abs(x) + Math.abs(y) + (x * x + y * y);
        }
    };

    public static final Codec<DistanceFunction> CODEC;
    private String name;

    private DistanceFunction(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public abstract float apply(float var1, float var2);

    static {
        CODEC = StringRepresentable.m_216439_(DistanceFunction::values);
    }
}

