/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.function;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CellFunction implements StringRepresentable
{
    CELL_VALUE("CELL_VALUE"){

        @Override
        public float apply(int seed, int xc, int yc, float distance, NoiseUtil.Vec2f vec2f, Noise lookup) {
            return NoiseUtil.valCoord2D(seed, xc, yc);
        }
    }
    ,
    NOISE_LOOKUP("NOISE_LOOKUP"){

        @Override
        public float apply(int seed, int xc, int yc, float distance, NoiseUtil.Vec2f vec2f, Noise lookup) {
            return lookup.compute((float)xc + vec2f.x(), (float)yc + vec2f.y(), seed);
        }

        @Override
        public float mapValue(float value, float min, float max, float range) {
            return value;
        }
    }
    ,
    DISTANCE("DISTANCE"){

        @Override
        public float apply(int seed, int xc, int yc, float distance, NoiseUtil.Vec2f vec2f, Noise lookup) {
            return distance - 1.0f;
        }

        @Override
        public float mapValue(float value, float min, float max, float range) {
            return 0.0f;
        }
    };

    public static final Codec<CellFunction> CODEC;
    private String name;

    private CellFunction(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public abstract float apply(int var1, int var2, int var3, float var4, NoiseUtil.Vec2f var5, Noise var6);

    public float mapValue(float value, float min, float max, float range) {
        return NoiseUtil.map(value, min, max, range);
    }

    static {
        CODEC = StringRepresentable.m_216439_(CellFunction::values);
    }
}

