/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.domain;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domain;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

record DomainWarp(Noise x, Noise z, Noise mappedX, Noise mappedZ, Noise distance) implements Domain
{
    public static final Codec<DomainWarp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Noise.HOLDER_HELPER_CODEC.fieldOf("x").forGetter(DomainWarp::x), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("z").forGetter(DomainWarp::z), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("distance").forGetter(DomainWarp::distance)).apply((Applicative)instance, DomainWarp::new));

    public DomainWarp(Noise x, Noise z, Noise distance) {
        this(x, z, DomainWarp.map(x), DomainWarp.map(z), distance);
    }

    @Override
    public float getOffsetX(float x, float z, int seed) {
        return this.mappedX.compute(x, z, seed) * this.distance.compute(x, z, seed);
    }

    @Override
    public float getOffsetZ(float x, float z, int seed) {
        return this.mappedZ.compute(x, z, seed) * this.distance.compute(x, z, seed);
    }

    @Override
    public Domain mapAll(Noise.Visitor visitor) {
        return new DomainWarp(this.x.mapAll(visitor), this.z.mapAll(visitor), this.mappedX.mapAll(visitor), this.mappedZ.mapAll(visitor), this.distance.mapAll(visitor));
    }

    public Codec<DomainWarp> codec() {
        return CODEC;
    }

    private static Noise map(Noise in) {
        if (in.minValue() == -0.5f && in.maxValue() == 0.5f) {
            return in;
        }
        return Noises.map(in, -0.5f, 0.5f);
    }
}

