/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.domain;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domain;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

record DirectionWarp(Noise direction, Noise strength) implements Domain
{
    public static final Codec<DirectionWarp> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Noise.HOLDER_HELPER_CODEC.fieldOf("direction").forGetter(DirectionWarp::direction), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("strength").forGetter(DirectionWarp::strength)).apply((Applicative)instance, DirectionWarp::new));

    @Override
    public float getOffsetX(float x, float z, int seed) {
        float angle = this.direction.compute(x, z, seed) * ((float)Math.PI * 2);
        return NoiseUtil.sin(angle) * this.strength.compute(x, z, seed);
    }

    @Override
    public float getOffsetZ(float x, float z, int seed) {
        float angle = this.direction.compute(x, z, seed) * ((float)Math.PI * 2);
        return NoiseUtil.cos(angle) * this.strength.compute(x, z, seed);
    }

    @Override
    public Domain mapAll(Noise.Visitor visitor) {
        return new DirectionWarp(this.direction.mapAll(visitor), this.strength.mapAll(visitor));
    }

    public Codec<DirectionWarp> codec() {
        return CODEC;
    }
}

