/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.template.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import raccoonman.reterraforged.world.worldgen.feature.template.StructureUtils;
import raccoonman.reterraforged.world.worldgen.feature.template.buffer.BufferIterator;
import raccoonman.reterraforged.world.worldgen.feature.template.buffer.PasteBuffer;
import raccoonman.reterraforged.world.worldgen.feature.template.buffer.TemplateBuffer;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.Paste;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.PasteConfig;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.PasteType;
import raccoonman.reterraforged.world.worldgen.feature.template.placement.TemplatePlacement;
import raccoonman.reterraforged.world.worldgen.feature.template.template.BakedDimensions;
import raccoonman.reterraforged.world.worldgen.feature.template.template.BakedTemplate;
import raccoonman.reterraforged.world.worldgen.feature.template.template.BlockInfo;
import raccoonman.reterraforged.world.worldgen.feature.template.template.Dimensions;
import raccoonman.reterraforged.world.worldgen.feature.template.template.TemplateContext;
import raccoonman.reterraforged.world.worldgen.feature.template.template.TemplateRegion;
import raccoonman.reterraforged.world.worldgen.feature.util.BlockReader;

public class FeatureTemplate {
    public static final PasteType WORLD_GEN = FeatureTemplate::getWorldGenPaste;
    public static final PasteType CHECKED = FeatureTemplate::getCheckedPaste;
    public static final PasteType UNCHECKED = FeatureTemplate::getUnCheckedPaste;
    private static final int PASTE_FLAG = 19;
    private static final Direction[] directions = Direction.values();
    private static final ThreadLocal<PasteBuffer> PASTE_BUFFER = ThreadLocal.withInitial(PasteBuffer::new);
    private static final ThreadLocal<TemplateBuffer> TEMPLATE_BUFFER = ThreadLocal.withInitial(TemplateBuffer::new);
    private static final ThreadLocal<TemplateRegion> TEMPLATE_REGION = ThreadLocal.withInitial(TemplateRegion::new);
    private final BakedTemplate template;
    private final BakedDimensions dimensions;

    public FeatureTemplate(List<BlockInfo> blocks) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        BlockInfo[] blockArray = blocks.toArray(new BlockInfo[0]);
        for (int i = 0; i < blocks.size(); ++i) {
            BlockInfo block = blocks.get(i);
            minX = Math.min(minX, block.pos().m_123341_());
            minY = Math.min(minY, block.pos().m_123342_());
            minZ = Math.min(minZ, block.pos().m_123343_());
            maxX = Math.max(maxX, block.pos().m_123341_());
            maxY = Math.max(maxY, block.pos().m_123342_());
            maxZ = Math.max(maxZ, block.pos().m_123343_());
            blockArray[i] = block;
        }
        Dimensions dimensions = new Dimensions(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.template = new BakedTemplate(blockArray);
        this.dimensions = new BakedDimensions(dimensions);
    }

    private static <T extends TemplateContext> BlockSetter setter(LevelAccessor world, T ctx) {
        return (pos, state, flags) -> {
            world.m_7731_(pos, state, flags);
            ctx.recordState(pos, state);
        };
    }

    public <T extends TemplateContext> boolean pasteWorldGen(LevelAccessor world, T ctx, BlockPos origin, Mirror mirror, Rotation rotation, TemplatePlacement<T> placement, PasteConfig config) {
        if (config.checkBounds()) {
            ChunkAccess chunk = world.m_46865_(origin);
            if (StructureUtils.hasOvergroundStructure((HolderLookup<Structure>)world.m_246945_(Registries.f_256944_), chunk)) {
                return this.pasteChecked(world, ctx, origin, mirror, rotation, placement, config);
            }
        }
        return this.pasteUnChecked(world, ctx, origin, mirror, rotation, placement, config);
    }

    private <T extends TemplateContext> boolean pasteUnChecked(LevelAccessor world, T ctx, BlockPos origin, Mirror mirror, Rotation rotation, TemplatePlacement<T> placement, PasteConfig config) {
        boolean placed = false;
        BlockReader reader = new BlockReader();
        PasteBuffer buffer = PASTE_BUFFER.get();
        TemplateRegion region = TEMPLATE_REGION.get().init(origin);
        buffer.setRecording(config.updatePostPaste());
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        BlockSetter setter = FeatureTemplate.setter(world, ctx);
        BlockInfo[] blocks = (BlockInfo[])this.template.get(mirror, rotation);
        for (int i = 0; i < blocks.length; ++i) {
            BlockInfo block = blocks[i];
            FeatureTemplate.addPos(pos1, origin, block.pos());
            if (!region.containsBlock(world, (BlockPos)pos1) || !config.pasteAir() && block.state().m_60734_() == Blocks.f_50016_ || !config.replaceSolid() && !placement.canReplaceAt(world, (BlockPos)pos1)) continue;
            if (block.pos().m_123342_() <= 0 && block.state().m_60838_((BlockGetter)reader.setState(block.state()), BlockPos.f_121853_)) {
                this.placeBase(world, setter, (BlockPos)pos1, pos2, block.state(), config.baseDepth());
            }
            setter.setBlock((BlockPos)pos1, block.state(), 2);
            buffer.record(i);
            placed = true;
        }
        if (config.updatePostPaste()) {
            buffer.reset();
            FeatureTemplate.updatePostPlacement(world, setter, buffer, blocks, origin, pos1, pos2);
        }
        return placed;
    }

    private <T extends TemplateContext> boolean pasteChecked(LevelAccessor world, T ctx, BlockPos origin, Mirror mirror, Rotation rotation, TemplatePlacement<T> placement, PasteConfig config) {
        Dimensions dimensions = (Dimensions)this.dimensions.get(mirror, rotation);
        TemplateRegion region = TEMPLATE_REGION.get().init(origin);
        TemplateBuffer buffer = TEMPLATE_BUFFER.get().init(world, origin, (Vec3i)dimensions.min(), (Vec3i)dimensions.max());
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        BlockInfo[] blocks = (BlockInfo[])this.template.get(mirror, rotation);
        BlockSetter setter = FeatureTemplate.setter(world, ctx);
        for (int i = 0; i < blocks.length; ++i) {
            BlockInfo block = blocks[i];
            FeatureTemplate.addPos(pos1, origin, block.pos());
            if (!region.containsBlock(world, (BlockPos)pos1)) continue;
            buffer.record(i, block, (BlockPos)pos1, placement, config);
        }
        boolean placed = false;
        BlockReader reader = new BlockReader();
        while (buffer.next()) {
            int i = buffer.nextIndex();
            BlockInfo block = blocks[i];
            FeatureTemplate.addPos(pos1, origin, block.pos());
            if (pos1.m_123342_() <= origin.m_123342_() && block.state().m_60838_((BlockGetter)reader.setState(block.state()), BlockPos.f_121853_)) {
                this.placeBase(world, setter, (BlockPos)pos1, pos2, block.state(), config.baseDepth());
                setter.setBlock((BlockPos)pos1, block.state(), 2);
                placed = true;
                continue;
            }
            if (buffer.test((BlockPos)pos1)) {
                placed = true;
                setter.setBlock((BlockPos)pos1, block.state(), 2);
                continue;
            }
            buffer.exclude(i);
        }
        if (config.updatePostPaste()) {
            buffer.reset();
            FeatureTemplate.updatePostPlacement(world, setter, buffer, blocks, origin, pos1, pos2);
        }
        return placed;
    }

    public Dimensions getDimensions(Mirror mirror, Rotation rotation) {
        return (Dimensions)this.dimensions.get(mirror, rotation);
    }

    private Paste getWorldGenPaste() {
        return new Paste(){

            @Override
            public <T extends TemplateContext> boolean apply(LevelAccessor world, T ctx, BlockPos origin, Mirror mirror, Rotation rotation, TemplatePlacement<T> placement, PasteConfig config) {
                return FeatureTemplate.this.pasteWorldGen(world, ctx, origin, mirror, rotation, placement, config);
            }
        };
    }

    private Paste getCheckedPaste() {
        return new Paste(){

            @Override
            public <T extends TemplateContext> boolean apply(LevelAccessor world, T ctx, BlockPos origin, Mirror mirror, Rotation rotation, TemplatePlacement<T> placement, PasteConfig config) {
                return FeatureTemplate.this.pasteChecked(world, ctx, origin, mirror, rotation, placement, config);
            }
        };
    }

    private Paste getUnCheckedPaste() {
        return new Paste(){

            @Override
            public <T extends TemplateContext> boolean apply(LevelAccessor world, T ctx, BlockPos origin, Mirror mirror, Rotation rotation, TemplatePlacement<T> placement, PasteConfig config) {
                return FeatureTemplate.this.pasteUnChecked(world, ctx, origin, mirror, rotation, placement, config);
            }
        };
    }

    private static void updatePostPlacement(LevelAccessor world, BlockSetter setter, BufferIterator iterator, BlockInfo[] blocks, BlockPos origin, BlockPos.MutableBlockPos pos1, BlockPos.MutableBlockPos pos2) {
        if (!iterator.isEmpty()) {
            while (iterator.next()) {
                int index = iterator.nextIndex();
                if (index < 0 || index >= blocks.length) continue;
                BlockInfo block = blocks[index];
                FeatureTemplate.addPos(pos1, origin, block.pos());
                for (Direction direction : directions) {
                    FeatureTemplate.updatePostPlacement(world, setter, pos1, pos2, direction);
                }
            }
        }
    }

    private static void updatePostPlacement(LevelAccessor world, BlockSetter setter, BlockPos.MutableBlockPos pos1, BlockPos.MutableBlockPos pos2, Direction direction) {
        BlockState result2;
        pos2.m_122190_((Vec3i)pos1).m_122175_(direction, 1);
        BlockState state1 = world.m_8055_((BlockPos)pos1);
        BlockState state2 = world.m_8055_((BlockPos)pos2);
        BlockState result1 = state1.m_60728_(direction, state2, world, (BlockPos)pos1, (BlockPos)pos2);
        if (result1 != state1) {
            setter.setBlock((BlockPos)pos1, result1, 19);
        }
        if ((result2 = state2.m_60728_(direction.m_122424_(), result1, world, (BlockPos)pos2, (BlockPos)pos1)) != state2) {
            setter.setBlock((BlockPos)pos2, result2, 19);
        }
    }

    private void placeBase(LevelAccessor world, BlockSetter setter, BlockPos pos, BlockPos.MutableBlockPos pos2, BlockState state, int depth) {
        for (int dy = 0; dy < depth; ++dy) {
            pos2.m_122190_((Vec3i)pos).m_122175_(Direction.DOWN, dy);
            if (world.m_8055_((BlockPos)pos2).m_60815_()) {
                return;
            }
            setter.setBlock((BlockPos)pos2, state, 2);
        }
    }

    public static BlockPos transform(BlockPos pos, Mirror mirror, Rotation rotation) {
        return StructureTemplate.m_74593_((BlockPos)pos, (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.f_121853_);
    }

    public static void addPos(BlockPos.MutableBlockPos pos, BlockPos a, BlockPos b) {
        pos.m_142451_(a.m_123341_() + b.m_123341_());
        pos.m_142448_(a.m_123342_() + b.m_123342_());
        pos.m_142443_(a.m_123343_() + b.m_123343_());
    }

    public static Optional<FeatureTemplate> load(InputStream data) {
        try {
            CompoundTag root = NbtIo.m_128939_((InputStream)data);
            if (!root.m_128441_("palette") || !root.m_128441_("blocks")) {
                return Optional.empty();
            }
            BlockState[] palette = FeatureTemplate.readPalette(root.m_128437_("palette", 10));
            BlockInfo[] blockInfos = FeatureTemplate.readBlocks(root.m_128437_("blocks", 10), palette);
            List<BlockInfo> blocks = FeatureTemplate.relativize(blockInfos);
            return Optional.of(new FeatureTemplate(blocks));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static BlockState[] readPalette(ListTag list) {
        BlockState[] palette = new BlockState[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            try {
                palette[i] = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)list.m_128728_(i));
                continue;
            }
            catch (Throwable t) {
                palette[i] = Blocks.f_50016_.m_49966_();
            }
        }
        return palette;
    }

    private static BlockInfo[] readBlocks(ListTag list, BlockState[] palette) {
        BlockInfo[] blocks = new BlockInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compound = list.m_128728_(i);
            BlockState state = palette[compound.m_128451_("state")];
            BlockPos pos = FeatureTemplate.readPos(compound.m_128437_("pos", 3));
            blocks[i] = new BlockInfo(pos, state);
        }
        return blocks;
    }

    private static List<BlockInfo> relativize(BlockInfo[] blocks) {
        BlockPos origin = null;
        int lowestSolid = Integer.MAX_VALUE;
        for (BlockInfo block : blocks) {
            if (!block.state().m_60815_()) continue;
            if (origin == null) {
                origin = block.pos();
                lowestSolid = block.pos().m_123342_();
                continue;
            }
            if (block.pos().m_123342_() < lowestSolid) {
                origin = block.pos();
                lowestSolid = block.pos().m_123342_();
                continue;
            }
            if (block.pos().m_123342_() != lowestSolid) continue;
            if (block.pos().m_123341_() < origin.m_123341_() && block.pos().m_123343_() <= origin.m_123343_()) {
                origin = block.pos();
                lowestSolid = block.pos().m_123342_();
                continue;
            }
            if (block.pos().m_123343_() >= origin.m_123343_() || block.pos().m_123341_() > origin.m_123341_()) continue;
            origin = block.pos();
            lowestSolid = block.pos().m_123342_();
        }
        if (origin == null) {
            return Arrays.asList(blocks);
        }
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>(blocks.length);
        for (BlockInfo in : blocks) {
            BlockPos pos = in.pos().m_121996_((Vec3i)origin);
            list.add(new BlockInfo(pos, in.state()));
        }
        return list;
    }

    private static BlockPos readPos(ListTag list) {
        int x = list.m_128763_(0);
        int y = list.m_128763_(1);
        int z = list.m_128763_(2);
        return new BlockPos(x, y, z);
    }

    public static interface BlockSetter {
        public void setBlock(BlockPos var1, BlockState var2, int var3);
    }

    public static interface PasteFunction {
        public <T extends TemplateContext> boolean paste(LevelAccessor var1, BlockPos var2, Mirror var3, Rotation var4, TemplatePlacement<T> var5, PasteConfig var6);
    }

    public static interface PasteProvider {
        public PasteFunction get(FeatureTemplate var1);
    }
}

