/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.placement.poisson;

import com.mojang.serialization.Codec;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public class BiomeVariance
implements Noise {
    public static final BiomeVariance NONE = new BiomeVariance(null, 0.0f){

        @Override
        public float compute(float x, float y, int seed) {
            return 1.0f;
        }
    };
    public static final float MIN_FADE = 0.025f;
    public static final float NO_SPREAD = 1.0f;
    private static final float SPREAD_VARIANCE = 1.0f;
    private static final float MAX_SPREAD = 2.0f;
    private final float fade;
    private final float range;
    private final Tile.Chunk chunk;

    public BiomeVariance(Tile.Chunk chunk, float fade) {
        this.chunk = chunk;
        this.fade = fade;
        this.range = fade - 0.025f;
    }

    @Override
    public float compute(float x, float z, int seed) {
        Cell cell = this.chunk.getCell((int)x, (int)z);
        float edge = 0.02f + cell.biomeRegionEdge;
        if (edge >= this.fade) {
            return 1.0f;
        }
        if (edge <= 0.025f) {
            return 2.0f;
        }
        float alpha = (edge - 0.025f) / this.range;
        alpha = 1.0f - alpha;
        return 1.0f + alpha * 1.0f;
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<BiomeVariance> codec() {
        throw new UnsupportedOperationException();
    }
}

