/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import raccoonman.reterraforged.world.worldgen.feature.placement.RTFPlacementModifiers;

class BlacklistDimensionFilter
extends PlacementFilter {
    public static final Codec<BlacklistDimensionFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256862_).listOf().fieldOf("blacklist").forGetter(filter -> filter.blacklist)).apply((Applicative)instance, BlacklistDimensionFilter::new));
    private List<ResourceKey<LevelStem>> blacklist;
    private List<ResourceKey<Level>> levelKeys;

    public BlacklistDimensionFilter(List<ResourceKey<LevelStem>> blacklist) {
        this.blacklist = blacklist;
        this.levelKeys = this.blacklist.stream().map(Registries::m_257551_).toList();
    }

    protected boolean m_213917_(PlacementContext ctx, RandomSource rand, BlockPos pos) {
        WorldGenLevel level = ctx.m_191831_();
        MinecraftServer server = level.m_7654_();
        for (ResourceKey<Level> key : this.levelKeys) {
            if (server.m_129880_(key) != level.m_6018_()) continue;
            return false;
        }
        return true;
    }

    public PlacementModifierType<BlacklistDimensionFilter> m_183327_() {
        return RTFPlacementModifiers.BLACKLIST_DIMENSION;
    }
}

