/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public class SwampSurfaceFeature
extends Feature<Config> {
    private static final Noise MATERIAL_NOISE = SwampSurfaceFeature.makeMaterialNoise();

    public SwampSurfaceFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> ctx) {
        Config config = (Config)ctx.m_159778_();
        BlockPos origin = ctx.m_159777_();
        ChunkPos chunkPos = new ChunkPos(origin);
        ChunkAccess chunk = ctx.m_159774_().m_46865_(origin);
        ChunkGenerator generator = ctx.m_159775_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int waterY = generator.m_6337_() - 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int worldX = chunkPos.m_151382_(x);
                int worldZ = chunkPos.m_151391_(z);
                int surfaceY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
                double noise = Biome.f_47433_.m_75449_((double)worldX * 0.25, (double)worldZ * 0.25, false);
                BlockState filler = SwampSurfaceFeature.getMaterial(worldX, waterY, worldZ, waterY, config);
                if (!chunk.m_203495_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)surfaceY), QuartPos.m_175400_((int)z)).m_203565_(Biomes.f_48207_)) continue;
                if (noise > 0.0) {
                    for (y = surfaceY; y >= surfaceY - 10; --y) {
                        pos.m_122178_(x, y, z);
                        if (chunk.m_8055_((BlockPos)pos).m_60795_()) continue;
                        if (y != waterY || chunk.m_6425_((BlockPos)pos).m_76178_()) break;
                        chunk.m_6978_((BlockPos)pos, filler, false);
                        break;
                    }
                }
                if ((y = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z)) > waterY) continue;
                chunk.m_6978_((BlockPos)pos.m_122178_(x, y, z), SwampSurfaceFeature.getMaterial(x, y, z, waterY, config), false);
            }
        }
        return false;
    }

    private static BlockState getMaterial(int x, int y, int z, int waterY, Config config) {
        float value = MATERIAL_NOISE.compute(x, z, 0);
        if ((double)value > 0.6) {
            if ((double)value < 0.75 && y < waterY) {
                return config.clayMaterial();
            }
            return config.gravelMaterial();
        }
        return config.dirtMaterial();
    }

    private static Noise makeMaterialNoise() {
        Noise base = Noises.simplex(23, 40, 2);
        return Noises.warpWhite(base, 213, 2, 4.0f);
    }

    public record Config(BlockState clayMaterial, BlockState gravelMaterial, BlockState dirtMaterial) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("clay_material").forGetter(Config::clayMaterial), (App)BlockState.f_61039_.fieldOf("gravel_material").forGetter(Config::gravelMaterial), (App)BlockState.f_61039_.fieldOf("dirt_material").forGetter(Config::dirtMaterial)).apply((Applicative)instance, Config::new));
    }
}

