/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Heightmap;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;
import raccoonman.reterraforged.world.worldgen.feature.ColumnDecorator;
import raccoonman.reterraforged.world.worldgen.feature.ErodeFeature;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public class DecorateSnowFeature
extends Feature<Config> {
    private static final float SNOW_ROCK_STEEPNESS = 0.45f;
    private static final float SNOW_ROCK_HEIGHT = 0.37254903f;
    private static final float MIN = DecorateSnowFeature.min((Property<Integer>)SnowLayerBlock.f_56581_);
    private static final float MAX = DecorateSnowFeature.max((Property<Integer>)SnowLayerBlock.f_56581_);

    public DecorateSnowFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> placeContext) {
        RTFRandomState rtfRandomState;
        GeneratorContext generatorContext;
        WorldGenLevel level = placeContext.m_159774_();
        RandomState randomState = level.m_6018_().m_7726_().m_214994_();
        RandomState randomState2 = randomState;
        if (randomState2 instanceof RTFRandomState && (generatorContext = (rtfRandomState = (RTFRandomState)randomState2).generatorContext()) != null) {
            ChunkGenerator generator = placeContext.m_159775_();
            ChunkPos chunkPos = new ChunkPos(placeContext.m_159777_());
            int chunkX = chunkPos.f_45578_;
            int chunkZ = chunkPos.f_45579_;
            ChunkAccess chunk = level.m_6325_(chunkX, chunkZ);
            Tile.Chunk tileChunk = generatorContext.cache.provideAtChunk(chunkX, chunkZ).getChunkReader(chunkX, chunkZ);
            Heightmap heightmap = generatorContext.generator.getHeightmap();
            Levels levels = heightmap.levels();
            Noise rand = Noises.white(heightmap.climate().randomSeed(), 1);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            Config config = (Config)placeContext.m_159778_();
            ErodeFeature.Config erodeConfig = config.erodeConfig();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int surfaceY;
                    Cell cell = tileChunk.getCell(x, z);
                    int scaledY = levels.scale(cell.height);
                    if (scaledY != (surfaceY = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z)) || scaledY < generator.m_6337_()) continue;
                    int worldX = chunkPos.m_151382_(x);
                    int worldZ = chunkPos.m_151391_(z);
                    pos.m_122178_(worldX, surfaceY, worldZ);
                    if (config.erode && (double)((Biome)level.m_204166_((BlockPos)pos).m_203334_()).m_47505_((BlockPos)pos) <= 0.25) {
                        float height;
                        float vModifier;
                        float var = -ColumnDecorator.sampleNoise((float)worldX, (float)worldZ, 16, 0);
                        float hNoise = rand.compute(worldX, worldZ, 4) * erodeConfig.heightModifier();
                        float sNoise = rand.compute(worldX, worldZ, 5) * erodeConfig.slopeModifier();
                        float steepness = cell.gradient + var + sNoise + (vModifier = cell.terrain == TerrainType.VOLCANO ? 0.15f : 0.0f);
                        if (DecorateSnowFeature.snowErosion(erodeConfig, worldX, worldZ, steepness, height = cell.height + var + hNoise + vModifier)) {
                            Predicate predicate = Heightmap.Types.MOTION_BLOCKING.m_64299_();
                            for (int dy = 2; dy > 0; --dy) {
                                pos.m_142448_(surfaceY + dy);
                                BlockState state = chunk.m_8055_((BlockPos)pos);
                                if (predicate.test(state) && !state.m_60713_(Blocks.f_50125_)) continue;
                                DecorateSnowFeature.erodeSnow(chunk, pos);
                            }
                        }
                    }
                    if (!config.smooth) continue;
                    pos.m_142448_(surfaceY + 1);
                    BlockState state = chunk.m_8055_((BlockPos)pos);
                    if (state.m_60795_()) {
                        pos.m_142448_(surfaceY);
                        state = chunk.m_8055_((BlockPos)pos);
                        if (state.m_60795_()) continue;
                    }
                    if (!state.m_60713_(Blocks.f_50125_)) continue;
                    DecorateSnowFeature.smoothSnow(chunk, pos, cell, levels, 0.0f);
                }
            }
            return true;
        }
        throw new IllegalStateException();
    }

    private static boolean snowErosion(ErodeFeature.Config erodeConfig, float x, float z, float steepness, float height) {
        return steepness > erodeConfig.rockSteepness() || steepness > 0.45f && height > 0.37254903f || steepness > erodeConfig.dirtSteepness() && height > ColumnDecorator.sampleNoise(x, z, erodeConfig.dirtVar(), erodeConfig.dirtMin());
    }

    private static void erodeSnow(ChunkAccess chunk, BlockPos.MutableBlockPos pos) {
        chunk.m_6978_((BlockPos)pos, Blocks.f_50016_.m_49966_(), false);
        if (pos.m_123342_() > 0) {
            pos.m_142448_(pos.m_123342_() - 1);
            BlockState below = chunk.m_8055_((BlockPos)pos);
            if (below.m_61138_((Property)GrassBlock.f_56637_)) {
                chunk.m_6978_((BlockPos)pos, (BlockState)below.m_61124_((Property)GrassBlock.f_56637_, (Comparable)Boolean.valueOf(false)), false);
            }
        }
    }

    private static void smoothSnow(ChunkAccess chunk, BlockPos.MutableBlockPos pos, Cell cell, Levels levels, float min) {
        float height = cell.height * (float)levels.worldHeight;
        float depth = DecorateSnowFeature.getDepth(height);
        if (depth > min) {
            int level = DecorateSnowFeature.getLevel(depth);
            BlockState layer = DecorateSnowFeature.getState(level);
            if (layer.m_60713_(Blocks.f_50016_)) {
                return;
            }
            chunk.m_6978_((BlockPos)pos, layer, false);
            DecorateSnowFeature.fixBaseBlock(chunk, (BlockPos)pos, layer, level);
        }
    }

    private static void fixBaseBlock(ChunkAccess chunk, BlockPos pos, BlockState layerMaterial, int level) {
        BlockPos pos1;
        BlockState below;
        if (level > 1 && layerMaterial.m_60713_(Blocks.f_50125_) && (below = chunk.m_8055_(pos1 = pos.m_7495_())).m_60734_() instanceof SpreadingSnowyDirtBlock) {
            chunk.m_6978_(pos1, Blocks.f_50493_.m_49966_(), false);
        }
    }

    private static BlockState getState(int level) {
        if ((float)level < MIN) {
            return Blocks.f_50016_.m_49966_();
        }
        if ((float)level >= MAX) {
            return Blocks.f_50127_.m_49966_();
        }
        return (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(level));
    }

    private static int getLevel(float depth) {
        if (depth > 1.0f) {
            depth = DecorateSnowFeature.getDepth(depth);
        } else if (depth < 0.0f) {
            depth = 0.0f;
        }
        return NoiseUtil.round(depth * MAX);
    }

    private static float getDepth(float height) {
        return height - (float)((int)height);
    }

    private static int min(Property<Integer> property) {
        return property.m_6908_().stream().min(Integer::compareTo).orElse(0);
    }

    private static int max(Property<Integer> property) {
        return property.m_6908_().stream().max(Integer::compareTo).orElse(0);
    }

    public record Config(boolean erode, boolean smooth, ErodeFeature.Config erodeConfig) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("erode").forGetter(Config::erode), (App)Codec.BOOL.fieldOf("smooth").forGetter(Config::smooth), (App)ErodeFeature.Config.CODEC.fieldOf("erode_config").forGetter(Config::erodeConfig)).apply((Applicative)instance, Config::new));
    }
}

