/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.densityfunction;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;

public final class LinearSplineFunction
extends Record
implements DensityFunction {
    private final DensityFunction input;
    private final List<Pair<Double, DensityFunction>> points;
    private final double minValue;
    private final double maxValue;
    public static final Codec<LinearSplineFunction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("input").forGetter(LinearSplineFunction::input), (App)ExtraCodecs.m_144637_((Codec)Codec.pair((Codec)Codec.DOUBLE, (Codec)DensityFunction.f_208218_).listOf()).fieldOf("points").forGetter(LinearSplineFunction::points)).apply((Applicative)instance, LinearSplineFunction::new));

    public LinearSplineFunction(DensityFunction input, List<Pair<Double, DensityFunction>> points) {
        this(input, points, LinearSplineFunction.min(points), LinearSplineFunction.max(points));
    }

    public LinearSplineFunction(DensityFunction input, List<Pair<Double, DensityFunction>> points, double minValue, double maxValue) {
        this.input = input;
        this.points = points;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public double m_207386_(DensityFunction.FunctionContext ctx) {
        double input = this.input.m_207386_(ctx);
        int pointCount = this.points.size();
        Pair<Double, DensityFunction> first = this.points.get(0);
        if (input <= (Double)first.getFirst()) {
            return ((DensityFunction)first.getSecond()).m_207386_(ctx);
        }
        Pair<Double, DensityFunction> last = this.points.get(pointCount - 1);
        if (input >= (Double)last.getFirst()) {
            return ((DensityFunction)last.getSecond()).m_207386_(ctx);
        }
        int index = Mth.m_14049_((int)0, (int)pointCount, i -> input < (Double)this.points.get(i).getFirst()) - 1;
        Pair<Double, DensityFunction> start = this.points.get(index);
        Pair<Double, DensityFunction> end = this.points.get(index + 1);
        double min = (Double)start.getFirst();
        double max = (Double)end.getFirst();
        double from = ((DensityFunction)start.getSecond()).m_207386_(ctx);
        double to = ((DensityFunction)end.getSecond()).m_207386_(ctx);
        double lerp = NoiseUtil.map(input, 0.0, 1.0, min, max);
        lerp = NoiseUtil.clamp(lerp, 0.0, 1.0);
        return NoiseUtil.lerp(from, to, lerp);
    }

    public void m_207362_(double[] array, DensityFunction.ContextProvider ctxProvider) {
        ctxProvider.m_207207_(array, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new LinearSplineFunction(this.input.m_207456_(visitor), this.points.stream().map(point -> Pair.of((Object)((Double)point.getFirst()), (Object)visitor.m_214017_((DensityFunction)point.getSecond()))).toList()));
    }

    public KeyDispatchDataCodec<LinearSplineFunction> m_214023_() {
        return new KeyDispatchDataCodec(CODEC);
    }

    public static Builder builder(DensityFunction input) {
        return new Builder(input);
    }

    private static float min(List<Pair<Double, DensityFunction>> points) {
        return (float)points.stream().map(Pair::getSecond).mapToDouble(DensityFunction::m_207402_).min().orElseThrow();
    }

    private static float max(List<Pair<Double, DensityFunction>> points) {
        return (float)points.stream().map(Pair::getSecond).mapToDouble(DensityFunction::m_207401_).max().orElseThrow();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LinearSplineFunction.class, "input;points;minValue;maxValue", "input", "points", "minValue", "maxValue"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LinearSplineFunction.class, "input;points;minValue;maxValue", "input", "points", "minValue", "maxValue"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LinearSplineFunction.class, "input;points;minValue;maxValue", "input", "points", "minValue", "maxValue"}, this, o);
    }

    public DensityFunction input() {
        return this.input;
    }

    public List<Pair<Double, DensityFunction>> points() {
        return this.points;
    }

    public double m_207402_() {
        return this.minValue;
    }

    public double m_207401_() {
        return this.maxValue;
    }

    public static class Builder {
        private DensityFunction input;
        private List<Pair<Double, DensityFunction>> points;

        public Builder(DensityFunction input) {
            this.input = input;
            this.points = new ArrayList<Pair<Double, DensityFunction>>();
        }

        public Builder addPoint(double point, double value) {
            return this.addPoint(point, DensityFunctions.m_208264_((double)value));
        }

        public Builder addPoint(double point, DensityFunction value) {
            this.points.add((Pair<Double, DensityFunction>)Pair.of((Object)point, (Object)value));
            return this;
        }

        public LinearSplineFunction build() {
            return new LinearSplineFunction(this.input, (List<Pair<Double, DensityFunction>>)ImmutableList.copyOf(this.points));
        }
    }
}

