/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.Nullable;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.biome.Continentalness;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Heightmap;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.WorldLookup;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainCategory;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.densityfunction.MarkerFunction;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.util.PosUtil;

public record CellSampler(Supplier<WorldLookup> deferredLookup, Field field) implements MarkerFunction.Mapped
{
    private static final ThreadLocal<Cache2d> CELL = ThreadLocal.withInitial(Cache2d::new);

    public double m_207386_(DensityFunction.FunctionContext ctx) {
        WorldLookup worldLookup = this.deferredLookup.get();
        Cell cell = CELL.get().getAndUpdate(worldLookup, ctx.m_207115_(), ctx.m_207113_(), true);
        return this.field.read(cell, worldLookup.getHeightmap());
    }

    public double m_207402_() {
        return 0.0;
    }

    public double m_207401_() {
        return 1.0;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Field implements StringRepresentable
    {
        HEIGHT("height"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.height;
            }
        }
        ,
        CONTINENT("continent"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                Levels levels = heightmap.levels();
                WorldSettings.ControlPoints controlPoints = heightmap.controlPoints();
                float deepOcean = controlPoints.deepOcean;
                float shallowOcean = controlPoints.shallowOcean;
                float beach = controlPoints.beach;
                float coast = controlPoints.coast;
                float inland = controlPoints.inland;
                if (cell.terrain == TerrainType.MUSHROOM_FIELDS) {
                    return Continentalness.MUSHROOM_FIELDS.mid();
                }
                if (cell.terrain.isDeepOcean()) {
                    float alpha = NoiseUtil.clamp(cell.continentEdge, 0.0f, deepOcean);
                    alpha = NoiseUtil.lerp(alpha, 0.0f, deepOcean, 0.0f, 1.0f);
                    return NoiseUtil.lerp(Continentalness.DEEP_OCEAN.min() + 0.05f, Continentalness.DEEP_OCEAN.max(), alpha);
                }
                if (cell.terrain.isShallowOcean()) {
                    float alpha = NoiseUtil.clamp(cell.continentEdge, deepOcean, shallowOcean);
                    alpha = NoiseUtil.lerp(alpha, deepOcean, shallowOcean, 0.0f, 0.98f);
                    return NoiseUtil.lerp(Continentalness.OCEAN.min(), Continentalness.OCEAN.max(), alpha);
                }
                if (cell.terrain.getDelegate() == TerrainCategory.BEACH && cell.height + cell.beachNoise < levels.water(5)) {
                    float alpha = NoiseUtil.clamp(cell.continentEdge, shallowOcean, beach);
                    alpha = NoiseUtil.lerp(alpha, shallowOcean, beach, 0.0f, 1.0f);
                    return NoiseUtil.lerp(Continentalness.COAST.min(), Continentalness.COAST.max(), alpha);
                }
                float alpha = NoiseUtil.clamp(cell.continentEdge, beach, inland);
                alpha = NoiseUtil.lerp(alpha, beach, inland, 0.0f, 1.0f);
                return NoiseUtil.lerp(Continentalness.NEAR_INLAND.mid(), Continentalness.FAR_INLAND.max(), alpha);
            }
        }
        ,
        EROSION("erosion"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.erosion;
            }
        }
        ,
        WEIRDNESS("weirdness"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.weirdness;
            }
        }
        ,
        BIOME_REGION("biome_region"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.biomeRegionId;
            }
        }
        ,
        TEMPERATURE("temperature"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.temperature;
            }
        }
        ,
        MOISTURE("moisture"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.moisture;
            }
        }
        ,
        GRADIENT("gradient"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.gradient;
            }
        }
        ,
        HEIGHT_EROSION("height_erosion"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.heightErosion;
            }
        }
        ,
        SEDIMENT("sediment"){

            @Override
            public float read(Cell cell, Heightmap heightmap) {
                return cell.sediment;
            }
        };

        public static final Codec<Field> CODEC;
        private String name;

        private Field(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public abstract float read(Cell var1, Heightmap var2);

        static {
            CODEC = StringRepresentable.m_216439_(Field::values);
        }
    }

    public static class Cache2d {
        private long lastPos = Long.MAX_VALUE;
        private Cell cell = new Cell();

        public Cell getAndUpdate(WorldLookup lookup, int blockX, int blockZ, boolean sampleClimate) {
            long packedPos = PosUtil.pack(blockX = QuartPos.m_175402_((int)QuartPos.m_175400_((int)blockX)), blockZ = QuartPos.m_175402_((int)QuartPos.m_175400_((int)blockZ)));
            if (this.lastPos != packedPos) {
                lookup.applyCell(this.cell.reset(), blockX, blockZ, false, sampleClimate);
                this.lastPos = packedPos;
            }
            return this.cell;
        }
    }

    public record Marker(Field field) implements MarkerFunction
    {
        public static final Codec<Marker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Field.CODEC.fieldOf("field").forGetter(Marker::field)).apply((Applicative)instance, Marker::new));

        public KeyDispatchDataCodec<Marker> m_214023_() {
            return new KeyDispatchDataCodec(CODEC);
        }
    }

    public class CacheChunk
    implements MarkerFunction.Mapped {
        @Nullable
        private Tile.Chunk chunk;
        private Cache2d cache2d;
        private int chunkX;
        private int chunkZ;

        public CacheChunk(@Nullable Tile.Chunk chunk, Cache2d cache2d, int chunkX, int chunkZ) {
            this.chunk = chunk;
            this.cache2d = cache2d != null ? cache2d : new Cache2d();
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public double m_207386_(DensityFunction.FunctionContext ctx) {
            int blockX = ctx.m_207115_();
            int blockZ = ctx.m_207113_();
            int chunkX = SectionPos.m_123171_((int)blockX);
            int chunkZ = SectionPos.m_123171_((int)blockZ);
            WorldLookup worldLookup = CellSampler.this.deferredLookup.get();
            Cell cell = this.chunk != null && this.chunkX == chunkX && this.chunkZ == chunkZ ? this.chunk.getCell(blockX, blockZ) : this.cache2d.getAndUpdate(worldLookup, blockX, blockZ, false);
            return CellSampler.this.field.read(cell, worldLookup.getHeightmap());
        }

        public double m_207402_() {
            return CellSampler.this.m_207402_();
        }

        public double m_207401_() {
            return CellSampler.this.m_207401_();
        }
    }
}

