/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.terrain.region;

import java.util.LinkedList;
import java.util.List;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.CellPopulator;
import raccoonman.reterraforged.world.worldgen.cell.terrain.populator.WeightedPopulator;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;

public class RegionSelector
implements CellPopulator {
    private int maxIndex;
    private CellPopulator[] nodes;

    public RegionSelector(List<CellPopulator> populators) {
        this.nodes = RegionSelector.getWeightedArray(populators);
        this.maxIndex = this.nodes.length - 1;
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        this.get(cell.terrainRegionId).apply(cell, x, y);
    }

    public CellPopulator get(float identity) {
        int index = NoiseUtil.round(identity * (float)this.maxIndex);
        return this.nodes[index];
    }

    private static CellPopulator[] getWeightedArray(List<CellPopulator> modules) {
        float smallest = Float.MAX_VALUE;
        for (CellPopulator p : modules) {
            if (p instanceof WeightedPopulator) {
                WeightedPopulator tp = (WeightedPopulator)((Object)p);
                if (tp.weight() == 0.0f) continue;
                smallest = Math.min(smallest, tp.weight());
                continue;
            }
            smallest = Math.min(smallest, 1.0f);
        }
        if (smallest == Float.MAX_VALUE) {
            return (CellPopulator[])modules.toArray(CellPopulator[]::new);
        }
        LinkedList<CellPopulator> result = new LinkedList<CellPopulator>();
        for (CellPopulator p2 : modules) {
            int count;
            if (p2 instanceof WeightedPopulator) {
                WeightedPopulator tp2 = (WeightedPopulator)((Object)p2);
                if (tp2.weight() == 0.0f) continue;
                count = Math.round(tp2.weight() / smallest);
            } else {
                count = Math.round(1.0f / smallest);
            }
            while (count-- > 0) {
                result.add(p2);
            }
        }
        if (result.isEmpty()) {
            return (CellPopulator[])modules.toArray(CellPopulator[]::new);
        }
        return (CellPopulator[])result.toArray(CellPopulator[]::new);
    }
}

