/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.terrain;

import raccoonman.reterraforged.world.worldgen.cell.terrain.Terrain;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainCategory;

public class CompositeTerrain
extends Terrain {
    private boolean flat;
    private float erosion;

    CompositeTerrain(int id, Terrain a, Terrain b) {
        super(id, a.getName() + "-" + b.getName(), CompositeTerrain.getDominant(a, b));
        this.flat = a.isFlat() && b.isFlat();
        this.erosion = Math.min(a.erosionModifier(), b.erosionModifier());
    }

    @Override
    public float erosionModifier() {
        return this.erosion;
    }

    @Override
    public boolean isFlat() {
        return this.flat;
    }

    private static Terrain getDominant(Terrain a, Terrain b) {
        TerrainCategory typeB;
        TerrainCategory typeA = a.getCategory();
        TerrainCategory dom = typeA.getDominant(typeB = a.getCategory());
        if (dom == typeA) {
            return a;
        }
        return b;
    }
}

