/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.rivermap.wetland;

import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Line;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.util.Boundsf;

public class Wetland {
    private NoiseUtil.Vec2f a;
    private NoiseUtil.Vec2f b;
    private float radius;
    private float radius2;
    private float bed;
    private float banks;
    private float moundMin;
    private float moundMax;
    private float moundVariance;
    private Noise moundShape;
    private Noise moundHeight;
    private Noise terrainEdge;

    public Wetland(int seed, NoiseUtil.Vec2f a, NoiseUtil.Vec2f b, float radius, Levels levels) {
        this.a = a;
        this.b = b;
        this.radius = radius;
        this.radius2 = radius * radius;
        this.bed = levels.water(-1) - 0.5f / (float)levels.worldHeight;
        this.banks = levels.ground(3);
        this.moundMin = levels.water(1);
        this.moundMax = levels.water(2);
        this.moundVariance = this.moundMax - this.moundMin;
        Noise moundShape = Noises.perlin(++seed, 10, 1);
        moundShape = Noises.clamp(moundShape, 0.3f, 0.6f);
        this.moundShape = moundShape = Noises.map(moundShape, 0.0f, 1.0f);
        Noise moundHeight = Noises.simplex(++seed, 20, 1);
        moundHeight = Noises.clamp(moundHeight, 0.0f, 0.3f);
        this.moundHeight = moundHeight = Noises.map(moundHeight, 0.0f, 1.0f);
        Noise terrainEdge = Noises.perlin(++seed, 8, 1);
        terrainEdge = Noises.clamp(terrainEdge, 0.2f, 0.8f);
        this.terrainEdge = terrainEdge = Noises.map(terrainEdge, 0.0f, 0.9f);
    }

    public void apply(Cell cell, float rx, float rz, float x, float z) {
        if (cell.height < this.bed) {
            return;
        }
        float t = Line.distanceOnLine(rx, rz, this.a.x(), this.a.y(), this.b.x(), this.b.y());
        float d2 = Wetland.getDistance2(rx, rz, this.a.x(), this.a.y(), this.b.x(), this.b.y(), t);
        if (d2 > this.radius2) {
            return;
        }
        float dist = 1.0f - d2 / this.radius2;
        if (dist <= 0.0f) {
            return;
        }
        float valleyAlpha = NoiseUtil.map(dist, 0.0f, 0.65f, 0.65f);
        if (cell.height > this.banks) {
            cell.height = NoiseUtil.lerp(cell.height, this.banks, valleyAlpha);
        }
        float poolsAlpha = NoiseUtil.map(dist, 0.65f, 0.7f, 0.050000012f);
        if (cell.height > this.bed && cell.height <= this.banks) {
            cell.height = NoiseUtil.lerp(cell.height, this.bed, poolsAlpha);
        }
        if (poolsAlpha >= 1.0f) {
            cell.erosionMask = true;
        }
        if (dist > 0.65f && poolsAlpha > this.terrainEdge.compute(x, z, 0)) {
            cell.terrain = TerrainType.WETLAND;
        }
        if (cell.height >= this.bed && cell.height < this.moundMax) {
            float shapeAlpha = this.moundShape.compute(x, z, 0) * poolsAlpha;
            float mounds = this.moundMin + this.moundHeight.compute(x, z, 0) * this.moundVariance;
            cell.height = NoiseUtil.lerp(cell.height, mounds, shapeAlpha);
        }
        cell.riverMask = Math.min(cell.riverMask, 1.0f - valleyAlpha);
    }

    public void recordBounds(Boundsf.Builder builder) {
        builder.record(Math.min(this.a.x(), this.b.x()) - this.radius, Math.min(this.a.y(), this.b.y()) - this.radius);
        builder.record(Math.max(this.a.x(), this.b.x()) + this.radius, Math.max(this.a.y(), this.b.y()) + this.radius);
    }

    private static float getDistance2(float x, float y, float ax, float ay, float bx, float by, float t) {
        if (t <= 0.0f) {
            return Line.distSq(x, y, ax, ay);
        }
        if (t >= 1.0f) {
            return Line.distSq(x, y, bx, by);
        }
        float px = ax + t * (bx - ax);
        float py = ay + t * (by - ay);
        return Line.distSq(x, y, px, py);
    }
}

