/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.rivermap.lake;

import raccoonman.reterraforged.data.worldgen.preset.settings.RiverSettings;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;

public class LakeConfig {
    public float depth;
    public float chance;
    public float sizeMin;
    public float sizeMax;
    public float sizeRange;
    public float bankMin;
    public float bankMax;
    public float distanceMin;
    public float distanceMax;

    private LakeConfig(Builder builder) {
        this.depth = builder.depth;
        this.chance = builder.chance;
        this.sizeMin = builder.sizeMin;
        this.sizeMax = builder.sizeMax;
        this.sizeRange = this.sizeMax - this.sizeMin;
        this.bankMin = builder.bankMin;
        this.bankMax = builder.bankMax;
        this.distanceMin = builder.distanceMin;
        this.distanceMax = builder.distanceMax;
    }

    public static LakeConfig of(RiverSettings.Lake settings, Levels levels) {
        Builder builder = new Builder();
        builder.chance = settings.chance;
        builder.sizeMin = settings.sizeMin;
        builder.sizeMax = settings.sizeMax;
        builder.depth = levels.water(-settings.depth);
        builder.distanceMin = settings.minStartDistance;
        builder.distanceMax = settings.maxStartDistance;
        builder.bankMin = levels.water(settings.minBankHeight);
        builder.bankMax = levels.water(settings.maxBankHeight);
        return new LakeConfig(builder);
    }

    public static class Builder {
        public float chance;
        public float depth = 10.0f;
        public float sizeMin = 30.0f;
        public float sizeMax = 100.0f;
        public float bankMin = 1.0f;
        public float bankMax = 8.0f;
        public float distanceMin = 0.025f;
        public float distanceMax = 0.05f;
    }
}

