/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.heightmap;

import net.minecraft.core.HolderGetter;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseData;
import raccoonman.reterraforged.data.worldgen.preset.PresetTerrainTypeNoise;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.TerrainSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.biome.Erosion;
import raccoonman.reterraforged.world.worldgen.biome.Weirdness;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.CellPopulator;
import raccoonman.reterraforged.world.worldgen.cell.climate.Climate;
import raccoonman.reterraforged.world.worldgen.cell.continent.Continent;
import raccoonman.reterraforged.world.worldgen.cell.continent.ContinentLerper2;
import raccoonman.reterraforged.world.worldgen.cell.continent.ContinentLerper3;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.RegionConfig;
import raccoonman.reterraforged.world.worldgen.cell.rivermap.Rivermap;
import raccoonman.reterraforged.world.worldgen.cell.terrain.Blender;
import raccoonman.reterraforged.world.worldgen.cell.terrain.Populators;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.cell.terrain.populator.IslandPopulator;
import raccoonman.reterraforged.world.worldgen.cell.terrain.populator.TerrainPopulator;
import raccoonman.reterraforged.world.worldgen.cell.terrain.populator.VolcanoPopulator;
import raccoonman.reterraforged.world.worldgen.cell.terrain.provider.TerrainProvider;
import raccoonman.reterraforged.world.worldgen.cell.terrain.region.RegionLerper;
import raccoonman.reterraforged.world.worldgen.cell.terrain.region.RegionModule;
import raccoonman.reterraforged.world.worldgen.cell.terrain.region.RegionSelector;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.EdgeFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.util.Seed;

public record Heightmap(CellPopulator terrain, CellPopulator region, Continent continent, Climate climate, Levels levels, WorldSettings.ControlPoints controlPoints, float terrainFrequency, Noise beachNoise) {
    public void apply(Cell cell, float x, float z, boolean applyClimate) {
        this.applyTerrain(cell, x, z);
        this.applyRivers(cell, x, z, this.continent.getRivermap(cell));
        this.applyClimate(cell, x, z, applyClimate);
    }

    public void applyTerrain(Cell cell, float x, float z) {
        cell.terrain = TerrainType.FLATS;
        cell.beachNoise = this.beachNoise.compute(x, z, 0);
        this.continent.apply(cell, x, z);
        this.region.apply(cell, x, z);
        this.terrain.apply(cell, x * this.terrainFrequency, z * this.terrainFrequency);
    }

    public void applyRivers(Cell cell, float x, float z, Rivermap rivermap) {
        rivermap.apply(cell, x, z);
        VolcanoPopulator.modifyVolcanoType(cell, this.levels);
    }

    public void applyClimate(Cell cell, float x, float z, boolean applyClimate) {
        float riverValleyThreshold = 0.675f;
        if (cell.riverMask < riverValleyThreshold) {
            cell.erosion = 0.445f;
            cell.weirdness = 0.34f;
        }
        if (cell.terrain.isRiver()) {
            cell.erosion = -0.05f;
            cell.weirdness = -0.03f;
        }
        if (cell.terrain.isLake() && cell.height < this.levels.water) {
            cell.erosion = Erosion.LEVEL_4.mid();
            cell.weirdness = -0.03f;
        }
        if (cell.terrain.isWetland()) {
            cell.erosion = Erosion.LEVEL_6.mid();
            cell.weirdness = Weirdness.VALLEY.mid();
        }
        this.climate.apply(cell, x, z, applyClimate);
        if (cell.riverMask >= riverValleyThreshold && cell.macroBiomeId > 0.5f) {
            cell.weirdness = -cell.weirdness;
        }
    }

    public static Heightmap make(GeneratorContext ctx) {
        HolderGetter<Noise> noiseLookup = ctx.noiseLookup;
        Preset preset = ctx.preset;
        WorldSettings world = ctx.preset.world();
        WorldSettings.ControlPoints controlPoints = world.controlPoints;
        TerrainSettings terrainSettings = preset.terrain();
        TerrainSettings.General general = terrainSettings.general;
        float globalVerticalScale = general.globalVerticalScale;
        Seed regionWarp = ctx.seed.offset(8934);
        int regionWarpScale = 400;
        int regionWarpStrength = 200;
        RegionConfig regionConfig = new RegionConfig(ctx.seed.root() + 789124, general.terrainRegionSize, Noises.simplex(regionWarp.next(), regionWarpScale, 1), Noises.simplex(regionWarp.next(), regionWarpScale, 1), regionWarpStrength);
        Levels levels = ctx.levels;
        float terrainFrequency = 1.0f / terrainSettings.general.globalHorizontalScale;
        RegionModule region = new RegionModule(regionConfig);
        Seed mountainSeed = ctx.seed.offset(general.terrainSeedOffset);
        Noise mountainShape = Noises.worleyEdge(mountainSeed.next(), general.legacyMountainScaling ? 1000 : Math.round(1000.0f * terrainSettings.mountains.horizontalScale * 2.25f), EdgeFunction.DISTANCE_2_ADD, DistanceFunction.EUCLIDEAN);
        mountainShape = Noises.warpPerlin(mountainShape, mountainSeed.next(), 333, 2, 250.0f);
        mountainShape = Noises.curve(mountainShape, Interpolation.CURVE3);
        mountainShape = Noises.clamp(mountainShape, 0.0f, 0.9f);
        mountainShape = Noises.map(mountainShape, 0.0f, 1.0f);
        Noise ground = PresetNoiseData.getNoise(noiseLookup, PresetTerrainTypeNoise.GROUND);
        RegionSelector terrainRegions = new RegionSelector(TerrainProvider.generateTerrain(ctx.seed, terrainSettings, regionConfig, levels, noiseLookup));
        TerrainPopulator terrainRegionBorders = Populators.makeBorder(ctx.seed, ground, terrainSettings.plains, terrainSettings.steppe, globalVerticalScale);
        RegionLerper terrainBlend = new RegionLerper(terrainRegionBorders, terrainRegions);
        TerrainPopulator mountains = Populators.makeMountainChain(mountainSeed, ground, terrainSettings.mountains, terrainSettings.general.legacyMountainScaling ? 1.0f : terrainSettings.mountains.horizontalScale * 2.25f, terrainSettings.general.legacyMountainScaling ? globalVerticalScale : globalVerticalScale * terrainSettings.mountains.verticalScale, general.fancyMountains, general.legacyMountainScaling);
        Continent continent = world.continent.continentType.create(ctx.seed, ctx);
        Climate climate = Climate.make(continent, ctx);
        Blender land = new Blender(mountainShape, terrainBlend, mountains, 0.3f, 0.8f, 0.575f);
        CellPopulator deepOcean = Populators.makeDeepOcean(ctx.seed.next(), levels.water);
        CellPopulator shallowOcean = Populators.makeShallowOcean(ctx.levels);
        CellPopulator coast = Populators.makeCoast(ctx.levels);
        ContinentLerper3 oceans = new ContinentLerper3(deepOcean, shallowOcean, coast, controlPoints.deepOcean, controlPoints.shallowOcean, controlPoints.coast);
        ContinentLerper2 terrain = new ContinentLerper2(oceans, land, controlPoints.shallowOcean, controlPoints.inland);
        Noise beachNoise = Noises.perlin2(ctx.seed.next(), 20, 1);
        beachNoise = Noises.mul(beachNoise, ctx.levels.scale(5));
        return new Heightmap(terrain, region, continent, climate, levels, controlPoints, terrainFrequency, beachNoise);
    }

    private static CellPopulator makeIslandPopulator(GeneratorContext ctx, WorldSettings.ControlPoints controlPoints, CellPopulator oceans) {
        return new IslandPopulator(ctx.levels, oceans, controlPoints.islandCoast, controlPoints.islandInland);
    }
}

