/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.continent.fancy;

import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.continent.Continent;
import raccoonman.reterraforged.world.worldgen.cell.continent.fancy.FancyContinent;
import raccoonman.reterraforged.world.worldgen.cell.rivermap.RiverCache;
import raccoonman.reterraforged.world.worldgen.cell.rivermap.Rivermap;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domain;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domains;
import raccoonman.reterraforged.world.worldgen.util.PosUtil;
import raccoonman.reterraforged.world.worldgen.util.Seed;

public class FancyContinentGenerator
implements Continent {
    private float frequency;
    private Domain warp;
    private FancyContinent source;
    private RiverCache riverCache;

    public FancyContinentGenerator(Seed seed, GeneratorContext context) {
        WorldSettings settings = context.preset.world();
        int warpScale = settings.continent.continentScale / 2;
        float warpStrength = (float)warpScale * 0.4f;
        this.source = new FancyContinent(seed.next(), 4, 0.2f, context, this);
        this.frequency = 1.0f / (float)settings.continent.continentScale;
        this.riverCache = new RiverCache(this.source);
        Domain warp = Domains.domainSimplex(seed.next(), warpScale, 2, warpStrength);
        warp = Domains.add(warp, Domains.domainPerlin(seed.next(), 80, 2, 40.0f));
        this.warp = warp = Domains.add(warp, Domains.domainPerlin(seed.next(), 20, 1, 15.0f));
    }

    public FancyContinent getSource() {
        return this.source;
    }

    @Override
    public Rivermap getRivermap(int x, int y) {
        return this.riverCache.getRivers(x, y);
    }

    @Override
    public float getEdgeValue(float x, float y) {
        float px = this.warp.getX(x, y, 0);
        float py = this.warp.getZ(x, y, 0);
        return this.source.getEdgeValue(px *= this.frequency, py *= this.frequency, 0);
    }

    @Override
    public float getLandValue(float x, float y) {
        float px = this.warp.getX(x, y, 0);
        float py = this.warp.getZ(x, y, 0);
        float value = this.source.getLandValue(px *= this.frequency, py *= this.frequency);
        return NoiseUtil.map(value, 0.2f, 0.4f, 0.2f);
    }

    @Override
    public long getNearestCenter(float x, float y) {
        long min = this.source.getMin();
        long max = this.source.getMax();
        float width = PosUtil.unpackLeftf(max) - PosUtil.unpackLeftf(min);
        float height = PosUtil.unpackRightf(max) - PosUtil.unpackRightf(min);
        float cx = width * 0.5f;
        float cz = height * 0.5f;
        int centerX = (int)(cx / this.frequency);
        int centerZ = (int)(cz / this.frequency);
        return PosUtil.pack(centerX, centerZ);
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        cell.continentX = 0;
        cell.continentZ = 0;
        cell.continentId = 0.0f;
        cell.continentEdge = this.getEdgeValue(x, y);
    }
}

