/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.climate;

import net.minecraft.core.HolderGetter;
import raccoonman.reterraforged.data.worldgen.preset.PresetClimateNoise;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseData;
import raccoonman.reterraforged.data.worldgen.preset.settings.ClimateSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.climate.ClimateModule;
import raccoonman.reterraforged.world.worldgen.cell.continent.Continent;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public record Climate(int randomSeed, Noise offsetX, Noise offsetZ, int offsetDistance, Levels levels, ClimateModule biomeNoise) {
    public void apply(Cell cell, float x, float z, boolean applyClimate) {
        this.biomeNoise.apply(cell, x, z, x, z, true);
        float edgeBlend = 0.4f;
        if (cell.height <= this.levels.water) {
            if (cell.terrain == TerrainType.COAST) {
                cell.terrain = TerrainType.SHALLOW_OCEAN;
            }
        } else if (cell.biomeRegionEdge < edgeBlend || cell.terrain == TerrainType.MOUNTAIN_CHAIN) {
            float modifier = 1.0f - NoiseUtil.map(cell.biomeRegionEdge, 0.0f, edgeBlend, edgeBlend);
            float distance = (float)this.offsetDistance * modifier;
            float dx = this.offsetX.compute(x, z, 0) * distance;
            float dz = this.offsetZ.compute(x, z, 0) * distance;
            float ox = x;
            float oz = z;
            this.biomeNoise.apply(cell, x += dx, z += dz, ox, oz, false);
        }
    }

    public static Climate make(Continent continent, GeneratorContext context) {
        HolderGetter<Noise> noiseLookup = context.noiseLookup;
        Preset preset = context.preset;
        WorldSettings worldSettings = preset.world();
        ClimateSettings climateSettings = preset.climate();
        ClimateModule biomeNoise = new ClimateModule(context.seed, continent, worldSettings.controlPoints, climateSettings, context.levels);
        Levels levels = context.levels;
        int randSeed = context.seed.next();
        Noise biomeEdgeShape = PresetNoiseData.getNoise(noiseLookup, PresetClimateNoise.BIOME_EDGE_SHAPE);
        Noise offsetX = Noises.shiftSeed(biomeEdgeShape, context.seed.next());
        Noise offsetZ = Noises.shiftSeed(biomeEdgeShape, context.seed.next());
        int offsetDistance = climateSettings.biomeEdgeShape.strength;
        return new Climate(randSeed, offsetX, offsetZ, offsetDistance, levels, biomeNoise);
    }
}

