/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import raccoonman.reterraforged.platform.forge.ConfigUtilImpl;

public class ConfigUtil {
    public static final Path RTF_CONFIG_PATH = ConfigUtil.getConfigPath().resolve("reterraforged");
    public static final Path LEGACY_CONFIG_PATH = ConfigUtil.getConfigPath().resolve("terraforged");

    public static Path rtf(String path) {
        return RTF_CONFIG_PATH.resolve(path);
    }

    public static Path legacy(String path) {
        return LEGACY_CONFIG_PATH.resolve(path);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigPath() {
        return ConfigUtilImpl.getConfigPath();
    }

    static {
        if (!Files.exists(RTF_CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createDirectory(RTF_CONFIG_PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

