/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.mixin;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.concurrent.ThreadPools;
import raccoonman.reterraforged.config.PerformanceConfig;
import raccoonman.reterraforged.data.worldgen.compat.terrablender.TBNoiseRouterData;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.registries.RTFRegistries;
import raccoonman.reterraforged.tags.RTFDensityFunctionTags;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.WorldLookup;
import raccoonman.reterraforged.world.worldgen.densityfunction.CellSampler;
import raccoonman.reterraforged.world.worldgen.densityfunction.NoiseFunction;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.terrablender.TBClimateSampler;
import raccoonman.reterraforged.world.worldgen.terrablender.TBCompat;

@Mixin(value={RandomState.class})
@Implements(value={@Interface(iface=RTFRandomState.class, prefix="reterraforged$RTFRandomState$")})
class MixinRandomState {
    private DensityFunction.Visitor densityFunctionWrapper;
    @Shadow
    @Final
    private Climate.Sampler f_224549_;
    @Shadow
    @Final
    private SurfaceSystem f_224550_;
    @Deprecated
    private boolean hasContext;
    @Nullable
    private GeneratorContext generatorContext;
    @Nullable
    private Preset preset;
    private long seed;

    MixinRandomState() {
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/NoiseRouter;mapAll(Lnet/minecraft/world/level/levelgen/DensityFunction$Visitor;)Lnet/minecraft/world/level/levelgen/NoiseRouter;"), method={"<init>"}, require=1)
    private NoiseRouter RandomState(NoiseRouter router, final DensityFunction.Visitor visitor, NoiseGeneratorSettings noiseGeneratorSettings, HolderGetter<NormalNoise.NoiseParameters> params, final long seed) {
        this.seed = seed;
        this.densityFunctionWrapper = new DensityFunction.Visitor(){

            public DensityFunction m_214017_(DensityFunction function) {
                if (function instanceof NoiseFunction.Marker) {
                    NoiseFunction.Marker marker = (NoiseFunction.Marker)function;
                    return new NoiseFunction(marker.noise(), (int)seed);
                }
                if (function instanceof CellSampler.Marker) {
                    CellSampler.Marker marker = (CellSampler.Marker)function;
                    MixinRandomState.this.hasContext |= true;
                    return new CellSampler((Supplier<WorldLookup>)Suppliers.memoize(() -> MixinRandomState.this.generatorContext.lookup), marker.field());
                }
                return visitor.m_214017_(function);
            }

            public DensityFunction.NoiseHolder m_213918_(DensityFunction.NoiseHolder noiseHolder) {
                return visitor.m_213918_(noiseHolder);
            }
        };
        return router.m_224412_(this.densityFunctionWrapper);
    }

    public void reterraforged$RTFRandomState$initialize(RegistryAccess registries) {
        HolderLookup.RegistryLookup presets = registries.m_255025_(RTFRegistries.PRESET);
        HolderLookup.RegistryLookup noises = registries.m_255025_(RTFRegistries.NOISE);
        HolderLookup.RegistryLookup functions = registries.m_255025_(Registries.f_257040_);
        functions.m_254901_(RTFDensityFunctionTags.ADDITIONAL_NOISE_ROUTER_FUNCTIONS).ifPresent(set -> set.forEach(function -> ((DensityFunction)function.m_203334_()).m_207456_(this.densityFunctionWrapper)));
        Climate.Sampler sampler = this.f_224549_;
        if (sampler instanceof TBClimateSampler) {
            TBClimateSampler tbClimateSampler = (TBClimateSampler)sampler;
            if (TBCompat.isEnabled()) {
                functions.m_254902_(TBNoiseRouterData.UNIQUENESS).ifPresent(uniqueness -> tbClimateSampler.setUniqueness(((DensityFunction)uniqueness.m_203334_()).m_207456_(this.densityFunctionWrapper)));
            }
        }
        presets.m_254902_(Preset.KEY).ifPresentOrElse(presetHolder -> {
            this.preset = (Preset)presetHolder.m_203334_();
            if (this.hasContext) {
                PerformanceConfig config = PerformanceConfig.read(PerformanceConfig.DEFAULT_FILE_PATH).resultOrPartial(arg_0 -> ((Logger)RTFCommon.LOGGER).error(arg_0)).orElseGet(PerformanceConfig::makeDefault);
                this.generatorContext = GeneratorContext.makeCached(this.preset, (HolderGetter<Noise>)noises, (int)this.seed, config.tileSize(), config.batchCount(), ThreadPools.availableProcessors() > 4);
            }
        }, () -> {
            if (this.hasContext) {
                // empty if block
            }
        });
    }

    @Nullable
    public Preset reterraforged$RTFRandomState$preset() {
        return this.preset;
    }

    @Nullable
    public GeneratorContext reterraforged$RTFRandomState$generatorContext() {
        return this.generatorContext;
    }

    @Nullable
    public DensityFunction reterraforged$RTFRandomState$wrap(DensityFunction function) {
        return function.m_207456_(this.densityFunctionWrapper);
    }

    public Noise reterraforged$RTFRandomState$seed(Noise noise) {
        return Noises.shiftSeed(noise, (int)this.seed);
    }
}

