/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.mixin;

import java.util.Objects;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.densityfunction.CellSampler;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;

@Mixin(value={NoiseChunk.class})
class MixinNoiseChunk {
    private RandomState randomState;
    private int chunkX;
    private int chunkZ;
    @Nullable
    private Tile.Chunk chunk;
    private CellSampler.Cache2d cache2d;
    @Shadow
    @Final
    int f_188723_;
    @Shadow
    @Final
    int f_188724_;
    @Shadow
    @Final
    private int f_188718_;

    MixinNoiseChunk() {
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/RandomState;router()Lnet/minecraft/world/level/levelgen/NoiseRouter;"), method={"<init>"})
    private NoiseRouter NoiseChunk(RandomState randomState1, int cellCountXZ, RandomState randomState2, int minBlockX, int minBlockZ) {
        this.randomState = randomState1;
        this.chunkX = SectionPos.m_123171_((int)minBlockX);
        this.chunkZ = SectionPos.m_123171_((int)minBlockZ);
        RandomState randomState = this.randomState;
        if (randomState instanceof RTFRandomState) {
            GeneratorContext generatorContext;
            RTFRandomState rtfRandomState = (RTFRandomState)randomState;
            if (cellCountXZ > 1 && (generatorContext = rtfRandomState.generatorContext()) != null) {
                this.chunk = generatorContext.cache.provideAtChunk(this.chunkX, this.chunkZ).getChunkReader(this.chunkX, this.chunkZ);
            }
        }
        this.cache2d = new CellSampler.Cache2d();
        return this.randomState.m_224578_();
    }

    @ModifyVariable(method={"<init>"}, at=@At(value="HEAD"), name={"fluidPicker"}, index=7, ordinal=0, argsOnly=true)
    private static Aquifer.FluidPicker modifyFluidPicker(Aquifer.FluidPicker fluidPicker, int i, RandomState randomState, int j, int k, NoiseSettings noiseSettings, DensityFunctions.BeardifierOrMarker beardifierOrMarker, NoiseGeneratorSettings noiseGeneratorSettings) {
        RTFRandomState rtfRandomState;
        Preset preset;
        RandomState randomState2 = randomState;
        if (randomState2 instanceof RTFRandomState && (preset = (rtfRandomState = (RTFRandomState)randomState2).preset()) != null && rtfRandomState.generatorContext() != null) {
            int lavaLevel = preset.world().properties.lavaLevel;
            Aquifer.FluidStatus lava = new Aquifer.FluidStatus(lavaLevel, Blocks.f_49991_.m_49966_());
            int seaLevel = noiseGeneratorSettings.f_64444_();
            Aquifer.FluidStatus defaultFluid = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.f_64441_());
            return (x, y, z) -> {
                if (y < Math.min(lavaLevel, seaLevel)) {
                    return lava;
                }
                return defaultFluid;
            };
        }
        return fluidPicker;
    }

    @Inject(at={@At(value="HEAD")}, method={"wrapNew"}, cancellable=true)
    private void wrapNew(DensityFunction function, CallbackInfoReturnable<DensityFunction> callback) {
        RandomState randomState = this.randomState;
        if (randomState instanceof RTFRandomState) {
            RTFRandomState randomState2 = (RTFRandomState)randomState;
            if (function instanceof CellSampler) {
                CellSampler mapped;
                CellSampler cellSampler = mapped = (CellSampler)function;
                Objects.requireNonNull(cellSampler);
                callback.setReturnValue((Object)new CellSampler.CacheChunk(cellSampler, this.chunk, this.cache2d, this.chunkX, this.chunkZ));
            }
        }
    }
}

