/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.data.worldgen.preset.settings.ContinentType;
import raccoonman.reterraforged.data.worldgen.preset.settings.SpawnType;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;

public class WorldSettings {
    public static final Codec<WorldSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Continent.CODEC.fieldOf("continent").forGetter(o -> o.continent), (App)ControlPoints.CODEC.fieldOf("controlPoints").forGetter(o -> o.controlPoints), (App)Properties.CODEC.fieldOf("properties").forGetter(o -> o.properties)).apply((Applicative)instance, WorldSettings::new));
    public Continent continent;
    public ControlPoints controlPoints;
    public Properties properties;

    public WorldSettings(Continent continent, ControlPoints controlPoints, Properties properties) {
        this.continent = continent;
        this.controlPoints = controlPoints;
        this.properties = properties;
    }

    public WorldSettings copy() {
        return new WorldSettings(this.continent.copy(), this.controlPoints.copy(), this.properties.copy());
    }

    public static class Continent {
        public static final Codec<Continent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContinentType.CODEC.fieldOf("continentType").forGetter(o -> o.continentType), (App)DistanceFunction.CODEC.optionalFieldOf("continentShape", (Object)DistanceFunction.EUCLIDEAN).forGetter(o -> o.continentShape), (App)Codec.INT.fieldOf("continentScale").forGetter(o -> o.continentScale), (App)Codec.FLOAT.fieldOf("continentJitter").forGetter(o -> Float.valueOf(o.continentJitter)), (App)Codec.FLOAT.optionalFieldOf("continentSkipping", (Object)Float.valueOf(0.25f)).forGetter(o -> Float.valueOf(o.continentSkipping)), (App)Codec.FLOAT.optionalFieldOf("continentSizeVariance", (Object)Float.valueOf(0.25f)).forGetter(o -> Float.valueOf(o.continentSizeVariance)), (App)Codec.INT.optionalFieldOf("continentNoiseOctaves", (Object)5).forGetter(o -> o.continentNoiseOctaves), (App)Codec.FLOAT.optionalFieldOf("continentNoiseGain", (Object)Float.valueOf(0.26f)).forGetter(o -> Float.valueOf(o.continentNoiseGain)), (App)Codec.FLOAT.optionalFieldOf("continentNoiseLacunarity", (Object)Float.valueOf(4.33f)).forGetter(o -> Float.valueOf(o.continentNoiseLacunarity))).apply((Applicative)instance, Continent::new));
        public ContinentType continentType;
        public DistanceFunction continentShape;
        public int continentScale;
        public float continentJitter;
        public float continentSkipping;
        public float continentSizeVariance;
        public int continentNoiseOctaves;
        public float continentNoiseGain;
        public float continentNoiseLacunarity;

        public Continent(ContinentType continentType, DistanceFunction continentShape, int continentScale, float continentJitter, float continentSkipping, float continentSizeVariance, int continentNoiseOctaves, float continentNoiseGain, float continentNoiseLacunarity) {
            this.continentType = continentType;
            this.continentShape = continentShape;
            this.continentScale = continentScale;
            this.continentJitter = continentJitter;
            this.continentSkipping = continentSkipping;
            this.continentSizeVariance = continentSizeVariance;
            this.continentNoiseOctaves = continentNoiseOctaves;
            this.continentNoiseGain = continentNoiseGain;
            this.continentNoiseLacunarity = continentNoiseLacunarity;
        }

        public Continent copy() {
            return new Continent(this.continentType, this.continentShape, this.continentScale, this.continentJitter, this.continentSkipping, this.continentSizeVariance, this.continentNoiseOctaves, this.continentNoiseGain, this.continentNoiseLacunarity);
        }
    }

    public static class ControlPoints {
        public static final Codec<ControlPoints> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("islandInland", (Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.islandInland)), (App)Codec.FLOAT.optionalFieldOf("islandCoast", (Object)Float.valueOf(0.1f)).forGetter(o -> Float.valueOf(o.islandCoast)), (App)Codec.FLOAT.fieldOf("deepOcean").forGetter(o -> Float.valueOf(o.deepOcean)), (App)Codec.FLOAT.fieldOf("shallowOcean").forGetter(o -> Float.valueOf(o.shallowOcean)), (App)Codec.FLOAT.fieldOf("beach").forGetter(o -> Float.valueOf(o.beach)), (App)Codec.FLOAT.fieldOf("coast").forGetter(o -> Float.valueOf(o.coast)), (App)Codec.FLOAT.fieldOf("inland").forGetter(o -> Float.valueOf(o.inland))).apply((Applicative)instance, ControlPoints::new));
        public float islandInland;
        public float islandCoast;
        public float deepOcean;
        public float shallowOcean;
        public float beach;
        public float coast;
        public float inland;

        public ControlPoints(float islandInland, float islandCoast, float deepOcean, float shallowOcean, float beach, float coast, float inland) {
            this.islandInland = islandInland;
            this.islandCoast = islandCoast;
            this.deepOcean = deepOcean;
            this.shallowOcean = shallowOcean;
            this.beach = beach;
            this.coast = coast;
            this.inland = inland;
        }

        public float coastMarker() {
            return this.coast + (this.inland - this.coast) / 2.0f;
        }

        public ControlPoints copy() {
            return new ControlPoints(this.islandInland, this.islandCoast, this.deepOcean, this.shallowOcean, this.beach, this.coast, this.inland);
        }
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpawnType.CODEC.fieldOf("spawnType").forGetter(o -> o.spawnType), (App)Codec.INT.fieldOf("worldHeight").forGetter(o -> o.worldHeight), (App)Codec.INT.optionalFieldOf("worldDepth", (Object)64).forGetter(o -> o.worldDepth), (App)Codec.INT.fieldOf("seaLevel").forGetter(o -> o.seaLevel), (App)Codec.INT.optionalFieldOf("lavaLevel", (Object)-54).forGetter(o -> o.lavaLevel)).apply((Applicative)instance, Properties::new));
        public SpawnType spawnType;
        public int worldHeight;
        public int worldDepth;
        public int seaLevel;
        public int lavaLevel;

        public Properties(SpawnType spawnType, int worldHeight, int worldDepth, int seaLevel, int lavaLevel) {
            this.spawnType = spawnType;
            this.worldHeight = worldHeight;
            this.worldDepth = worldDepth;
            this.seaLevel = seaLevel;
            this.lavaLevel = lavaLevel;
        }

        public Properties copy() {
            return new Properties(this.spawnType, this.worldHeight, this.worldDepth, this.seaLevel, this.lavaLevel);
        }

        @Deprecated
        public int terrainScaler() {
            return Math.min(this.worldHeight, 256);
        }
    }
}

