/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset.settings;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Climate;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.util.PosUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpawnType implements StringRepresentable
{
    CONTINENT_CENTER("CONTINENT_CENTER"){
        private static final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
        private static final Climate.Parameter SURFACE_DEPTH = Climate.Parameter.m_186820_((float)0.0f);
        private static final Climate.Parameter INLAND_CONTINENTALNESS = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);

        @Override
        public BlockPos getSearchCenter(GeneratorContext ctx) {
            long center = ctx.generator.getHeightmap().continent().getNearestCenter(0.0f, 0.0f);
            return new BlockPos(PosUtil.unpackLeft(center), 0, PosUtil.unpackRight(center));
        }

        @Override
        public List<Climate.ParameterPoint> getParameterPoints() {
            return List.of(new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)INLAND_CONTINENTALNESS, (Climate.Parameter)FULL_RANGE), FULL_RANGE, SURFACE_DEPTH, FULL_RANGE, 0L), new Climate.ParameterPoint(FULL_RANGE, FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)INLAND_CONTINENTALNESS, (Climate.Parameter)FULL_RANGE), FULL_RANGE, SURFACE_DEPTH, FULL_RANGE, 0L));
        }
    }
    ,
    ISLANDS("ISLANDS"){

        @Override
        public BlockPos getSearchCenter(GeneratorContext ctx) {
            return BlockPos.f_121853_;
        }

        @Override
        public List<Climate.ParameterPoint> getParameterPoints() {
            return ImmutableList.of();
        }
    }
    ,
    WORLD_ORIGIN("WORLD_ORIGIN"){

        @Override
        public BlockPos getSearchCenter(GeneratorContext ctx) {
            return BlockPos.f_121853_;
        }

        @Override
        public List<Climate.ParameterPoint> getParameterPoints() {
            return ImmutableList.of();
        }
    };

    public static final Codec<SpawnType> CODEC;
    private String name;

    private SpawnType(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public abstract BlockPos getSearchCenter(GeneratorContext var1);

    public abstract List<Climate.ParameterPoint> getParameterPoints();

    static {
        CODEC = StringRepresentable.m_216439_(SpawnType::values);
    }
}

