/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class RiverSettings {
    public static final Codec<RiverSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("seedOffset").forGetter(o -> o.seedOffset), (App)Codec.INT.fieldOf("riverCount").forGetter(o -> o.riverCount), (App)River.CODEC.fieldOf("mainRivers").forGetter(o -> o.mainRivers), (App)River.CODEC.fieldOf("branchRivers").forGetter(o -> o.branchRivers), (App)Lake.CODEC.fieldOf("lakes").forGetter(o -> o.lakes), (App)Wetland.CODEC.fieldOf("wetlands").forGetter(o -> o.wetlands)).apply((Applicative)instance, RiverSettings::new));
    public int seedOffset;
    public int riverCount;
    public River mainRivers;
    public River branchRivers;
    public Lake lakes;
    public Wetland wetlands;

    public RiverSettings(int seedOffset, int riverCount, River mainRivers, River branchRivers, Lake lakes, Wetland wetlands) {
        this.seedOffset = seedOffset;
        this.riverCount = riverCount;
        this.mainRivers = mainRivers;
        this.branchRivers = branchRivers;
        this.lakes = lakes;
        this.wetlands = wetlands;
    }

    public RiverSettings copy() {
        return new RiverSettings(this.seedOffset, this.riverCount, this.mainRivers.copy(), this.branchRivers.copy(), this.lakes.copy(), this.wetlands.copy());
    }

    public static class River {
        public static final Codec<River> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("bedDepth").forGetter(o -> o.bedDepth), (App)Codec.INT.fieldOf("minBankHeight").forGetter(o -> o.minBankHeight), (App)Codec.INT.fieldOf("maxBankHeight").forGetter(o -> o.maxBankHeight), (App)Codec.INT.fieldOf("bankWidth").forGetter(o -> o.bankWidth), (App)Codec.INT.fieldOf("bedWidth").forGetter(o -> o.bedWidth), (App)Codec.FLOAT.fieldOf("fade").forGetter(o -> Float.valueOf(o.fade))).apply((Applicative)instance, River::new));
        public int bedDepth;
        public int minBankHeight;
        public int maxBankHeight;
        public int bedWidth;
        public int bankWidth;
        public float fade;

        public River(int bedDepth, int minBankHeight, int maxBankHeight, int bankWidth, int bedWidth, float fade) {
            this.bedDepth = bedDepth;
            this.minBankHeight = minBankHeight;
            this.maxBankHeight = maxBankHeight;
            this.bankWidth = bankWidth;
            this.bedWidth = bedWidth;
            this.fade = fade;
        }

        public River copy() {
            return new River(this.bedDepth, this.minBankHeight, this.maxBankHeight, this.bankWidth, this.bedWidth, this.fade);
        }
    }

    public static class Lake {
        public static final Codec<Lake> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("chance").forGetter(o -> Float.valueOf(o.chance)), (App)Codec.FLOAT.fieldOf("minStartDistance").forGetter(o -> Float.valueOf(o.minStartDistance)), (App)Codec.FLOAT.fieldOf("maxStartDistance").forGetter(o -> Float.valueOf(o.maxStartDistance)), (App)Codec.INT.fieldOf("depth").forGetter(o -> o.depth), (App)Codec.INT.fieldOf("sizeMin").forGetter(o -> o.sizeMin), (App)Codec.INT.fieldOf("sizeMax").forGetter(o -> o.sizeMax), (App)Codec.INT.fieldOf("minBankHeight").forGetter(o -> o.minBankHeight), (App)Codec.INT.fieldOf("maxBankHeight").forGetter(o -> o.maxBankHeight)).apply((Applicative)instance, Lake::new));
        public float chance;
        public float minStartDistance;
        public float maxStartDistance;
        public int depth;
        public int sizeMin;
        public int sizeMax;
        public int minBankHeight;
        public int maxBankHeight;

        public Lake(float chance, float minStartDistance, float maxStartDistance, int depth, int sizeMin, int sizeMax, int minBankHeight, int maxBankHeight) {
            this.chance = chance;
            this.minStartDistance = minStartDistance;
            this.maxStartDistance = maxStartDistance;
            this.depth = depth;
            this.sizeMin = sizeMin;
            this.sizeMax = sizeMax;
            this.minBankHeight = minBankHeight;
            this.maxBankHeight = maxBankHeight;
        }

        public Lake copy() {
            return new Lake(this.chance, this.minStartDistance, this.maxStartDistance, this.depth, this.sizeMin, this.sizeMax, this.minBankHeight, this.maxBankHeight);
        }
    }

    public static class Wetland {
        public static final Codec<Wetland> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("chance").forGetter(o -> Float.valueOf(o.chance)), (App)Codec.INT.fieldOf("sizeMin").forGetter(o -> o.sizeMin), (App)Codec.INT.fieldOf("sizeMax").forGetter(o -> o.sizeMax)).apply((Applicative)instance, Wetland::new));
        public float chance;
        public int sizeMin;
        public int sizeMax;

        public Wetland(float chance, int sizeMin, int sizeMax) {
            this.chance = chance;
            this.sizeMin = sizeMin;
            this.sizeMax = sizeMax;
        }

        public Wetland copy() {
            return new Wetland(this.chance, this.sizeMin, this.sizeMax);
        }
    }
}

