/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset;

import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseData;
import raccoonman.reterraforged.data.worldgen.preset.PresetTerrainTypeNoise;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.EdgeFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public class PresetTerrainNoise {
    public static final ResourceKey<Noise> MOUNTAIN_CHAIN_ALPHA = PresetTerrainNoise.createKey("mountain_chain_alpha");
    public static final ResourceKey<Noise> RIVER_ALPHA = PresetTerrainNoise.createKey("river_alpha");
    public static final ResourceKey<Noise> LAKE_ALPHA = PresetTerrainNoise.createKey("lake_alpha");
    public static final ResourceKey<Noise> SWAMP_ALPHA = PresetTerrainNoise.createKey("swamp_alpha");
    public static final ResourceKey<Noise> EROSION = PresetTerrainNoise.createKey("erosion");
    public static final ResourceKey<Noise> RIDGES = PresetTerrainNoise.createKey("ridges");
    public static final ResourceKey<Noise> RIDGES_FOLDED = PresetTerrainNoise.createKey("ridges_folded");
    public static final ResourceKey<Noise> OFFSET = PresetTerrainNoise.createKey("offset");

    public static void bootstrap(Preset preset, BootstapContext<Noise> ctx) {
        PresetTerrainTypeNoise.bootstrap(preset, ctx);
        Noise mountainChainAlpha = PresetNoiseData.registerAndWrap(ctx, MOUNTAIN_CHAIN_ALPHA, PresetTerrainNoise.makeMountainChainAlpha(0));
        Noise erosion = PresetNoiseData.registerAndWrap(ctx, EROSION, PresetTerrainNoise.makeErosion(mountainChainAlpha));
        Noise ridges = PresetNoiseData.registerAndWrap(ctx, RIDGES, PresetTerrainNoise.makeRidges(mountainChainAlpha));
    }

    private static Noise makeMountainChainAlpha(int mountainSeed) {
        Noise mountainShape = Noises.worleyEdge(mountainSeed++, 1000, EdgeFunction.DISTANCE_2_ADD, DistanceFunction.EUCLIDEAN);
        mountainShape = Noises.warpPerlin(mountainShape, mountainSeed++, 333, 2, 250.0f);
        mountainShape = Noises.curve(mountainShape, Interpolation.CURVE3);
        mountainShape = Noises.clamp(mountainShape, 0.0f, 0.9f);
        mountainShape = Noises.map(mountainShape, 0.0f, 1.0f);
        return mountainShape;
    }

    private static Noise peaksAndValleys(Noise noise) {
        return Noises.mul(Noises.add(Noises.abs(Noises.add(Noises.abs(noise), Noises.constant(-0.6666667f))), Noises.constant(-0.33333334f)), Noises.constant(-3.0f));
    }

    private static Noise makeErosion(Noise mountainChainAlpha) {
        return Noises.mul(Noises.perlin(0, 1, 200), Noises.worley(0, 200));
    }

    private static Noise makeRidges(Noise mountainChainAlpha) {
        return Noises.mul(Noises.perlin(0, 1, 200), Noises.worley(0, 200));
    }

    protected static ResourceKey<Noise> createKey(String name) {
        return PresetNoiseData.createKey("terrain/" + name);
    }
}

