/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset;

import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseData;
import raccoonman.reterraforged.data.worldgen.preset.settings.MiscellaneousSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.util.Scaling;

public class PresetSurfaceNoise {
    public static final ResourceKey<Noise> DESERT = PresetSurfaceNoise.createKey("desert");
    public static final ResourceKey<Noise> SWAMP = PresetSurfaceNoise.createKey("swamp");
    public static final ResourceKey<Noise> FOREST = PresetSurfaceNoise.createKey("forest");
    public static final ResourceKey<Noise> ICEBERG_DEEP_SHAPE = PresetSurfaceNoise.createKey("iceberg/deep/shape");
    public static final ResourceKey<Noise> ICEBERG_DEEP_MASK = PresetSurfaceNoise.createKey("iceberg/deep/mask");
    public static final ResourceKey<Noise> ICEBERG_DEEP_FADE_DOWN = PresetSurfaceNoise.createKey("iceberg/deep/fade_down");
    public static final ResourceKey<Noise> ICEBERG_DEEP_FADE_UP = PresetSurfaceNoise.createKey("iceberg/deep/fade_up");
    public static final ResourceKey<Noise> ICEBERG_DEEP_UP = PresetSurfaceNoise.createKey("iceberg/deep/up");
    public static final ResourceKey<Noise> ICEBERG_DEEP_DOWN = PresetSurfaceNoise.createKey("iceberg/deep/down");
    public static final ResourceKey<Noise> ICEBERG_DEEP_TOP = PresetSurfaceNoise.createKey("iceberg/deep/top");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_SHAPE = PresetSurfaceNoise.createKey("iceberg/shallow/shape");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_MASK = PresetSurfaceNoise.createKey("iceberg/shallow/mask");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_FADE_DOWN = PresetSurfaceNoise.createKey("iceberg/shallow/fade_down");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_FADE_UP = PresetSurfaceNoise.createKey("iceberg/shallow/fade_up");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_UP = PresetSurfaceNoise.createKey("iceberg/shallow/up");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_DOWN = PresetSurfaceNoise.createKey("iceberg/shallow/down");
    public static final ResourceKey<Noise> ICEBERG_SHALLOW_TOP = PresetSurfaceNoise.createKey("iceberg/shallow/top");
    public static final ResourceKey<Noise> STRATA_SELECTOR = PresetSurfaceNoise.createKey("strata/selector");
    public static final ResourceKey<Noise> STRATA_DEPTH = PresetSurfaceNoise.createKey("strata/depth");
    public static final int GENERATOR_RESOURCE_SEED_OFFSET = 746382634;

    public static void bootstrap(Preset preset, BootstapContext<Noise> ctx) {
        WorldSettings worldSettings = preset.world();
        WorldSettings.Properties properties = worldSettings.properties;
        MiscellaneousSettings miscellaneousSettings = preset.miscellaneous();
        Scaling scaling = Scaling.make(properties.terrainScaler(), properties.seaLevel);
        ctx.m_255272_(DESERT, (Object)PresetSurfaceNoise.makeDesert(scaling));
        ctx.m_255272_(SWAMP, (Object)PresetSurfaceNoise.makeSwamp());
        ctx.m_255272_(FOREST, (Object)PresetSurfaceNoise.makeForest());
        PresetSurfaceNoise.registerIceberg(ctx, ICEBERG_DEEP_SHAPE, ICEBERG_DEEP_MASK, ICEBERG_DEEP_FADE_DOWN, ICEBERG_DEEP_FADE_UP, ICEBERG_DEEP_UP, ICEBERG_DEEP_DOWN, ICEBERG_DEEP_TOP, scaling, 30, 30, 0);
        PresetSurfaceNoise.registerIceberg(ctx, ICEBERG_SHALLOW_SHAPE, ICEBERG_SHALLOW_MASK, ICEBERG_SHALLOW_FADE_DOWN, ICEBERG_SHALLOW_FADE_UP, ICEBERG_SHALLOW_UP, ICEBERG_SHALLOW_DOWN, ICEBERG_SHALLOW_TOP, scaling, 20, 15, 6);
        ctx.m_255272_(STRATA_SELECTOR, (Object)PresetSurfaceNoise.makeStrataSelector(miscellaneousSettings.strataRegionSize));
        ctx.m_255272_(STRATA_DEPTH, (Object)PresetSurfaceNoise.makeStrataDepth());
    }

    private static Noise makeDesert(Scaling scaling) {
        int seed = 12;
        Noise noise = Noises.perlin(seed++, 8, 1);
        noise = Noises.mul(noise, scaling.blocks(16));
        return PresetSurfaceNoise.generatorResource(noise);
    }

    private static Noise makeSwamp() {
        int seed = 13;
        Noise noise = Noises.simplex(seed++, 40, 2);
        noise = Noises.warpWhite(noise, seed, 2, 4.0f);
        return PresetSurfaceNoise.generatorResource(noise);
    }

    private static Noise makeForest() {
        int seed = 15;
        Noise noise = Noises.simplex(seed++, 50, 2);
        noise = Noises.warpWhite(noise, seed, 2, 3.0f);
        return PresetSurfaceNoise.generatorResource(noise);
    }

    private static void registerIceberg(BootstapContext<Noise> ctx, ResourceKey<Noise> shapeKey, ResourceKey<Noise> maskKey, ResourceKey<Noise> fadeDownKey, ResourceKey<Noise> fadeUpKey, ResourceKey<Noise> upKey, ResourceKey<Noise> downKey, ResourceKey<Noise> topKey, Scaling scaling, int height, int depth, int seedOffset) {
        int seed = 746382634 + seedOffset;
        Noise shape = Noises.perlin(seed++, 65, 3);
        shape = Noises.warpPerlin(shape, seed++, 15, 1, 10.0f);
        shape = PresetNoiseData.registerAndWrap(ctx, shapeKey, Noises.cache2d(shape));
        Noise mask = PresetNoiseData.registerAndWrap(ctx, maskKey, Noises.threshold(shape, 0.0f, 1.0f, 0.6f));
        Noise fadeDown = Noises.clamp(shape, 0.6f, 0.725f);
        fadeDown = PresetNoiseData.registerAndWrap(ctx, fadeDownKey, Noises.map(fadeDown, 0.0f, 1.0f));
        Noise fadeUp = Noises.clamp(shape, 0.6f, 0.65f);
        fadeUp = PresetNoiseData.registerAndWrap(ctx, fadeUpKey, Noises.map(fadeUp, 0.0f, 1.0f));
        Noise up = Noises.perlinRidge(seed++, 50, 3);
        up = Noises.mul(up, mask);
        up = Noises.mul(up, fadeUp);
        ctx.m_255272_(upKey, (Object)Noises.mul(up, scaling.blocks(height)));
        Noise down = Noises.perlinRidge(seed++, 60, 3);
        down = Noises.mul(down, mask);
        down = Noises.mul(down, fadeDown);
        ctx.m_255272_(downKey, (Object)Noises.mul(down, scaling.blocks(depth)));
        Noise top = Noises.perlinRidge(seed++, 25, 2);
        top = Noises.mul(top, scaling.blocks(3));
        ctx.m_255272_(topKey, (Object)Noises.add(top, scaling.blocks(2)));
    }

    private static Noise makeStrataSelector(int regionSize) {
        Noise noise = Noises.worley(0, regionSize);
        noise = Noises.warpPerlin(noise, 1, regionSize / 4, 2, (float)regionSize / 2.0f);
        noise = Noises.warpPerlin(noise, 2, 15, 2, 30.0f);
        return noise;
    }

    private static Noise makeStrataDepth() {
        return Noises.perlin(0, 128, 3);
    }

    private static Noise generatorResource(Noise noise) {
        return Noises.shiftSeed(noise, 746382634);
    }

    public static ResourceKey<Noise> createKey(String name) {
        return PresetNoiseData.createKey("surface/" + name);
    }
}

