/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.config;

import com.mojang.serialization.DataResult;
import java.nio.file.Path;
import raccoonman.reterraforged.concurrent.ThreadPools;
import raccoonman.reterraforged.platform.ConfigUtil;

public record PerformanceConfig(int tileSize, int batchCount, int threadCount) {
    public static final Path DEFAULT_FILE_PATH = ConfigUtil.rtf("performance_internal.conf");
    public static final int MAX_TILE_SIZE = 8;
    public static final int MAX_BATCH_COUNT = 20;
    public static final int MAX_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;

    public static DataResult<PerformanceConfig> read(Path path) {
        return DataResult.success((Object)PerformanceConfig.makeDefault());
    }

    public static PerformanceConfig makeDefault() {
        int tileSize = 3;
        int batchCount = 6;
        int threadCount = ThreadPools.availableProcessors();
        return new PerformanceConfig(tileSize, batchCount, threadCount);
    }
}

