/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.concurrent.task;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;

public abstract class LazyCallable<T>
implements Callable<T>,
Future<T>,
Supplier<T> {
    private StampedLock lock = new StampedLock();
    protected volatile T value = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() {
        long optRead = this.lock.tryOptimisticRead();
        T result = this.value;
        if (this.lock.validate(optRead) && result != null) {
            return result;
        }
        long read = this.lock.readLock();
        try {
            result = this.value;
            if (result != null) {
                T t = result;
                return t;
            }
        }
        finally {
            this.lock.unlockRead(read);
        }
        long write = this.lock.writeLock();
        try {
            result = this.value;
            if (result == null) {
                result = this.create();
                Objects.requireNonNull(result);
                this.value = result;
            }
            T t = result;
            return t;
        }
        finally {
            this.lock.unlockWrite(write);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        boolean done;
        long optRead = this.lock.tryOptimisticRead();
        boolean bl = done = this.value != null;
        if (this.lock.validate(optRead)) {
            return done;
        }
        long read = this.lock.readLock();
        try {
            boolean bl2 = this.value != null;
            return bl2;
        }
        finally {
            this.lock.unlockRead(read);
        }
    }

    @Override
    public T get() {
        return this.call();
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        return this.call();
    }

    protected abstract T create();

    public static LazyCallable<Void> adapt(Runnable runnable) {
        return new RunnableAdapter(runnable);
    }

    public static <T> LazyCallable<T> adapt(Callable<T> callable) {
        if (callable instanceof LazyCallable) {
            LazyCallable c = (LazyCallable)callable;
            return c;
        }
        return new CallableAdapter<T>(callable);
    }

    public static <T> LazyCallable<T> adaptComplete(Callable<T> callable) {
        return new CompleteAdapter<T>(callable);
    }

    public static class RunnableAdapter
    extends LazyCallable<Void> {
        private Runnable runnable;

        RunnableAdapter(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        protected Void create() {
            this.runnable.run();
            return null;
        }
    }

    public static class CallableAdapter<T>
    extends LazyCallable<T> {
        private Callable<T> callable;

        public CallableAdapter(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        protected T create() {
            try {
                return this.callable.call();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }

    public static class CompleteAdapter<T>
    extends LazyCallable<T> {
        private Callable<T> callable;

        public CompleteAdapter(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        protected T create() {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    public static class FutureAdapter<T>
    extends LazyCallable<T> {
        private Future<T> future;

        FutureAdapter(Future<T> future) {
            this.future = future;
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        protected T create() {
            try {
                return this.future.get();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }
}

