/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.concurrent.cache;

import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import raccoonman.reterraforged.concurrent.cache.ExpiringEntry;
import raccoonman.reterraforged.concurrent.cache.SafeCloseable;
import raccoonman.reterraforged.concurrent.task.LazyCallable;

public class CacheEntry<T>
extends LazyCallable<T>
implements ExpiringEntry {
    private volatile long timestamp;
    private Future<T> task;

    public CacheEntry(Future<T> task) {
        this.task = task;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public T get() {
        this.timestamp = System.currentTimeMillis();
        return super.get();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void close() {
        Object object = this.value;
        if (object instanceof SafeCloseable) {
            SafeCloseable value = (SafeCloseable)object;
            value.close();
            return;
        }
        object = this.value;
        if (object instanceof AutoCloseable) {
            AutoCloseable value = (AutoCloseable)object;
            try {
                value.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected T create() {
        Future<T> future = this.task;
        if (future instanceof ForkJoinTask) {
            ForkJoinTask task = (ForkJoinTask)future;
            return (T)task.join();
        }
        try {
            return this.task.get();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> CacheEntry<T> supply(Future<T> task) {
        return new CacheEntry<T>(task);
    }
}

