/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.widget;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class Slider
extends AbstractSliderButton {
    private double min;
    private double max;
    private Component name;
    private Format format;
    @Nullable
    private Callback callback;

    public Slider(int x, int y, int width, int height, float initialValue, float min, float max, Component name, Format format, @Nullable Callback callback) {
        super(x, y, width, height, CommonComponents.f_237098_, 0.0);
        this.name = name;
        this.format = format;
        this.min = min;
        this.max = max;
        this.f_93577_ = this.getSliderValue(initialValue);
        this.callback = callback;
        this.m_5695_();
    }

    public void setValue(double value) {
        this.f_93577_ = value;
    }

    public double getValue() {
        return this.f_93577_;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSliderValue(float value) {
        return (Mth.m_14008_((double)value, (double)this.min, (double)this.max) - this.min) / (this.max - this.min);
    }

    public double getLerpedValue() {
        return this.lerpValue(this.f_93577_);
    }

    public double lerpValue(double value) {
        return Mth.m_14139_((double)value, (double)this.min, (double)this.max);
    }

    public double scaleValue(double value) {
        return this.format.scale(this.lerpValue(value));
    }

    public void m_5697_() {
        if (this.callback != null) {
            this.f_93577_ = this.callback.apply(this, this.f_93577_);
        }
    }

    protected void m_5695_() {
        this.m_93666_((Component)CommonComponents.m_178393_((Component)this.name, (Component)Component.m_237113_((String)this.format.getMessage(this.scaleValue((float)this.f_93577_)))));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Format {
        INT{

            @Override
            public double scale(double input) {
                return (int)input;
            }

            @Override
            public String getMessage(double input) {
                return String.valueOf((int)input);
            }
        }
        ,
        FLOAT{

            @Override
            public double scale(double input) {
                return input;
            }

            @Override
            public String getMessage(double input) {
                return String.format("%.3f", input);
            }
        };


        public abstract double scale(double var1);

        public abstract String getMessage(double var1);
    }

    public static interface Callback {
        public double apply(Slider var1, double var2);
    }
}

