/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.client.gui.screen.page.LinkedPageScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.FilterSettingsPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetConfigScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetEditorPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetListPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetWidgets;
import raccoonman.reterraforged.client.gui.screen.presetconfig.TerrainSettingsPage;
import raccoonman.reterraforged.client.gui.widget.Slider;
import raccoonman.reterraforged.client.gui.widget.ValueButton;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.RiverSettings;

class RiverSettingsPage
extends PresetEditorPage {
    private ValueButton<Integer> seedOffset;
    private Slider riverCount;
    private Slider mainRiverBedDepth;
    private Slider mainRiverMinBankHeight;
    private Slider mainRiverMaxBankHeight;
    private Slider mainRiverBedWidth;
    private Slider mainRiverBankWidth;
    private Slider mainRiverFade;
    private Slider branchRiverBedDepth;
    private Slider branchRiverMinBankHeight;
    private Slider branchRiverMaxBankHeight;
    private Slider branchRiverBedWidth;
    private Slider branchRiverBankWidth;
    private Slider branchRiverFade;
    private Slider lakeChance;
    private Slider lakeMinStartDistance;
    private Slider lakeMaxStartDistance;
    private Slider lakeDepth;
    private Slider lakeSizeMin;
    private Slider lakeSizeMax;
    private Slider lakeMinBankHeight;
    private Slider lakeMaxBankHeight;
    private Slider wetlandChance;
    private Slider wetlandSizeMin;
    private Slider wetlandSizeMax;

    public RiverSettingsPage(PresetConfigScreen screen, PresetListPage.PresetEntry preset) {
        super(screen, preset);
    }

    @Override
    public Component title() {
        return Component.m_237115_((String)RTFTranslationKeys.GUI_RIVER_SETTINGS_TITLE);
    }

    @Override
    public void init() {
        super.init();
        Preset preset = this.preset.getPreset();
        RiverSettings river = preset.rivers();
        this.seedOffset = PresetWidgets.createRandomButton(RTFTranslationKeys.GUI_BUTTON_RIVER_SEED_OFFSET, river.seedOffset, value -> {
            river.seedOffset = value;
            this.regenerate();
        });
        this.riverCount = PresetWidgets.createIntSlider(river.riverCount, 0, 30, RTFTranslationKeys.GUI_SLIDER_RIVER_COUNT, (slider, value) -> {
            river.riverCount = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        RiverSettings.River mainRivers = river.mainRivers;
        this.mainRiverBedDepth = PresetWidgets.createIntSlider(mainRivers.bedDepth, 1, 10, RTFTranslationKeys.GUI_SLIDER_RIVER_BED_DEPTH, (slider, value) -> {
            mainRivers.bedDepth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.mainRiverMinBankHeight = PresetWidgets.createIntSlider(mainRivers.minBankHeight, 0, 10, RTFTranslationKeys.GUI_SLIDER_RIVER_MIN_BANK_HEIGHT, (slider, value) -> {
            mainRivers.minBankHeight = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.mainRiverMaxBankHeight = PresetWidgets.createIntSlider(mainRivers.maxBankHeight, 1, 10, RTFTranslationKeys.GUI_SLIDER_RIVER_MAX_BANK_HEIGHT, (slider, value) -> {
            mainRivers.maxBankHeight = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.mainRiverBedWidth = PresetWidgets.createIntSlider(mainRivers.bedWidth, 1, 20, RTFTranslationKeys.GUI_SLIDER_RIVER_BED_WIDTH, (slider, value) -> {
            mainRivers.bedWidth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.mainRiverBankWidth = PresetWidgets.createIntSlider(mainRivers.bankWidth, 1, 50, RTFTranslationKeys.GUI_SLIDER_RIVER_BANK_WIDTH, (slider, value) -> {
            mainRivers.bankWidth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.mainRiverFade = PresetWidgets.createFloatSlider(mainRivers.fade, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_RIVER_FADE, (slider, value) -> {
            mainRivers.fade = (float)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        RiverSettings.River branchRivers = river.branchRivers;
        this.branchRiverBedDepth = PresetWidgets.createIntSlider(branchRivers.bedDepth, 1, 10, RTFTranslationKeys.GUI_SLIDER_RIVER_BED_DEPTH, (slider, value) -> {
            branchRivers.bedDepth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.branchRiverMinBankHeight = PresetWidgets.createIntSlider(branchRivers.minBankHeight, 0, 10, RTFTranslationKeys.GUI_SLIDER_RIVER_MIN_BANK_HEIGHT, (slider, value) -> {
            branchRivers.minBankHeight = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.branchRiverMaxBankHeight = PresetWidgets.createIntSlider(branchRivers.maxBankHeight, 1, 10, RTFTranslationKeys.GUI_SLIDER_RIVER_MAX_BANK_HEIGHT, (slider, value) -> {
            branchRivers.maxBankHeight = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.branchRiverBedWidth = PresetWidgets.createIntSlider(branchRivers.bedWidth, 1, 20, RTFTranslationKeys.GUI_SLIDER_RIVER_BED_WIDTH, (slider, value) -> {
            branchRivers.bedWidth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.branchRiverBankWidth = PresetWidgets.createIntSlider(branchRivers.bankWidth, 1, 50, RTFTranslationKeys.GUI_SLIDER_RIVER_BANK_WIDTH, (slider, value) -> {
            branchRivers.bankWidth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.branchRiverFade = PresetWidgets.createFloatSlider(branchRivers.fade, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_RIVER_FADE, (slider, value) -> {
            branchRivers.fade = (float)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        RiverSettings.Lake lake = river.lakes;
        this.lakeChance = PresetWidgets.createFloatSlider(lake.chance, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_LAKE_CHANCE, (slider, value) -> {
            lake.chance = (float)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeMinStartDistance = PresetWidgets.createFloatSlider(lake.minStartDistance, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_LAKE_MIN_START_DISTANCE, (slider, value) -> {
            lake.minStartDistance = (float)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeMaxStartDistance = PresetWidgets.createFloatSlider(lake.maxStartDistance, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_LAKE_MAX_START_DISTANCE, (slider, value) -> {
            lake.maxStartDistance = (float)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeDepth = PresetWidgets.createIntSlider(lake.depth, 1, 20, RTFTranslationKeys.GUI_SLIDER_LAKE_DEPTH, (slider, value) -> {
            lake.depth = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeSizeMin = PresetWidgets.createIntSlider(lake.sizeMin, 1, 100, RTFTranslationKeys.GUI_SLIDER_LAKE_SIZE_MIN, (slider, value) -> {
            lake.sizeMin = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeSizeMax = PresetWidgets.createIntSlider(lake.sizeMax, 1, 500, RTFTranslationKeys.GUI_SLIDER_LAKE_SIZE_MAX, (slider, value) -> {
            lake.sizeMax = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeMinBankHeight = PresetWidgets.createIntSlider(lake.minBankHeight, 1, 10, RTFTranslationKeys.GUI_SLIDER_LAKE_MIN_BANK_HEIGHT, (slider, value) -> {
            lake.minBankHeight = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.lakeMaxBankHeight = PresetWidgets.createIntSlider(lake.maxBankHeight, 1, 10, RTFTranslationKeys.GUI_SLIDER_LAKE_MAX_BANK_HEIGHT, (slider, value) -> {
            lake.maxBankHeight = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        RiverSettings.Wetland wetland = river.wetlands;
        this.wetlandChance = PresetWidgets.createFloatSlider(wetland.chance, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_WETLAND_CHANCE, (slider, value) -> {
            wetland.chance = (float)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.wetlandSizeMin = PresetWidgets.createIntSlider(wetland.sizeMin, 50, 500, RTFTranslationKeys.GUI_SLIDER_WETLAND_SIZE_MIN, (slider, value) -> {
            wetland.sizeMin = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.wetlandSizeMax = PresetWidgets.createIntSlider(wetland.sizeMax, 50, 500, RTFTranslationKeys.GUI_SLIDER_WETLAND_SIZE_MAX, (slider, value) -> {
            wetland.sizeMax = (int)slider.scaleValue(value);
            this.regenerate();
            return value;
        });
        this.left.addWidget(this.seedOffset);
        this.left.addWidget(this.riverCount);
        this.left.addWidget(PresetWidgets.createLabel(RTFTranslationKeys.GUI_LABEL_MAIN_RIVERS));
        this.left.addWidget(this.mainRiverBedDepth);
        this.left.addWidget(this.mainRiverMinBankHeight);
        this.left.addWidget(this.mainRiverMaxBankHeight);
        this.left.addWidget(this.mainRiverBedWidth);
        this.left.addWidget(this.mainRiverBankWidth);
        this.left.addWidget(this.mainRiverFade);
        this.left.addWidget(PresetWidgets.createLabel(RTFTranslationKeys.GUI_LABEL_BRANCH_RIVERS));
        this.left.addWidget(this.branchRiverBedDepth);
        this.left.addWidget(this.branchRiverMinBankHeight);
        this.left.addWidget(this.branchRiverMaxBankHeight);
        this.left.addWidget(this.branchRiverBedWidth);
        this.left.addWidget(this.branchRiverBankWidth);
        this.left.addWidget(this.branchRiverFade);
        this.left.addWidget(PresetWidgets.createLabel(RTFTranslationKeys.GUI_LABEL_LAKES));
        this.left.addWidget(this.lakeChance);
        this.left.addWidget(this.lakeMinStartDistance);
        this.left.addWidget(this.lakeMaxStartDistance);
        this.left.addWidget(this.lakeDepth);
        this.left.addWidget(this.lakeSizeMin);
        this.left.addWidget(this.lakeSizeMax);
        this.left.addWidget(this.lakeMinBankHeight);
        this.left.addWidget(this.lakeMaxBankHeight);
        this.left.addWidget(PresetWidgets.createLabel(RTFTranslationKeys.GUI_LABEL_WETLANDS));
        this.left.addWidget(this.wetlandChance);
        this.left.addWidget(this.wetlandSizeMin);
        this.left.addWidget(this.wetlandSizeMax);
    }

    @Override
    public Optional<LinkedPageScreen.Page> previous() {
        return Optional.of(new TerrainSettingsPage((PresetConfigScreen)this.screen, this.preset));
    }

    @Override
    public Optional<LinkedPageScreen.Page> next() {
        return Optional.of(new FilterSettingsPage((PresetConfigScreen)this.screen, this.preset));
    }
}

