/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.apache.commons.compress.utils.FileNameUtils;
import org.jetbrains.annotations.Nullable;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.client.gui.Toasts;
import raccoonman.reterraforged.client.gui.screen.page.BisectedPage;
import raccoonman.reterraforged.client.gui.screen.page.LinkedPageScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetConfigScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetWidgets;
import raccoonman.reterraforged.client.gui.screen.presetconfig.WorldSettingsPage;
import raccoonman.reterraforged.client.gui.widget.Label;
import raccoonman.reterraforged.client.gui.widget.WidgetList;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.Presets;
import raccoonman.reterraforged.platform.ConfigUtil;

class PresetListPage
extends BisectedPage<PresetConfigScreen, PresetEntry, AbstractWidget> {
    private static final Path PRESET_PATH = ConfigUtil.rtf("presets");
    private static final Path EXPORT_PATH = ConfigUtil.rtf("exports");
    private static final Path LEGACY_PRESET_PATH = ConfigUtil.legacy("presets");
    private static final Predicate<String> IS_VALID = Pattern.compile("^[A-Za-z0-9\\-_ ]+$").asPredicate();
    private EditBox input;
    private Button createPreset;
    private Button deletePreset;
    private Button exportAsDatapack;
    private Button copyPreset;
    private Button openPresetFolder;
    private Button openExportFolder;

    public PresetListPage(PresetConfigScreen screen) {
        super(screen);
        try {
            if (!Files.exists(PRESET_PATH, new LinkOption[0])) {
                Files.createDirectory(PRESET_PATH, new FileAttribute[0]);
            }
            if (!Files.exists(EXPORT_PATH, new LinkOption[0])) {
                Files.createDirectory(EXPORT_PATH, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Component title() {
        return Component.m_237115_((String)RTFTranslationKeys.GUI_SELECT_PRESET_TITLE);
    }

    @Override
    public void init() {
        super.init();
        this.input = PresetWidgets.createEditBox(((PresetConfigScreen)this.screen).f_96547_, text -> {
            boolean isValid = this.isValidPresetName((String)text);
            int white = 0xE0E0E0;
            int red = -49360;
            this.createPreset.f_93623_ = isValid;
            this.input.m_94202_(isValid ? 0xE0E0E0 : -49360);
        }, (Component)Component.m_237115_((String)RTFTranslationKeys.GUI_INPUT_PROMPT).m_130940_(ChatFormatting.DARK_GRAY));
        this.createPreset = PresetWidgets.createThrowingButton(RTFTranslationKeys.GUI_BUTTON_CREATE, () -> {
            new PresetEntry((Component)Component.m_237113_((String)this.input.m_94155_()), Presets.makeLegacyDefault(), false, this).save();
            this.rebuildPresets();
            this.input.m_94144_("");
        });
        this.createPreset.f_93623_ = this.isValidPresetName(this.input.m_94155_());
        this.copyPreset = PresetWidgets.createThrowingButton(RTFTranslationKeys.GUI_BUTTON_COPY, () -> {
            String uniqueName;
            PresetEntry preset = (PresetEntry)((Object)((Object)((WidgetList.Entry)this.left.m_93511_()).getWidget()));
            String name = preset.getName().getString();
            int counter = 1;
            while (Files.exists(PRESET_PATH.resolve((uniqueName = name + " (" + counter + ")") + ".json"), new LinkOption[0])) {
                ++counter;
            }
            new PresetEntry((Component)Component.m_237113_((String)uniqueName), preset.getPreset().copy(), false, this).save();
            this.rebuildPresets();
        });
        this.deletePreset = PresetWidgets.createThrowingButton(RTFTranslationKeys.GUI_BUTTON_DELETE, () -> {
            PresetEntry preset = (PresetEntry)((Object)((Object)((WidgetList.Entry)this.left.m_93511_()).getWidget()));
            Files.delete(preset.getPath());
            this.rebuildPresets();
        });
        this.openPresetFolder = PresetWidgets.createThrowingButton(RTFTranslationKeys.GUI_BUTTON_OPEN_PRESET_FOLDER, () -> {
            Util.m_137581_().m_137648_(PRESET_PATH.toUri());
            this.rebuildPresets();
        });
        this.openExportFolder = PresetWidgets.createThrowingButton(RTFTranslationKeys.GUI_BUTTON_OPEN_EXPORT_FOLDER, () -> {
            Util.m_137581_().m_137648_(EXPORT_PATH.toUri());
            this.rebuildPresets();
        });
        this.exportAsDatapack = PresetWidgets.createThrowingButton(RTFTranslationKeys.GUI_BUTTON_EXPORT_AS_DATAPACK, () -> {
            PresetEntry preset = (PresetEntry)((Object)((Object)((WidgetList.Entry)this.left.m_93511_()).getWidget()));
            Path path = EXPORT_PATH.resolve(preset.getName().getString() + ".zip");
            ((PresetConfigScreen)this.screen).exportAsDatapack(path, preset);
            this.rebuildPresets();
            Toasts.notify(RTFTranslationKeys.GUI_BUTTON_EXPORT_SUCCESS, (Component)Component.m_237113_((String)path.toString()), SystemToast.SystemToastIds.WORLD_BACKUP);
        });
        this.right.addWidget(this.input);
        this.right.addWidget(this.createPreset);
        this.right.addWidget(this.copyPreset);
        this.right.addWidget(this.deletePreset);
        this.right.addWidget(this.openPresetFolder);
        this.right.addWidget(this.openExportFolder);
        this.right.addWidget(this.exportAsDatapack);
        this.left.setRenderSelected(true);
        try {
            this.rebuildPresets();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<LinkedPageScreen.Page> previous() {
        return Optional.empty();
    }

    @Override
    public Optional<LinkedPageScreen.Page> next() {
        return Optional.ofNullable(this.left).map(AbstractSelectionList::m_93511_).map(e -> {
            PresetEntry entry = (PresetEntry)((Object)((Object)e.getWidget()));
            if (entry.isBuiltin()) {
                entry = new PresetEntry(entry.name, entry.preset.copy(), true, b -> {});
            }
            return new WorldSettingsPage((PresetConfigScreen)this.screen, entry);
        });
    }

    @Override
    public void onDone() {
        super.onDone();
        WidgetList.Entry selected = (WidgetList.Entry)this.left.m_93511_();
        if (selected != null) {
            try {
                ((PresetConfigScreen)this.screen).applyPreset((PresetEntry)((Object)selected.getWidget()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void selectPreset(@Nullable PresetEntry entry) {
        boolean active;
        ((PresetConfigScreen)this.screen).doneButton.f_93623_ = active = entry != null;
        this.copyPreset.f_93623_ = active;
        this.deletePreset.f_93623_ = active && !entry.isBuiltin();
        this.exportAsDatapack.f_93623_ = active;
        ((PresetConfigScreen)this.screen).nextButton.f_93623_ = active;
    }

    private void rebuildPresets() throws IOException {
        this.selectPreset(null);
        ArrayList<PresetEntry> entries = new ArrayList<PresetEntry>();
        entries.addAll(this.listPresets(PRESET_PATH));
        entries.addAll(this.listPresets(LEGACY_PRESET_PATH));
        entries.add(new PresetEntry((Component)Component.m_237115_((String)RTFTranslationKeys.GUI_DEFAULT_PRESET_NAME).m_130940_(ChatFormatting.GRAY), Presets.makeRTFDefault(), true, this));
        entries.add(new PresetEntry((Component)Component.m_237115_((String)RTFTranslationKeys.GUI_DEFAULT_LEGACY_PRESET_NAME).m_130940_(ChatFormatting.GRAY), Presets.makeLegacyDefault(), true, this));
        entries.add(new PresetEntry((Component)Component.m_237115_((String)RTFTranslationKeys.GUI_BEAUTIFUL_PRESET_NAME).m_130940_(ChatFormatting.GRAY), Presets.makeLegacyBeautiful(), true, this));
        entries.add(new PresetEntry((Component)Component.m_237115_((String)RTFTranslationKeys.GUI_HUGE_BIOMES_PRESET_NAME).m_130940_(ChatFormatting.GRAY), Presets.makeLegacyHugeBiomes(), true, this));
        entries.add(new PresetEntry((Component)Component.m_237115_((String)RTFTranslationKeys.GUI_LITE_PRESET_NAME).m_130940_(ChatFormatting.GRAY), Presets.makeLegacyLite(), true, this));
        entries.add(new PresetEntry((Component)Component.m_237115_((String)RTFTranslationKeys.GUI_VANILLAISH_PRESET_NAME).m_130940_(ChatFormatting.GRAY), Presets.makeLegacyVanillaish(), true, this));
        this.left.m_5988_(entries.stream().map(WidgetList.Entry::new).toList());
    }

    private boolean isValidPresetName(String text) {
        return IS_VALID.test(text) && !this.hasPresetWithName(text);
    }

    private boolean hasPresetWithName(String name) {
        return this.left.m_6702_().stream().filter(entry -> ((PresetEntry)((Object)((Object)entry.getWidget()))).getName().getString().equals(name)).findAny().isPresent();
    }

    private List<PresetEntry> listPresets(Path path) throws IOException {
        ArrayList<PresetEntry> presets = new ArrayList<PresetEntry>();
        if (Files.exists(path, new LinkOption[0])) {
            for (Path presetPath : Files.list(path).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList()) {
                try (BufferedReader reader = Files.newBufferedReader(presetPath);){
                    String base = FileNameUtils.getBaseName((String)presetPath.toString());
                    DataResult result = Preset.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader));
                    Optional error = result.error();
                    if (error.isPresent()) {
                        RTFCommon.LOGGER.error(((DataResult.PartialResult)error.get()).message());
                        continue;
                    }
                    Preset preset = (Preset)result.result().get();
                    presets.add(new PresetEntry((Component)Component.m_237113_((String)base), preset, false, this));
                }
            }
        }
        return presets;
    }

    public static class PresetEntry
    extends Label {
        private Component name;
        private Preset preset;
        private boolean builtin;

        public PresetEntry(Component name, Preset preset, boolean builtin, Button.OnPress onPress) {
            super(-1, -1, -1, -1, onPress, name);
            this.name = name;
            this.preset = preset;
            this.builtin = builtin;
        }

        public PresetEntry(Component name, Preset preset, boolean builtin, PresetListPage page) {
            this(name, preset, builtin, b -> {
                if (b instanceof PresetEntry) {
                    PresetEntry entry = (PresetEntry)b;
                    page.selectPreset(entry);
                }
            });
        }

        public Component getName() {
            return this.name;
        }

        public Preset getPreset() {
            return this.preset;
        }

        public boolean isBuiltin() {
            return this.builtin;
        }

        public Path getPath() {
            return PRESET_PATH.resolve(this.name.getString() + ".json");
        }

        public void save() throws IOException {
            if (!this.builtin) {
                try (BufferedWriter writer = Files.newBufferedWriter(this.getPath(), new OpenOption[0]);
                     JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
                    JsonElement element = (JsonElement)Preset.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.preset).result().orElseThrow();
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("  ");
                    GsonHelper.m_216207_((JsonWriter)jsonWriter, (JsonElement)element, null);
                }
            }
        }
    }
}

